/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.IFadeable;
import edu.rwth.hci.codegestalt.model.ModelNode;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TypeTagCloud
extends ModelNode
implements IFadeable {
    private static final long serialVersionUID = 1L;
    public static String TERM_MAP_PROPERTY = "TypeTagCloud.termMap";
    private SortedMap<String, Double> tags = new TreeMap<String, Double>();
    private int alpha = 255;
    private transient TreeSet<Tag> tagsByWeights = null;

    @Override
    public void setAlpha(int alpha) {
        if (alpha != this.alpha) {
            this.alpha = alpha;
            this.firePropertyChange("IFadeable.alpha", null, new Integer(alpha));
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    public SortedMap<String, Double> getTagsSortedByTerms() {
        return this.tags;
    }

    public SortedSet<Tag> getTagsSortedByWeights() {
        if (this.tagsByWeights == null) {
            this.tagsByWeights = new TreeSet<Tag>(new WeightDescendingTagComparator());
            for (Map.Entry<String, Double> entry : this.tags.entrySet()) {
                this.tagsByWeights.add(new Tag(entry.getKey(), entry.getValue()));
            }
        }
        return this.tagsByWeights;
    }

    public SortedMap<String, Double> getTopTagsSortedByTerms(int count) {
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        if (count < this.getTagsSortedByTerms().size()) {
            SortedSet<Tag> weightMap = this.getTagsSortedByWeights();
            Iterator pos = weightMap.iterator();
            int size = 0;
            while (size < count && pos.hasNext()) {
                Tag tag = (Tag)pos.next();
                result.put(tag.term, tag.weight);
                ++size;
            }
        } else if (count > 0) {
            return this.getTagsSortedByTerms();
        }
        return result;
    }

    public void setTags(SortedMap<String, Double> termMap) {
        SortedMap<String, Double> oldMap = this.getTagsSortedByTerms();
        this.tags = termMap;
        this.tagsByWeights = null;
        this.firePropertyChange(TERM_MAP_PROPERTY, oldMap, this.getTagsSortedByTerms());
    }

    public double getMaximumWeight() {
        return this.getTagsSortedByWeights().first().weight;
    }

    public String toString() {
        return this.getTagsSortedByTerms().toString();
    }

    public class Tag {
        public String term = "";
        public Double weight = 0.0;

        public Tag(String term, Double weight) {
            this.term = term;
            this.weight = weight;
        }

        public String toString() {
            return String.valueOf(this.term) + ": " + this.weight.toString();
        }
    }

    public class TermAscendingTagComparator
    implements Comparator<Tag>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Tag tag0, Tag tag1) {
            return tag0.term.compareTo(tag1.term);
        }
    }

    public class WeightDescendingTagComparator
    implements Comparator<Tag>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Tag tag0, Tag tag1) {
            int sgn = (int)Math.signum(tag1.weight - tag0.weight);
            if (sgn == 0) {
                return tag0.term.compareTo(tag1.term);
            }
            return sgn;
        }
    }
}

