/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.Activator;
import edu.rwth.hci.codegestalt.model.FirePropertyChangeRunnable;
import edu.rwth.hci.codegestalt.model.IFadeable;
import edu.rwth.hci.codegestalt.model.InheritanceRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.model.Positionable;
import edu.rwth.hci.codegestalt.model.TypeBg;
import edu.rwth.hci.codegestalt.model.TypeHeader;
import edu.rwth.hci.codegestalt.model.TypeTagCloud;
import edu.rwth.hci.codegestalt.tools.StringComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class Type
extends Positionable
implements IFadeable {
    private static final long serialVersionUID = 1L;
    public static final String CHILD_ADDED_PROPERTY = "Type.childAdded";
    public static final String CHILD_REMOVED_PROPERTY = "Type.childRemoved";
    public static final String INCOMING_INHERITANCE_ADDED = "Type.incomingInheritanceAdded";
    public static final String OUTGOING_INHERITANCE_ADDED = "Type.outgoingInheritanceAdded";
    public static final String INCOMING_INHERITANCE_REMOVED = "Type.incomingInheritanceRemoved";
    public static final String OUTGOING_INHERITANCE_REMOVED = "Type.outgoingInheritanceRemoved";
    public static final String TAG_CLOUD_CHANGED = "Type.tagCloudChanged";
    private int alpha = 255;
    private String handleIdentifier = "[not set]";
    private transient IType jdtData = null;
    private TypeHeader header = new TypeHeader("null", "null");
    private SortedMap<String, Member> membersMap = new TreeMap<String, Member>(new StringComparator());
    private List<Member> members = new ArrayList<Member>(10);
    private TypeTagCloud tags = new TypeTagCloud();
    private SortedMap<String, InheritanceRelation> incomingInheritances = new TreeMap<String, InheritanceRelation>(new StringComparator());
    private SortedMap<String, InheritanceRelation> outgoingInheritances = new TreeMap<String, InheritanceRelation>(new StringComparator());
    private TypeBg background = new TypeBg();

    public IType getJdtData() {
        return this.jdtData;
    }

    public boolean isValid() {
        return this.getJdtData() != null;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.firePropertyChange("IFadeable.alpha", null, new Integer(alpha));
            for (InheritanceRelation relation : this.getOutgoingInheritances().values()) {
                relation.setAlpha(alpha);
            }
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handleIdentifier) {
        this.handleIdentifier = handleIdentifier;
        this.refreshJdtData();
    }

    public String getShortName() {
        if (this.isValid()) {
            try {
                if (this.getJdtData().isAnonymous()) {
                    return "[anonymous " + this.getJdtData().getSuperclassName() + "]";
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            return this.getJdtData().getElementName();
        }
        return "null";
    }

    public String getPackageName() {
        if (this.isValid()) {
            return this.getJdtData().getPackageFragment().getElementName();
        }
        return "null";
    }

    public TypeTagCloud getTags() {
        return this.tags;
    }

    public void setTags(TypeTagCloud tags) {
        TypeTagCloud oldCloud = new TypeTagCloud();
        oldCloud.setTags(this.tags.getTagsSortedByTerms());
        this.tags.setTags(tags.getTagsSortedByTerms());
        this.firePropertyChange(TAG_CLOUD_CHANGED, oldCloud, this.tags);
    }

    public TypeHeader getHeader() {
        return this.header;
    }

    public void setHeader(TypeHeader header) {
        this.header = header;
    }

    public TypeBg getBackground() {
        return this.background;
    }

    public void setBackground(TypeBg background) {
        this.background = background;
    }

    public SortedMap<String, InheritanceRelation> getIncomingInheritances() {
        return this.incomingInheritances;
    }

    public SortedMap<String, InheritanceRelation> getOutgoingInheritances() {
        return this.outgoingInheritances;
    }

    public boolean addIncomingInheritance(InheritanceRelation inheritance) {
        if (!this.incomingInheritances.containsKey(inheritance.getChild().getHandleIdentifier())) {
            this.incomingInheritances.put(inheritance.getChild().getHandleIdentifier(), inheritance);
            this.firePropertyChange(INCOMING_INHERITANCE_ADDED, null, inheritance);
            return true;
        }
        return false;
    }

    public boolean addOutgoingInheritance(InheritanceRelation inheritance) {
        if (!this.outgoingInheritances.containsKey(inheritance.getSuper().getHandleIdentifier())) {
            this.outgoingInheritances.put(inheritance.getSuper().getHandleIdentifier(), inheritance);
            this.firePropertyChange(OUTGOING_INHERITANCE_ADDED, null, inheritance);
            return true;
        }
        return false;
    }

    public boolean removeIncomingInheritance(InheritanceRelation inheritance) {
        if (this.incomingInheritances.containsKey(inheritance.getChild().getHandleIdentifier())) {
            this.incomingInheritances.remove(inheritance.getChild().getHandleIdentifier());
            this.firePropertyChange(INCOMING_INHERITANCE_REMOVED, null, null);
            return true;
        }
        return false;
    }

    public boolean removeOutgoingInheritance(InheritanceRelation inheritance) {
        if (this.outgoingInheritances.containsKey(inheritance.getSuper().getHandleIdentifier())) {
            this.outgoingInheritances.remove(inheritance.getSuper().getHandleIdentifier());
            this.firePropertyChange(OUTGOING_INHERITANCE_REMOVED, null, null);
            return true;
        }
        return false;
    }

    public boolean contains(Object o) {
        if (o instanceof TypeHeader) {
            return o.equals(this.getHeader());
        }
        if (o instanceof TypeTagCloud) {
            return o.equals(this.getTags());
        }
        if (o instanceof IMember) {
            return this.membersMap.containsKey(((IMember)o).getHandleIdentifier());
        }
        if (o instanceof Member) {
            return this.membersMap.containsKey(((Member)o).getHandleIdentifier());
        }
        return false;
    }

    public Member findMember(IMember member) {
        Member result = null;
        if (member != null) {
            result = (Member)this.membersMap.get(member.getHandleIdentifier());
        }
        return result;
    }

    public boolean addMember(Member child, Member after) {
        if (child != null && !this.membersMap.containsKey(child.getHandleIdentifier())) {
            int index = this.members.size();
            if (after != null && this.membersMap.containsKey(after.getHandleIdentifier())) {
                index = this.members.indexOf(after);
            }
            if (index == this.members.size() && after == null || index != this.members.size()) {
                return this.addMember(child, index);
            }
        }
        return false;
    }

    public boolean addMember(Member child, int index) {
        if (child != null && !this.membersMap.containsKey(child.getHandleIdentifier())) {
            index = Math.min(Math.max(0, index), this.members.size());
            try {
                this.members.add(index, child);
                this.membersMap.put(child.getHandleIdentifier(), child);
                this.firePropertyChange(CHILD_ADDED_PROPERTY, null, child);
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean removeMember(Member child) {
        if (child != null && this.membersMap.containsKey(child.getHandleIdentifier())) {
            if (this.members.remove(child)) {
                this.membersMap.remove(child.getHandleIdentifier());
                Display.getDefault().syncExec((Runnable)new FirePropertyChangeRunnable(this, CHILD_REMOVED_PROPERTY, null, child));
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean moveMember(Member child, int index) {
        if (child != null && this.membersMap.containsKey(child.getHandleIdentifier()) && index >= 0 && index <= this.members.size() && this.removeMember(child)) {
            return this.addMember(child, index);
        }
        return false;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public Member getFirstMember() {
        int size = this.members.size();
        if (size == 0) {
            return null;
        }
        return this.members.get(0);
    }

    public List<ModelNode> getChildren() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>(this.members.size() + 2);
        result.add(this.getHeader());
        for (Member child : this.members) {
            result.add(child);
        }
        result.add(this.getTags());
        return result;
    }

    public String toString() {
        if (this.isValid()) {
            return this.jdtData.getFullyQualifiedName();
        }
        return "null";
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.refreshJdtData();
    }

    private void writeObject(ObjectOutputStream out) {
        LinkedList<InheritanceRelation> previews = this.removePreviewEdges();
        try {
            out.defaultWriteObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (InheritanceRelation inheritance : previews) {
            inheritance.attach();
        }
    }

    private LinkedList<InheritanceRelation> removePreviewEdges() {
        LinkedList<InheritanceRelation> previews = new LinkedList<InheritanceRelation>();
        for (InheritanceRelation inheritance : this.incomingInheritances.values()) {
            if (inheritance.isPermanent()) continue;
            previews.add(inheritance);
        }
        for (InheritanceRelation inheritance : this.outgoingInheritances.values()) {
            if (inheritance.isPermanent()) continue;
            previews.add(inheritance);
        }
        for (InheritanceRelation inheritance : previews) {
            inheritance.detach();
        }
        return previews;
    }

    private void refreshJdtData() {
        IJavaElement jdtData = JavaCore.create((String)this.handleIdentifier);
        if (jdtData != null && jdtData.getElementType() == 7) {
            this.jdtData = (IType)jdtData;
            this.getHeader().setTypeName(this.getShortName());
            this.getHeader().setPackageName(this.getPackageName());
        } else {
            this.jdtData = null;
        }
    }

    public Dimension predictSize() {
        int width = 0;
        int height = 114;
        width = TextUtilities.INSTANCE.getStringExtents((String)this.getShortName(), (Font)Display.getDefault().getSystemFont()).width;
        width = Math.max(width, TextUtilities.INSTANCE.getStringExtents((String)this.getPackageName(), (Font)Display.getDefault().getSystemFont()).width);
        for (Member member : this.members) {
            width = Math.max(width, TextUtilities.INSTANCE.getStringExtents((String)member.getNameWithSignature(), (Font)Display.getDefault().getSystemFont()).width);
            height += 21;
        }
        return new Dimension(width += Activator.diagramIconSize.width + 12 + 36, height);
    }
}

