/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.Positionable;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegionWedge;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.TypeComparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.RGB;

public class TagRegion
extends Positionable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_WEDGE_ADDED = "edu.rwth.hci.codegestalt.model.ModelNode.wedgeAdded";
    public static final String PROPERTY_WEDGE_REMOVED = "edu.rwth.hci.codegestalt.model.ModelNode.wedgeRemoved";
    public static final String PROPERTY_FILL_COLOR = "edu.rwth.hci.codegestalt.model.ModelNode.fillColor";
    private Tag tag;
    private RGB fillColor = ColorConstants.menuBackgroundSelected.getRGB();
    private TreeMap<Type, TagRegionWedge> wedges = new TreeMap(new TypeComparator());

    public TagRegion(Tag tag) {
        this.tag = tag;
    }

    public boolean addWedge(TagRegionWedge wedge) {
        if (wedge != null && !this.wedges.containsKey(wedge.getType())) {
            this.wedges.put(wedge.getType(), wedge);
            this.firePropertyChange(PROPERTY_WEDGE_ADDED, null, wedge);
            return true;
        }
        return false;
    }

    public boolean removeWedge(TagRegionWedge wedge) {
        if (wedge != null && this.wedges.containsKey(wedge.getType())) {
            this.wedges.remove(wedge.getType());
            this.firePropertyChange(PROPERTY_WEDGE_REMOVED, null, wedge);
            return true;
        }
        return false;
    }

    public TagRegionWedge getWedgeForType(Type type) {
        if (this.wedges.containsKey(type)) {
            return this.wedges.get(type);
        }
        return null;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setFillColor(RGB color) {
        if (color != null && !this.fillColor.equals((Object)color)) {
            this.fillColor = color;
            this.firePropertyChange(PROPERTY_FILL_COLOR, null, this.fillColor);
        }
    }

    public RGB getFillColor() {
        return this.fillColor;
    }

    public void updateBounds() {
        Rectangle newBounds = new Rectangle(this.getTag().getLayoutBounds());
        for (Type type : this.getTag().getTypeWeightMap().keySet()) {
            if (!this.wedges.containsKey(type)) {
                this.addWedge(new TagRegionWedge(type, this.getTag()));
            }
            Rectangle typeBounds = new Rectangle(type.getLocation(), type.getSize());
            newBounds = newBounds.getUnion(typeBounds);
        }
        this.setBounds(newBounds);
    }

    public List<TagRegionWedge> getChildren() {
        return new LinkedList<TagRegionWedge>(this.wedges.values());
    }

    public String toString() {
        return "Region of Tag \"" + this.getTag().toString() + "\"";
    }
}

