/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.IFadeable;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.tools.StringComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Member
extends ModelNode
implements Comparable<Member>,
IFadeable {
    private static final long serialVersionUID = 1L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[0];
    public static final String INCOMING_CALL_ADDED = "Member.incomingCallAdded";
    public static final String OUTGOING_CALL_ADDED = "Member.outgoingCallAdded";
    public static final String INCOMING_CALL_REMOVED = "Member.incomingCallRemoved";
    public static final String OUTGOING_CALL_REMOVED = "Member.outgoingCallRemoved";
    private int alpha = 255;
    private String handleIdentifier = "[not set]";
    private transient IMember jdtData = null;
    private SortedMap<String, CallRelation> incomingCalls = new TreeMap<String, CallRelation>(new StringComparator());
    private SortedMap<String, CallRelation> outgoingCalls = new TreeMap<String, CallRelation>(new StringComparator());

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a number";
                    }
                    return intValue >= 0 ? null : "Value must be >=  0";
                }
            });
            ++i;
        }
    }

    public IMember getJdtData() {
        return this.jdtData;
    }

    public boolean isValid() {
        return this.getJdtData() != null;
    }

    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handleIdentifier) {
        this.handleIdentifier = handleIdentifier;
        this.refreshJdtData();
    }

    public SortedMap<String, CallRelation> getIncomingCalls() {
        return this.incomingCalls;
    }

    public SortedMap<String, CallRelation> getOutgoingCalls() {
        return this.outgoingCalls;
    }

    public boolean addIncomingCall(CallRelation call) {
        if (!this.incomingCalls.containsKey(call.getCaller().getHandleIdentifier())) {
            this.incomingCalls.put(call.getCaller().getHandleIdentifier(), call);
            this.firePropertyChange(INCOMING_CALL_ADDED, null, call);
            return true;
        }
        return false;
    }

    public boolean addOutgoingCall(CallRelation call) {
        if (!this.outgoingCalls.containsKey(call.getCallee().getHandleIdentifier())) {
            this.outgoingCalls.put(call.getCallee().getHandleIdentifier(), call);
            this.firePropertyChange(OUTGOING_CALL_ADDED, null, call);
            return true;
        }
        return false;
    }

    public boolean removeIncomingCall(CallRelation call) {
        if (this.incomingCalls.containsKey(call.getCaller().getHandleIdentifier())) {
            this.incomingCalls.remove(call.getCaller().getHandleIdentifier());
            this.firePropertyChange(INCOMING_CALL_REMOVED, null, null);
            return true;
        }
        return false;
    }

    public boolean removeOutgoingCall(CallRelation call) {
        if (this.outgoingCalls.containsKey(call.getCallee().getHandleIdentifier())) {
            this.outgoingCalls.remove(call.getCallee().getHandleIdentifier());
            this.firePropertyChange(OUTGOING_CALL_REMOVED, null, null);
            return true;
        }
        return false;
    }

    public String getName() {
        if (this.isValid()) {
            return this.jdtData.getElementName();
        }
        return "null";
    }

    public String getNameWithSignature() {
        if (this.isValid()) {
            String result = this.jdtData.getElementName();
            if (this.jdtData instanceof IMethod) {
                String[] signature;
                result = String.valueOf(result) + "(";
                String[] stringArray = signature = ((IMethod)this.jdtData).getParameterTypes();
                int n = signature.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    result = String.valueOf(result) + Signature.toString((String)param) + ", ";
                    ++n2;
                }
                result = signature.length > 0 ? String.valueOf(result.substring(0, result.length() - 2)) + ") : " : String.valueOf(result.substring(0, result.length() - 1)) + " : ";
                try {
                    result = String.valueOf(result) + Signature.toString((String)((IMethod)this.jdtData).getReturnType());
                }
                catch (Exception e) {
                    result = String.valueOf(result) + "null";
                    e.printStackTrace();
                }
            } else if (this.jdtData instanceof IField) {
                result = String.valueOf(result) + " : ";
                try {
                    result = String.valueOf(result) + Signature.toString((String)((IField)this.jdtData).getTypeSignature());
                }
                catch (Exception e) {
                    result = String.valueOf(result) + "null";
                    e.printStackTrace();
                }
            }
            return result;
        }
        return "null";
    }

    public String getNameWithFullDeclaration() {
        if (this.isValid()) {
            String result = "";
            try {
                result = String.valueOf(result) + Flags.toString((int)this.jdtData.getFlags()) + " " + this.getName();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                result = String.valueOf(result) + "[Error reading flags]";
            }
            if (this.jdtData instanceof IMethod) {
                result = String.valueOf(result) + "(";
                String[] signature = ((IMethod)this.jdtData).getParameterTypes();
                try {
                    String[] parameterNames = ((IMethod)this.jdtData).getParameterNames();
                    int i = 0;
                    while (i < signature.length) {
                        result = String.valueOf(result) + Signature.toString((String)signature[i]) + " " + parameterNames[i] + ", ";
                        ++i;
                    }
                    result = signature.length > 0 ? String.valueOf(result.substring(0, result.length() - 2)) + ") : " : String.valueOf(result.substring(0, result.length() - 1)) + " : ";
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    result = String.valueOf(result) + "[error parsing pparameters]";
                }
                try {
                    result = String.valueOf(result) + Signature.toString((String)((IMethod)this.jdtData).getReturnType());
                }
                catch (Exception e) {
                    result = String.valueOf(result) + "null";
                    e.printStackTrace();
                }
            } else if (this.jdtData instanceof IField) {
                result = String.valueOf(result) + " : ";
                try {
                    result = String.valueOf(result) + Signature.toString((String)((IField)this.jdtData).getTypeSignature());
                }
                catch (Exception e) {
                    result = String.valueOf(result) + "null";
                    e.printStackTrace();
                }
            }
            return result;
        }
        return "null";
    }

    public String toString() {
        return this.getNameWithSignature();
    }

    private void writeObject(ObjectOutputStream out) {
        LinkedList<CallRelation> previews = this.removePreviewEdges();
        try {
            out.defaultWriteObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (CallRelation call : previews) {
            call.attach();
        }
    }

    private LinkedList<CallRelation> removePreviewEdges() {
        LinkedList<CallRelation> previews = new LinkedList<CallRelation>();
        for (CallRelation call : this.incomingCalls.values()) {
            if (call.isPermanent()) continue;
            previews.add(call);
        }
        for (CallRelation call : this.outgoingCalls.values()) {
            if (call.isPermanent()) continue;
            previews.add(call);
        }
        for (CallRelation call : previews) {
            call.detach();
        }
        return previews;
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.refreshJdtData();
    }

    private void refreshJdtData() {
        IJavaElement jdtData = JavaCore.create((String)this.handleIdentifier);
        this.jdtData = jdtData != null && (jdtData.getElementType() == 8 || jdtData.getElementType() == 10 || jdtData.getElementType() == 9 || jdtData.getElementType() == 7) ? (IMember)jdtData : null;
    }

    @Override
    public int compareTo(Member arg0) {
        return this.getHandleIdentifier().compareTo(arg0.getHandleIdentifier());
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.firePropertyChange("IFadeable.alpha", null, new Integer(alpha));
            for (CallRelation call : this.getOutgoingCalls().values()) {
                call.setAlpha(alpha);
            }
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }
}

