/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.IFadeable;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.model.Type;

public class InheritanceRelation
extends ModelNode
implements IFadeable {
    private static final long serialVersionUID = 1L;
    public static final String ATTACHED_CHILD = "InheritanceRelation.attachedChild";
    public static final String DETACHED_CHILD = "InheritanceRelation.detachedChild";
    public static final String ATTACHED_SUPER = "InheritanceRelation.attachedSuper";
    public static final String DETACHED_SUPER = "InheritanceRelation.detachedSuper";
    public static final String CHANGED_CHILD = "InheritanceRelation.changedChild";
    public static final String CHANGED_SUPER = "InheritanceRelation.changedSuper";
    public static final String SET_TO_PERMANENT = "InheritanceRelation.setToPermanent";
    public static final String SET_TO_PREVIEW = "InheritanceRelation.setToPreview";
    public static final boolean PERMANENT = true;
    public static final boolean PREVIEW = false;
    private int alpha = 255;
    private Type childType = null;
    private Type superType = null;
    private boolean childAttached = false;
    private boolean superAttached = false;
    private boolean permanent = false;

    public InheritanceRelation(Type childType, Type superType) {
        this.childType = childType;
        this.superType = superType;
    }

    private boolean attachChild() {
        if (this.childType.addOutgoingInheritance(this)) {
            this.childAttached = true;
            this.firePropertyChange(ATTACHED_CHILD, null, this.childType);
            return true;
        }
        return false;
    }

    private boolean detachChild() {
        if (this.childType.removeOutgoingInheritance(this)) {
            this.childAttached = false;
            this.firePropertyChange(DETACHED_CHILD, null, this.childType);
            return true;
        }
        return false;
    }

    private boolean attachSuper() {
        if (this.superType.addIncomingInheritance(this)) {
            this.superAttached = true;
            this.firePropertyChange(ATTACHED_SUPER, null, this.superType);
            return true;
        }
        return false;
    }

    private boolean detachSuper() {
        if (this.superType.removeIncomingInheritance(this)) {
            this.superAttached = false;
            this.firePropertyChange(DETACHED_SUPER, null, this.superType);
            return true;
        }
        return false;
    }

    public boolean attach() {
        return this.isValid() && this.attachChild() && this.attachSuper();
    }

    public boolean detach() {
        return this.isValid() && this.detachChild() && this.detachSuper();
    }

    private boolean isValid() {
        return this.superType != null && this.childType != null && !this.isDangling();
    }

    private boolean isDangling() {
        return !this.childAttached && this.superAttached || this.childAttached && !this.superAttached;
    }

    public boolean isAttached() {
        return this.childAttached && this.superAttached;
    }

    public Type getChild() {
        return this.childType;
    }

    public void setChild(Type childType) {
        if (!this.childAttached && childType != null && childType != this.childType && childType.getJdtData().getElementType() == 9) {
            this.childType = childType;
            this.firePropertyChange(CHANGED_CHILD, null, this.childType);
        }
    }

    public Type getSuper() {
        return this.superType;
    }

    public void setSuper(Type superType) {
        if (!this.superAttached && superType != null && superType != this.superType && superType.getJdtData().getElementType() == 9) {
            this.superType = superType;
            this.firePropertyChange(CHANGED_SUPER, null, this.superType);
        }
    }

    public void setPermanent(boolean permanent) {
        if (permanent != this.permanent) {
            this.permanent = permanent;
            if (this.permanent) {
                this.firePropertyChange(SET_TO_PERMANENT, null, null);
            } else {
                this.firePropertyChange(SET_TO_PREVIEW, null, null);
            }
        }
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.firePropertyChange("IFadeable.alpha", null, this.alpha);
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    public String toString() {
        return String.valueOf(this.getChild() != null ? this.getChild().toString() : "null") + " --> " + (this.getSuper() != null ? this.getSuper().toString() : "null");
    }

    public boolean equals(Object obj) {
        if (obj instanceof InheritanceRelation) {
            InheritanceRelation relation = (InheritanceRelation)obj;
            return this.getChild().equals(relation.getChild()) && this.getSuper().equals(relation.getSuper());
        }
        return false;
    }
}

