/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.FirePropertyChangeRunnable;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.model.Note;
import edu.rwth.hci.codegestalt.model.Positionable;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.model.TypeTagCloud;
import edu.rwth.hci.codegestalt.tools.StringComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.widgets.Display;

public class CgtDiagram
extends ModelNode {
    private List<Type> typeChildren = new ArrayList<Type>();
    private SortedMap<String, Type> typeChildrenMap = new TreeMap<String, Type>(new StringComparator());
    private SortedMap<String, Tag> shownTags = new TreeMap<String, Tag>(new StringComparator());
    private SortedMap<String, Tag> hiddenTags = new TreeMap<String, Tag>(new StringComparator());
    private SortedMap<String, Tag> pinnedTags = new TreeMap<String, Tag>(new StringComparator());
    private SortedMap<String, Tag> tagChildrenMap = new TreeMap<String, Tag>(new StringComparator());
    private List<Note> noteChildren = new LinkedList<Note>();
    private double maxTagWeight = 0.0;
    private int maxTagWeightCount = 0;
    private SortedMap<String, TagRegion> tagRegionMap = new TreeMap<String, TagRegion>(new StringComparator());
    private static final long serialVersionUID = 1L;
    public static final String TYPE_ADDED_PROPERTY = "CgtDiagram.typeAdded";
    public static final String TYPE_REMOVED_PROPERTY = "CgtDiagram.typeRemoved";
    public static final String TAG_ADDED_PROPERTY = "CgtDiagram.tagAdded";
    public static final String TAG_REMOVED_PROPERTY = "CgtDiagram.tagRemoved";
    public static final String TAG_SHOWN_PROPERTY = "CgtDiagram.tagShown";
    public static final String TAG_HIDDEN_PROPERTY = "CgtDiagram.tagHidden";
    public static final String MAX_TAG_WEIGHT_PROPERTY = "CgtDiagram.maxTagWeight";
    public static final String TAG_PINNED_PROPERTY = "CgtDiagram.tagPinned";
    public static final String TAG_UNPINNED_PROPERTY = "CgtDiagram.tagUnpinned";
    public static final String TAG_REGION_ADDED_PROPERTY = "CgtDiagram.tagRegionAdded";
    public static final String TAG_REGION_REMOVED_PROPERTY = "CgtDiagram.tagRegionRemoved";
    public static final String NOTE_ADDED_PROPERTY = "CgtDiagram.noteAdded";
    public static final String NOTE_REMOVED_PROPERTY = "CgtDiagram.noteRemoved";

    public boolean addChild(Positionable child) {
        if (child != null) {
            if (child instanceof Type) {
                return this.addType((Type)child);
            }
            if (child instanceof Tag) {
                return this.addTag((Tag)child);
            }
            if (child instanceof TagRegion) {
                return this.addTagRegion((TagRegion)child);
            }
            if (child instanceof Note) {
                return this.addNote((Note)child);
            }
        }
        return false;
    }

    private boolean addType(Type child) {
        if (!this.typeChildrenMap.containsKey(child.getHandleIdentifier())) {
            this.typeChildrenMap.put(child.getHandleIdentifier(), child);
            if (this.typeChildren.add(child)) {
                this.firePropertyChange(TYPE_ADDED_PROPERTY, null, child);
                return true;
            }
        }
        return false;
    }

    private boolean addTag(Tag child) {
        if (!this.tagChildrenMap.containsKey(child.getTerm())) {
            Tag added;
            this.tagChildrenMap.put(child.getTerm(), child);
            if (child.getTypeWeightMap().size() >= 2) {
                added = this.shownTags.put(child.getTerm(), child);
                if (added != child && child.getWeight() >= this.maxTagWeight) {
                    this.increaseMaxTagWeight(child.getWeight());
                }
            } else {
                added = this.hiddenTags.put(child.getTerm(), child);
            }
            if (added != child) {
                this.firePropertyChange(TAG_ADDED_PROPERTY, null, child);
                return true;
            }
        }
        return false;
    }

    private boolean addTagRegion(TagRegion child) {
        if (!this.tagRegionMap.containsKey(child.getTag().getTerm())) {
            this.tagRegionMap.put(child.getTag().getTerm(), child);
            this.firePropertyChange(TAG_REGION_ADDED_PROPERTY, null, child);
            return true;
        }
        return false;
    }

    private boolean addNote(Note child) {
        if (!this.noteChildren.contains(child)) {
            this.noteChildren.add(child);
            this.firePropertyChange(NOTE_ADDED_PROPERTY, null, child);
            return true;
        }
        return false;
    }

    public boolean removeChild(Positionable child) {
        if (child != null) {
            if (child instanceof Type) {
                this.removeType((Type)child);
            } else if (child instanceof Tag) {
                this.removeTag((Tag)child);
            } else if (child instanceof TagRegion) {
                this.removeTagRegion((TagRegion)child);
            } else if (child instanceof Note) {
                this.removeNote((Note)child);
            }
            return true;
        }
        return false;
    }

    private void removeType(Type child) {
        child.setTags(new TypeTagCloud());
        this.typeChildren.remove(child);
        this.typeChildrenMap.remove(child.getHandleIdentifier().toString());
        Display.getDefault().syncExec((Runnable)new FirePropertyChangeRunnable(this, TYPE_REMOVED_PROPERTY, null, child));
    }

    private void removeTag(Tag child) {
        if (child.getTypeWeightMap().size() >= 2) {
            this.shownTags.remove(child.getTerm());
            if (child.getWeight() == this.maxTagWeight) {
                this.decreaseMaxTagWeight(child.getWeight());
            }
        } else {
            this.hiddenTags.remove(child.getTerm());
            this.pinnedTags.remove(child.getTerm());
        }
        if (this.tagRegionMap.containsKey(child.getTerm())) {
            this.tagRegionMap.remove(child.getTerm());
        }
        this.tagChildrenMap.remove(child.getTerm());
        Display.getDefault().syncExec((Runnable)new FirePropertyChangeRunnable(this, TAG_REMOVED_PROPERTY, null, child));
    }

    private void removeTagRegion(TagRegion child) {
        if (this.tagRegionMap.containsKey(child.getTag().getTerm())) {
            this.tagRegionMap.remove(child.getTag().getTerm());
            Display.getDefault().syncExec((Runnable)new FirePropertyChangeRunnable(this, TAG_REGION_REMOVED_PROPERTY, null, child));
        }
    }

    private void removeNote(Note child) {
        if (this.noteChildren.contains(child)) {
            this.noteChildren.remove(child);
            Display.getDefault().syncExec((Runnable)new FirePropertyChangeRunnable(this, NOTE_REMOVED_PROPERTY, null, child));
        }
    }

    private void showTag(Tag tag) {
        if (tag != null && this.hiddenTags.containsKey(tag.getTerm())) {
            this.hiddenTags.remove(tag.getTerm());
            this.shownTags.put(tag.getTerm(), tag);
            if (tag.getWeight() >= this.maxTagWeight) {
                this.increaseMaxTagWeight(tag.getWeight());
            }
            this.firePropertyChange(TAG_SHOWN_PROPERTY, null, tag);
        }
    }

    private void hideTag(Tag tag) {
        if (tag != null && this.shownTags.containsKey(tag.getTerm())) {
            this.shownTags.remove(tag.getTerm());
            this.hiddenTags.put(tag.getTerm(), tag);
            if (tag.getWeight() == this.maxTagWeight) {
                this.decreaseMaxTagWeight(tag.getWeight());
            }
            this.firePropertyChange(TAG_HIDDEN_PROPERTY, null, tag);
        }
    }

    public void pinTag(Tag tag, boolean pinned) {
        if (tag != null && this.tagChildrenMap.containsKey(tag.getTerm())) {
            if (pinned && !this.pinnedTags.containsKey(tag.getTerm())) {
                Tag added = null;
                added = this.pinnedTags.put(tag.getTerm(), tag);
                if (added != tag) {
                    this.firePropertyChange(TAG_PINNED_PROPERTY, null, tag);
                }
            } else if (!pinned && this.pinnedTags.containsKey(tag.getTerm())) {
                this.pinnedTags.remove(tag.getTerm());
                this.firePropertyChange(TAG_UNPINNED_PROPERTY, null, tag);
            }
        }
    }

    public List<Positionable> getChildren() {
        ArrayList<Positionable> result = new ArrayList<Positionable>(this.tagRegionMap.size() + this.typeChildren.size() * 2 + this.noteChildren.size() * 2 + this.shownTags.size());
        for (TagRegion region : this.tagRegionMap.values()) {
            result.add(region);
        }
        for (Type type : this.typeChildren) {
            result.add(type.getBackground());
            result.add(type);
        }
        for (Note note : this.noteChildren) {
            result.add(note.getBackground());
            result.add(note);
        }
        result.addAll(this.pinnedTags.values());
        return result;
    }

    public List<Positionable> getOverlayChildren() {
        ArrayList<Positionable> result = new ArrayList<Positionable>(this.typeChildren.size() * 2 + this.noteChildren.size() * 2 + this.shownTags.size());
        for (Type type : this.typeChildren) {
            result.add(type.getBackground());
            result.add(type);
        }
        for (Note note : this.noteChildren) {
            result.add(note.getBackground());
            result.add(note);
        }
        result.addAll(this.shownTags.values());
        return result;
    }

    public List<Type> getTypeChildren() {
        return this.typeChildren;
    }

    public SortedMap<String, Tag> getTagChildren() {
        return this.tagChildrenMap;
    }

    public List<Note> getNoteChildren() {
        return this.noteChildren;
    }

    public List<Tag> getShownTagChildren() {
        ArrayList<Tag> result = new ArrayList<Tag>(this.shownTags.size());
        result.addAll(this.shownTags.values());
        return result;
    }

    public boolean contains(Object o) {
        if (o instanceof Type) {
            return this.typeChildrenMap.containsKey(((Type)o).getHandleIdentifier());
        }
        if (o instanceof IType) {
            return this.typeChildrenMap.containsKey(((IType)o).getHandleIdentifier());
        }
        if (o instanceof TagRegion) {
            return this.tagRegionMap.containsKey(((TagRegion)o).getTag().getTerm());
        }
        return false;
    }

    public boolean isPinned(Tag tag) {
        return this.pinnedTags.containsKey(tag.getTerm());
    }

    private void increaseMaxTagWeight(double weight) {
        if (weight > this.maxTagWeight) {
            this.maxTagWeight = weight;
            this.maxTagWeightCount = 1;
            this.firePropertyChange(MAX_TAG_WEIGHT_PROPERTY, null, new Double(this.maxTagWeight));
        } else if (weight == this.maxTagWeight) {
            ++this.maxTagWeightCount;
        }
    }

    private void decreaseMaxTagWeight(double weight) {
        if (weight == this.maxTagWeight) {
            --this.maxTagWeightCount;
            if (this.maxTagWeightCount == 0) {
                this.maxTagWeight = 0.0;
                for (Tag tag : this.shownTags.values()) {
                    if (tag.getWeight() > this.maxTagWeight) {
                        this.maxTagWeight = tag.getWeight();
                        this.maxTagWeightCount = 1;
                    }
                    if (tag.getWeight() != this.maxTagWeight) continue;
                    ++this.maxTagWeightCount;
                }
                this.firePropertyChange(MAX_TAG_WEIGHT_PROPERTY, null, new Double(this.maxTagWeight));
            }
        }
    }

    public double getMaxTagWeight() {
        return this.maxTagWeight;
    }

    public TagRegion findTagRegionForTag(Tag tag) {
        return (TagRegion)this.tagRegionMap.get(tag.getTerm());
    }

    public Type findType(IType type) {
        Type result = null;
        if (type != null) {
            result = (Type)this.typeChildrenMap.get(type.getHandleIdentifier());
        }
        return result;
    }

    private SortedMap<String, Type> findTypesForHandle(String handle) {
        SortedMap<String, Type> result = new TreeMap<String, Type>();
        if (handle != null) {
            char lastChar = handle.charAt(handle.length() - 1);
            lastChar = (char)(lastChar + '\u0001');
            result = this.typeChildrenMap.subMap(handle, String.valueOf(handle.substring(0, handle.length() - 1)) + lastChar);
        }
        return result;
    }

    private void removeTypesForHandle(String handle) {
        if (handle != null) {
            LinkedList<Type> deletionCandidates = new LinkedList<Type>(this.findTypesForHandle(handle).values());
            for (Type deletionCandidate : deletionCandidates) {
                this.removeChild(deletionCandidate);
            }
        }
    }

    public void removeJdtPackage(IPackageFragment packageFragment) {
        if (packageFragment != null) {
            this.removeTypesForHandle(packageFragment.getHandleIdentifier());
        }
    }

    public void removeJdtCompilationUnit(ICompilationUnit unit) {
        if (unit != null) {
            this.removeTypesForHandle(unit.getHandleIdentifier());
        }
    }

    public void removeJdtType(IType type) {
        if (type != null) {
            this.removeTypesForHandle(type.getHandleIdentifier());
        }
    }

    public void updateTagsForType(Type type, TypeTagCloud oldTags) {
        double oldWeight;
        int oldReferenceCount;
        Tag tag;
        LinkedList<Tag> deletionCandidates = new LinkedList<Tag>();
        LinkedList<Tag> hideCandidates = new LinkedList<Tag>();
        for (String term : oldTags.getTagsSortedByTerms().keySet()) {
            if (!this.tagChildrenMap.containsKey(term)) continue;
            tag = (Tag)this.tagChildrenMap.get(term);
            oldReferenceCount = tag.getTypeWeightMap().size();
            tag.removeType(type);
            oldWeight = tag.getWeight();
            tag.calculateWeightAndPosition();
            if (oldReferenceCount > 2 && oldWeight == this.maxTagWeight && oldWeight != tag.getWeight()) {
                this.decreaseMaxTagWeight(oldWeight);
            }
            if (tag.getTypeWeightMap().size() >= 2 && tag.getWeight() > this.maxTagWeight) {
                this.increaseMaxTagWeight(tag.getWeight());
            }
            if (tag.getTypeWeightMap().size() == 0) {
                deletionCandidates.add(tag);
            }
            if (tag.getTypeWeightMap().size() > 1) continue;
            hideCandidates.add(tag);
        }
        for (String term : type.getTags().getTagsSortedByTerms().keySet()) {
            if (!this.tagChildrenMap.containsKey(term)) {
                oldReferenceCount = 0;
                tag = new Tag();
                tag.setTerm(term);
                tag.addType(type);
                this.addChild(tag);
            } else {
                tag = (Tag)this.tagChildrenMap.get(term);
                oldReferenceCount = tag.getTypeWeightMap().size();
                tag.addType(type);
            }
            oldWeight = tag.getWeight();
            tag.calculateWeightAndPosition();
            if (oldReferenceCount >= 2 && oldWeight == this.maxTagWeight && oldWeight != tag.getWeight()) {
                this.decreaseMaxTagWeight(oldWeight);
            }
            if (tag.getTypeWeightMap().size() > 2 && tag.getWeight() > this.maxTagWeight) {
                this.increaseMaxTagWeight(tag.getWeight());
            }
            if (tag.getTypeWeightMap().size() != 2) continue;
            this.showTag(tag);
        }
        for (Tag tag2 : deletionCandidates) {
            if (tag2.getTypeWeightMap().size() != 0) continue;
            this.removeChild(tag2);
        }
        for (Tag tag2 : hideCandidates) {
            if (tag2.getTypeWeightMap().size() > 1) continue;
            this.hideTag(tag2);
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (Type type : this.typeChildren) {
            this.updateTagsForType(type, type.getTags());
        }
    }

    private void writeObject(ObjectOutputStream out) {
        try {
            out.defaultWriteObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

