/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.editor.context;

import edu.rwth.hci.codegestalt.controller.TypeEditPart;
import edu.rwth.hci.codegestalt.controller.command.TypeRemoveMembersCommand;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.TypeComparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractContextRemoveMembersAction
extends SelectionAction {
    private SortedSet<Type> typesInSelection = null;
    private int option = 0;

    public AbstractContextRemoveMembersAction(IWorkbenchPart part) {
        super(part);
        this.initFields();
    }

    protected abstract void initFields();

    protected boolean calculateEnabled() {
        return this.containsType(this.getSelectedObjects());
    }

    public void run() {
        for (Type type : this.typesInSelection) {
            this.getCommandStack().execute((Command)new TypeRemoveMembersCommand(type, this.getOption()));
        }
    }

    private boolean containsType(List<Object> selection) {
        this.typesInSelection = new TreeSet<Type>(new TypeComparator());
        for (Object obj : selection) {
            if (!(obj instanceof TypeEditPart)) continue;
            this.typesInSelection.add(((TypeEditPart)obj).getCastedModel());
        }
        return this.typesInSelection.size() != 0;
    }

    protected int getOption() {
        return this.option;
    }

    protected void setOption(int option) {
        this.option = option;
    }
}

