/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.editor;

import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.factory.CgtEditPartFactory;
import edu.rwth.hci.codegestalt.controller.outline.CgtTreeEditPartFactory;
import edu.rwth.hci.codegestalt.editor.LocalSelectionTransferDropTargetListener;
import edu.rwth.hci.codegestalt.editor.context.AddAllMembersAction;
import edu.rwth.hci.codegestalt.editor.context.AddPublicMembersAction;
import edu.rwth.hci.codegestalt.editor.context.AddPublicMethodsAction;
import edu.rwth.hci.codegestalt.editor.context.CgtEditorContextMenuProvider;
import edu.rwth.hci.codegestalt.editor.context.NoteCreateAction;
import edu.rwth.hci.codegestalt.editor.context.RemoveAllMembersAction;
import edu.rwth.hci.codegestalt.editor.context.RemovePrivateFieldsAction;
import edu.rwth.hci.codegestalt.editor.context.RemovePrivateMembersAction;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CgtEditor
extends GraphicalEditor {
    private CgtDiagram diagram;

    public CgtEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void dispose() {
        super.dispose();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new CgtEditPartFactory());
        ScalableFreeformRootEditPart rootPart = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootPart);
        LayerManager.Helper.find((EditPart)rootPart).getLayer((Object)"Scaled Feedback Layer").setEnabled(true);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        this.createZoomActions();
        CgtEditorContextMenuProvider cmProvider = new CgtEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    protected void createZoomActions() {
        ActionRegistry registry = this.getActionRegistry();
        ZoomManager zoomManager = (ZoomManager)this.getAdapter(ZoomManager.class);
        IHandlerService service = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        ZoomInAction action = new ZoomInAction(zoomManager);
        registry.registerAction((IAction)action);
        service.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
        action = new ZoomOutAction(zoomManager);
        registry.registerAction((IAction)action);
        service.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        SelectionAction action = new AddPublicMethodsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddPublicMembersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddAllMembersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RemovePrivateFieldsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RemovePrivateMembersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RemoveAllMembersAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new NoteCreateAction(this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getModel());
        viewer.addDropTargetListener((TransferDropTargetListener)new LocalSelectionTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new CgtContentOutlinePage((EditPartViewer)new TreeViewer());
        }
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    public CgtDiagram getModel() {
        return this.diagram;
    }

    public void setModel(CgtDiagram diagram) {
        this.diagram = diagram;
    }

    private ByteArrayOutputStream modelToOutputStream() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(result);
        oos.writeObject(this.getModel());
        oos.close();
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream out = this.modelToOutputStream();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, true, monitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            try {
                new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            ByteArrayOutputStream out = CgtEditor.this.modelToOutputStream();
                            file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.getCommandStack().markSaveLocation();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        try {
            IFile file = ((IFileEditorInput)input).getFile();
            ObjectInputStream in = new ObjectInputStream(file.getContents());
            this.diagram = (CgtDiagram)in.readObject();
            in.close();
            this.setPartName(((IFileEditorInput)input).getFile().getName());
        }
        catch (Exception exception) {}
    }

    public void setTagOverlay(boolean b) {
        ((CgtDiagramEditPart)this.getGraphicalViewer().getRootEditPart().getContents()).setTagOverlay(b);
    }

    public void exportImage() {
        ((CgtDiagramEditPart)this.getGraphicalViewer().getContents()).exportImage();
    }

    public class CgtContentOutlinePage
    extends ContentOutlinePage {
        public CgtContentOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void createControl(Composite parent) {
            this.getViewer().createControl(parent);
            this.getViewer().setEditDomain((EditDomain)CgtEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new CgtTreeEditPartFactory());
            CgtEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
            this.getViewer().setContents((Object)CgtEditor.this.getModel());
        }

        public void dispose() {
            CgtEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
        }

        public Control getControl() {
            return this.getViewer().getControl();
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = CgtEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        }
    }
}

