/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.policy;

import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.TagEditPart;
import edu.rwth.hci.codegestalt.controller.TypeEditPart;
import edu.rwth.hci.codegestalt.controller.command.InheritanceRelationPermanentCommand;
import edu.rwth.hci.codegestalt.controller.policy.ContextDeleteSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.InheritanceRelation;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.TypeComparator;
import edu.rwth.hci.codegestalt.view.TagFigure;
import edu.rwth.hci.codegestalt.view.ui.CollapseAllButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.ExpandAllButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.InheritanceRelationAnchorButtonFigure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class TypeSelectionEditPolicy
extends ContextDeleteSelectionEditPolicy
implements PropertyChangeListener {
    private TreeMap<Type, InheritanceRelation> incomingInheritances = new TreeMap(new TypeComparator());
    private TreeMap<Type, InheritanceRelation> outgoingInheritances = new TreeMap(new TypeComparator());

    private TypeEditPart getCastedHost() {
        return (TypeEditPart)this.getHost();
    }

    private Type getCastedModel() {
        return this.getCastedHost().getCastedModel();
    }

    private CgtDiagram getDiagram() {
        return (CgtDiagram)this.getHost().getParent().getModel();
    }

    protected InheritanceRelationAnchorButtonFigure getIncomingInheritanceRelationAnchorButton() {
        return this.getCastedHost().getIncomingInheritancesAnchorButton();
    }

    protected InheritanceRelationAnchorButtonFigure getOutgoingInheritanceRelationAnchorButton() {
        return this.getCastedHost().getOutgoingInheritancesAnchorButton();
    }

    private TagFigure getFigureForTag(Tag tag) {
        TagEditPart controller = this.getEditPartForTag(tag);
        if (controller != null) {
            return (TagFigure)controller.getFigure();
        }
        return null;
    }

    private TagEditPart getEditPartForTag(Tag tag) {
        return (TagEditPart)this.getHost().getRoot().getViewer().getEditPartRegistry().get(tag);
    }

    private Color getHighlightColorForNormalizedWeight(double normalizedWeight) {
        return new Color((Device)Display.getDefault(), 255 - (int)Math.round(191.0 * normalizedWeight) / 4, 255 - (int)Math.round(127.0 * normalizedWeight) / 4, 255 - (int)Math.round(0.0 * normalizedWeight) / 4);
    }

    private double getNormalizedWeightForTerm(String term) {
        return (Double)this.getCastedModel().getTags().getTagsSortedByTerms().get(term) / this.getCastedModel().getTags().getMaximumWeight();
    }

    private ExpandAllButtonFigure getExpandButton() {
        return this.getCastedHost().getExpandButton();
    }

    private CollapseAllButtonFigure getCollapseButton() {
        return this.getCastedHost().getCollapseButton();
    }

    @Override
    protected void showSelection() {
        super.showSelection();
        this.showInheritanceRelationPreview();
        this.showInheritanceRelationButtons();
        if (((CgtDiagramEditPart)this.getHost().getParent()).isTagOverlay()) {
            this.highlightTags();
        }
    }

    @Override
    protected void hideSelection() {
        super.hideSelection();
        this.hideInheritanceRelationButtons();
        this.hideInheritanceRelationPreview();
        this.resetTags();
    }

    private void showInheritanceRelationButtons() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (!layer.getChildren().contains((Object)this.getIncomingInheritanceRelationAnchorButton()) || !layer.getChildren().contains((Object)this.getOutgoingInheritanceRelationAnchorButton())) {
            this.getCastedHost().updateAnchorButtonPositions();
            if (!layer.getChildren().contains((Object)this.getIncomingInheritanceRelationAnchorButton()) && this.incomingInheritances.values().size() > 0) {
                layer.add((IFigure)this.getIncomingInheritanceRelationAnchorButton());
            }
            if (!layer.getChildren().contains((Object)this.getOutgoingInheritanceRelationAnchorButton()) && this.outgoingInheritances.values().size() > 0) {
                layer.add((IFigure)this.getOutgoingInheritanceRelationAnchorButton());
            }
        }
        this.getIncomingInheritanceRelationAnchorButton().setCommand(new InheritanceRelationPermanentCommand(this.incomingInheritances.values()));
        this.getOutgoingInheritanceRelationAnchorButton().setCommand(new InheritanceRelationPermanentCommand(this.outgoingInheritances.values()));
    }

    private void hideInheritanceRelationButtons() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (layer.getChildren().contains((Object)this.getIncomingInheritanceRelationAnchorButton())) {
            layer.remove((IFigure)this.getIncomingInheritanceRelationAnchorButton());
            this.getIncomingInheritanceRelationAnchorButton().showDefaultGraphics();
        }
        if (layer.getChildren().contains((Object)this.getOutgoingInheritanceRelationAnchorButton())) {
            layer.remove((IFigure)this.getOutgoingInheritanceRelationAnchorButton());
            this.getOutgoingInheritanceRelationAnchorButton().showDefaultGraphics();
        }
    }

    private void showInheritanceRelationPreview() {
        try {
            List<IType> jdtChildTypes = this.searchForChildTypes(this.getCastedModel().getJdtData());
            List<Type> cgtChildTypes = this.toCgtTypes(jdtChildTypes);
            this.createChildTypeEdges(cgtChildTypes);
            this.attachRelations(this.incomingInheritances.values());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            List<IType> jdtSuperTypes = this.searchForSuperTypes(this.getCastedModel().getJdtData());
            List<Type> cgtSuperTypes = this.toCgtTypes(jdtSuperTypes);
            this.createSuperTypeEdges(cgtSuperTypes);
            this.attachRelations(this.outgoingInheritances.values());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void hideInheritanceRelationPreview() {
        this.detachRelations(this.incomingInheritances.values());
        this.detachRelations(this.outgoingInheritances.values());
    }

    private List<IType> searchForChildTypes(IType type) throws CoreException {
        LinkedList<IType> result = new LinkedList<IType>();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] children = hierarchy.getSubtypes(type);
        int i = 0;
        while (i < children.length) {
            result.add(children[i]);
            ++i;
        }
        return result;
    }

    private List<Type> toCgtTypes(List<IType> types) {
        TreeSet<Type> result = new TreeSet<Type>(new TypeComparator());
        for (IType jdtType : types) {
            Type cgtType = this.getDiagram().findType(jdtType);
            if (cgtType == null) continue;
            result.add(cgtType);
        }
        return new LinkedList<Type>(result);
    }

    private void createChildTypeEdges(List<Type> childTypes) {
        this.stopListeningToTypes(this.incomingInheritances.keySet());
        this.detachRelations(this.incomingInheritances.values());
        this.incomingInheritances.clear();
        for (Type childType : childTypes) {
            if (childType.getOutgoingInheritances().containsKey(this.getCastedModel().getHandleIdentifier())) continue;
            this.incomingInheritances.put(childType, new InheritanceRelation(childType, this.getCastedModel()));
        }
        this.startListeningToTypes(this.incomingInheritances.keySet());
    }

    private void attachRelations(Collection<InheritanceRelation> inheritances) {
        for (InheritanceRelation inheritance : inheritances) {
            inheritance.attach();
        }
    }

    private void detachRelations(Collection<InheritanceRelation> inheritances) {
        for (InheritanceRelation inheritance : inheritances) {
            if (inheritance.isPermanent()) continue;
            inheritance.detach();
        }
    }

    private List<IType> searchForSuperTypes(IType type) throws CoreException {
        LinkedList<IType> result = new LinkedList<IType>();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] children = hierarchy.getSupertypes(type);
        int i = 0;
        while (i < children.length) {
            result.add(children[i]);
            ++i;
        }
        return result;
    }

    private void createSuperTypeEdges(List<Type> superTypes) {
        this.stopListeningToTypes(this.outgoingInheritances.keySet());
        this.detachRelations(this.outgoingInheritances.values());
        this.outgoingInheritances.clear();
        for (Type superType : superTypes) {
            if (superType.getIncomingInheritances().containsKey(this.getCastedModel().getHandleIdentifier())) continue;
            this.outgoingInheritances.put(superType, new InheritanceRelation(this.getCastedModel(), superType));
        }
        this.startListeningToTypes(this.outgoingInheritances.keySet());
    }

    private void highlightTags() {
        for (String term : this.getCastedModel().getTags().getTagsSortedByTerms().keySet()) {
            Tag tag = (Tag)this.getDiagram().getTagChildren().get(term);
            double normalizedWeight = this.getNormalizedWeightForTerm(term);
            Color highlightColor = this.getHighlightColorForNormalizedWeight(normalizedWeight);
            TagFigure figure = this.getFigureForTag(tag);
            if (figure == null) continue;
            figure.setBackgroundColor(highlightColor);
            figure.setOpaque(true);
            this.getEditPartForTag(tag).refresh();
        }
    }

    private void resetTags() {
        for (String term : this.getCastedModel().getTags().getTagsSortedByTerms().keySet()) {
            Tag tag = (Tag)this.getDiagram().getTagChildren().get(term);
            TagFigure figure = this.getFigureForTag(tag);
            if (figure == null) continue;
            figure.setBackgroundColor(ColorConstants.black);
            figure.setOpaque(false);
            this.getEditPartForTag(tag).refresh();
        }
    }

    @Override
    protected void showContextualControls() {
        super.showContextualControls();
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (!layer.getChildren().contains((Object)this.getExpandButton())) {
            this.getCastedHost().updateExpandButtonPosition();
            layer.add((IFigure)this.getExpandButton());
        }
        if (!layer.getChildren().contains((Object)this.getCollapseButton())) {
            this.getCastedHost().updateCollapseButtonPosition();
            layer.add((IFigure)this.getCollapseButton());
        }
    }

    @Override
    protected void hideContextualControls() {
        super.hideContextualControls();
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (layer.getChildren().contains((Object)this.getExpandButton())) {
            layer.remove((IFigure)this.getExpandButton());
            this.getExpandButton().showDefaultGraphics();
        }
        if (layer.getChildren().contains((Object)this.getCollapseButton())) {
            layer.remove((IFigure)this.getCollapseButton());
            this.getCollapseButton().showDefaultGraphics();
        }
    }

    private void startListeningToTypes(Collection<Type> types) {
        for (Type type : types) {
            type.addPropertyChangeListener(this);
        }
    }

    private void stopListeningToTypes(Collection<Type> types) {
        for (Type type : types) {
            type.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.selected) {
            InheritanceRelation relation;
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("Type.incomingInheritanceAdded") && (relation = (InheritanceRelation)evt.getNewValue()).getChild().getHandleIdentifier().equals(this.getCastedModel().getHandleIdentifier()) && this.outgoingInheritances.containsKey(evt.getSource())) {
                this.outgoingInheritances.get(evt.getSource()).removePropertyChangeListener(this);
                this.outgoingInheritances.remove(evt.getSource());
            }
            if (propertyName.equals("Type.outgoingInheritanceAdded") && (relation = (InheritanceRelation)evt.getNewValue()).getSuper().getHandleIdentifier().equals(this.getCastedModel().getHandleIdentifier()) && this.incomingInheritances.containsKey(evt.getSource())) {
                this.incomingInheritances.get(evt.getSource()).removePropertyChangeListener(this);
                this.incomingInheritances.remove(evt.getSource());
            }
        }
    }

    public void tagOverlayChanged(boolean tagOverlay) {
        if (this.selected) {
            if (tagOverlay) {
                this.highlightTags();
            } else {
                this.resetTags();
            }
        }
    }
}

