/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.policy;

import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.TagEditPart;
import edu.rwth.hci.codegestalt.controller.TypeEditPart;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.view.TypeFigure;
import edu.rwth.hci.codegestalt.view.ui.ColorButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.FontButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.PinButtonFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class TagSelectionEditPolicy
extends SelectionEditPolicy {
    boolean selected = false;

    private Tag getCastedModel() {
        return (Tag)this.getHost().getModel();
    }

    private Color getHighlightColorForNormalizedWeight(double normalizedWeight) {
        return new Color((Device)Display.getDefault(), 255 - (int)Math.round(191.0 * normalizedWeight), 255 - (int)Math.round(127.0 * normalizedWeight), 255 - (int)Math.round(0.0 * normalizedWeight));
    }

    private TypeFigure getFigureForType(Type type) {
        return (TypeFigure)((TypeEditPart)this.getHost().getRoot().getViewer().getEditPartRegistry().get(type)).getFigure();
    }

    private TagEditPart getCastedHost() {
        return (TagEditPart)this.getHost();
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        this.hideContextualControls();
    }

    protected void showSelection() {
        this.showContextualControls();
        this.selected = true;
        if (((CgtDiagramEditPart)this.getHost().getParent()).isTagOverlay()) {
            this.highlightTypes();
        }
    }

    protected void hideSelection() {
        this.hideContextualControls();
        this.selected = false;
        this.resetTypes();
    }

    public void showTargetFeedback(Request request) {
    }

    public void eraseTargetFeedback(Request request) {
    }

    private PinButtonFigure getPinButton() {
        return this.getCastedHost().getPinButton();
    }

    private FontButtonFigure getFontButton() {
        return this.getCastedHost().getFontButton();
    }

    private ColorButtonFigure getColorButton() {
        return this.getCastedHost().getColorButton();
    }

    protected void showContextualControls() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (!layer.getChildren().contains((Object)this.getPinButton())) {
            this.getCastedHost().updatePinButtonPosition();
            layer.add((IFigure)this.getPinButton());
        }
        if (this.getCastedModel().isPinned()) {
            if (!layer.getChildren().contains((Object)this.getFontButton())) {
                this.getCastedHost().updateFontButtonPosition();
                layer.add((IFigure)this.getFontButton());
            }
            if (!layer.getChildren().contains((Object)this.getColorButton())) {
                this.getCastedHost().updateColorButtonPosition();
                layer.add((IFigure)this.getColorButton());
            }
        }
    }

    protected void hideContextualControls() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (layer.getChildren().contains((Object)this.getPinButton())) {
            layer.remove((IFigure)this.getPinButton());
            this.getPinButton().showDefaultGraphics();
        }
        if (this.getCastedModel().isPinned()) {
            if (layer.getChildren().contains((Object)this.getFontButton())) {
                layer.remove((IFigure)this.getFontButton());
                this.getFontButton().showDefaultGraphics();
            }
            if (layer.getChildren().contains((Object)this.getColorButton())) {
                layer.remove((IFigure)this.getColorButton());
                this.getColorButton().showDefaultGraphics();
            }
        }
    }

    private void highlightTypes() {
        for (Type type : this.getCastedModel().getTypeWeightMap().keySet()) {
            double normalizedWeight = this.getCastedModel().getNormalizedWeightForType(type);
            Color highlightColor = this.getHighlightColorForNormalizedWeight(normalizedWeight);
            this.getFigureForType(type).setFill(true);
            this.getFigureForType(type).setBackgroundColor(highlightColor);
        }
    }

    private void resetTypes() {
        for (Type type : this.getCastedModel().getTypeWeightMap().keySet()) {
            this.getFigureForType(type).setFill(false);
            this.getFigureForType(type).setBackgroundColor(ColorConstants.white);
        }
    }

    public void tagOverlayChanged(boolean tagOverlay) {
        if (this.selected) {
            if (tagOverlay) {
                this.highlightTypes();
            } else {
                this.resetTypes();
            }
        }
    }

    public void pinStateChanged() {
        if (this.selected) {
            this.showContextualControls();
        }
    }
}

