/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.policy;

import edu.rwth.hci.codegestalt.controller.MemberEditPart;
import edu.rwth.hci.codegestalt.controller.command.CallRelationPermanentCommand;
import edu.rwth.hci.codegestalt.controller.policy.ContextDeleteSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.MemberComparator;
import edu.rwth.hci.codegestalt.view.MemberFigure;
import edu.rwth.hci.codegestalt.view.ui.CallRelationAnchorButtonFigure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class MemberSelectionEditPolicy
extends ContextDeleteSelectionEditPolicy
implements PropertyChangeListener {
    private static final Color SELECTION_FILL_COLOR = new Color((Device)Display.getDefault(), 224, 232, 241);
    private TreeMap<Member, CallRelation> incomingCalls = new TreeMap(new MemberComparator());
    private TreeMap<Member, CallRelation> outgoingCalls = new TreeMap(new MemberComparator());

    private MemberEditPart getCastedHost() {
        return (MemberEditPart)this.getHost();
    }

    private Member getCastedModel() {
        return this.getCastedHost().getCastedModel();
    }

    private MemberFigure getCastedView() {
        return this.getCastedHost().getCastedView();
    }

    private CgtDiagram getDiagram() {
        return (CgtDiagram)this.getHost().getParent().getParent().getModel();
    }

    protected CallRelationAnchorButtonFigure getIncomingCallsAnchorButton() {
        return this.getCastedHost().getIncomingCallsAnchorButton();
    }

    protected CallRelationAnchorButtonFigure getOutgoingCallsAnchorButton() {
        return this.getCastedHost().getOutgoingCallsAnchorButton();
    }

    @Override
    protected void showSelection() {
        super.showSelection();
        this.getCastedView().setBackgroundColor(SELECTION_FILL_COLOR);
        this.getCastedView().setFill(true);
        if (this.getCastedModel().getJdtData().getElementType() == 9) {
            this.showCallRelationPreview();
            this.showCallRelationButtons();
        }
    }

    @Override
    protected void hideSelection() {
        super.hideSelection();
        this.getCastedView().setFill(false);
        if (this.getCastedModel().getJdtData().getElementType() == 9) {
            this.hideCallRelationButtons();
            this.hideCallRelationPreview();
        }
    }

    private void showCallRelationButtons() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (!layer.getChildren().contains((Object)this.getIncomingCallsAnchorButton()) || !layer.getChildren().contains((Object)this.getOutgoingCallsAnchorButton())) {
            ((MemberEditPart)this.getHost()).updateAnchorButtonPositions();
            if (!layer.getChildren().contains((Object)this.getIncomingCallsAnchorButton()) && this.incomingCalls.size() > 0) {
                layer.add((IFigure)this.getIncomingCallsAnchorButton());
            }
            if (!layer.getChildren().contains((Object)this.getOutgoingCallsAnchorButton()) && this.outgoingCalls.size() > 0) {
                layer.add((IFigure)this.getOutgoingCallsAnchorButton());
            }
        }
        this.getIncomingCallsAnchorButton().setCommand(new CallRelationPermanentCommand(this.incomingCalls.values()));
        this.getOutgoingCallsAnchorButton().setCommand(new CallRelationPermanentCommand(this.outgoingCalls.values()));
    }

    private void hideCallRelationButtons() {
        IFigure layer = this.getLayer("Scaled Feedback Layer");
        if (layer.getChildren().contains((Object)this.getIncomingCallsAnchorButton())) {
            layer.remove((IFigure)this.getIncomingCallsAnchorButton());
            this.getIncomingCallsAnchorButton().showDefaultGraphics();
        }
        if (layer.getChildren().contains((Object)this.getOutgoingCallsAnchorButton())) {
            layer.remove((IFigure)this.getOutgoingCallsAnchorButton());
            this.getOutgoingCallsAnchorButton().showDefaultGraphics();
        }
    }

    private void showCallRelationPreview() {
        try {
            List<IMethod> jdtCallers = this.searchForCallers((IMethod)this.getCastedModel().getJdtData());
            List<Member> cgtCallers = this.toCgtMembers(jdtCallers);
            this.createCallerEdges(cgtCallers);
            this.attachRelations(this.incomingCalls.values());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            List<IMethod> jdtCallees = this.searchForCallees((IMethod)this.getCastedModel().getJdtData());
            List<Member> cgtCallees = this.toCgtMembers(jdtCallees);
            this.createCalleeEdges(cgtCallees);
            this.attachRelations(this.outgoingCalls.values());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void hideCallRelationPreview() {
        this.detachRelations(this.incomingCalls.values());
        this.detachRelations(this.outgoingCalls.values());
    }

    private List<IMethod> searchForCallers(IMethod method) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)2);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        class CallerSearchRequestor
        extends SearchRequestor {
            public List<IMethod> callers = new LinkedList<IMethod>();

            CallerSearchRequestor() {
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getElement() instanceof IMethod) {
                    this.callers.add((IMethod)match.getElement());
                }
            }
        }
        CallerSearchRequestor requestor = new CallerSearchRequestor();
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
        return requestor.callers;
    }

    private List<Member> toCgtMembers(List<IMethod> callers) {
        TreeSet<Member> result = new TreeSet<Member>();
        for (IMethod jdtMethod : callers) {
            Member cgtMethod;
            if (jdtMethod.getParent().getElementType() != 7) continue;
            IType jdtParent = (IType)jdtMethod.getParent();
            Type cgtParent = this.getDiagram().findType(jdtParent);
            if (cgtParent == null || (cgtMethod = cgtParent.findMember((IMember)jdtMethod)) == null) continue;
            result.add(cgtMethod);
        }
        return new LinkedList<Member>(result);
    }

    private void createCallerEdges(List<Member> callers) {
        this.stopListeningToMembers(this.incomingCalls.keySet());
        this.detachRelations(this.incomingCalls.values());
        this.incomingCalls.clear();
        for (Member caller : callers) {
            if (caller.getOutgoingCalls().containsKey(this.getCastedModel().getHandleIdentifier())) continue;
            this.incomingCalls.put(caller, new CallRelation(caller, this.getCastedModel()));
        }
        this.startListeningToMembers(this.incomingCalls.keySet());
    }

    private void attachRelations(Collection<CallRelation> callRelations) {
        for (CallRelation call : callRelations) {
            call.attach();
        }
    }

    private void detachRelations(Collection<CallRelation> callRelations) {
        for (CallRelation call : callRelations) {
            if (call.isPermanent()) continue;
            call.detach();
        }
    }

    private List<IMethod> searchForCallees(IMethod method) throws CoreException {
        class CalleeSearchRequestor
        extends SearchRequestor {
            public List<IMethod> callees = new LinkedList<IMethod>();

            CalleeSearchRequestor() {
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getElement() instanceof IMethod) {
                    this.callees.add((IMethod)match.getElement());
                }
            }
        }
        CalleeSearchRequestor requestor = new CalleeSearchRequestor();
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchDeclarationsOfSentMessages((IJavaElement)method, (SearchRequestor)requestor, null);
        return requestor.callees;
    }

    private void createCalleeEdges(List<Member> callees) {
        this.stopListeningToMembers(this.outgoingCalls.keySet());
        this.detachRelations(this.outgoingCalls.values());
        this.outgoingCalls.clear();
        for (Member callee : callees) {
            if (callee.getIncomingCalls().containsKey(this.getCastedModel().getHandleIdentifier())) continue;
            this.outgoingCalls.put(callee, new CallRelation(this.getCastedModel(), callee));
        }
        this.startListeningToMembers(this.outgoingCalls.keySet());
    }

    private void startListeningToMembers(Collection<Member> members) {
        for (Member member : members) {
            member.addPropertyChangeListener(this);
        }
    }

    private void stopListeningToMembers(Collection<Member> members) {
        for (Member member : members) {
            member.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.selected) {
            CallRelation relation;
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("Member.incomingCallAdded") && (relation = (CallRelation)evt.getNewValue()).getCaller().getHandleIdentifier().equals(this.getCastedModel().getHandleIdentifier()) && this.outgoingCalls.containsKey(evt.getSource())) {
                this.outgoingCalls.get(evt.getSource()).removePropertyChangeListener(this);
                this.outgoingCalls.remove(evt.getSource());
            }
            if (propertyName.equals("Member.outgoingCallAdded") && (relation = (CallRelation)evt.getNewValue()).getCallee().getHandleIdentifier().equals(this.getCastedModel().getHandleIdentifier()) && this.incomingCalls.containsKey(evt.getSource())) {
                this.incomingCalls.get(evt.getSource()).removePropertyChangeListener(this);
                this.incomingCalls.remove(evt.getSource());
            }
        }
    }
}

