/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.factory;

import edu.rwth.hci.codegestalt.controller.factory.TypeIconFactory;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MemberIconFactory {
    private static final ImageDescriptor FIELD_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/field_default_obj.gif");
    private static final ImageDescriptor FIELD_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/field_private_obj.gif");
    private static final ImageDescriptor FIELD_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/field_protected_obj.gif");
    private static final ImageDescriptor FIELD_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/field_public_obj.gif");
    private static final ImageDescriptor METHOD_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/methdef_obj.gif");
    private static final ImageDescriptor METHOD_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/methpri_obj.gif");
    private static final ImageDescriptor METHOD_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/methpro_obj.gif");
    private static final ImageDescriptor METHOD_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/methpub_obj.gif");
    private static final ImageDescriptor ERROR_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/error_obj.gif");

    public static Image getImageForMember(IMember member, Dimension size) {
        return new JavaElementImageDescriptor(MemberIconFactory.getImageDescriptorForMember(member), TypeIconFactory.computeAdornmentFlags(member), new Point(size.width, size.height)).createImage();
    }

    public static ImageDescriptor getImageDescriptorForMember(IMember member) {
        try {
            int flags = member.getFlags();
            if (member.getElementType() == 7) {
                return TypeIconFactory.getBaseImageDescriptorForType((IType)member);
            }
            if (member.getElementType() == 8) {
                if (Flags.isPackageDefault((int)flags)) {
                    return FIELD_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return FIELD_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return FIELD_PROTECTED_ICON;
                }
                return FIELD_PUBLIC_ICON;
            }
            if (member.getElementType() == 9) {
                if (Flags.isPackageDefault((int)flags)) {
                    return METHOD_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return METHOD_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return METHOD_PROTECTED_ICON;
                }
                return METHOD_PUBLIC_ICON;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return ERROR_ICON;
    }
}

