/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.StringComparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeRemoveMembersCommand
extends Command {
    private static final int INVALID = 0;
    public static final int PRIVATE_MEMBERS = 1;
    public static final int PRIVATE_DEFAULT_AND_PROTECTED_MEMBERS = 2;
    public static final int ALL_MEMBERS = 3;
    public static final int PRIVATE_FIELDS = 4;
    public static final int PRIVATE_DEFAULT_AND_PROTECTED_FIELDS = 5;
    public static final int ALL_FIELDS = 6;
    private Type parent = null;
    private List<CallRelation> callRelations = new LinkedList<CallRelation>();
    private List<CallRelation> callRelationPreviews = new LinkedList<CallRelation>();
    private TreeMap<String, Member> removedChildren = new TreeMap(new StringComparator());
    private Dimension originalSize;
    private int option = 0;
    private boolean selectionParsed = false;
    private TreeMap<String, Member> originalChildren = new TreeMap(new StringComparator());

    public TypeRemoveMembersCommand(Type parent, int option) {
        this.parent = parent;
        this.option = option;
        this.setLabel("Member Deletion");
        this.setDebugLabel("Member Deletion with option" + option + " in " + (parent != null ? parent : "null"));
    }

    public Object clone() {
        return new TypeRemoveMembersCommand(this.parent, this.option);
    }

    public boolean canExecute() {
        this.parseJdtMembers();
        return this.parent != null && this.option > 0 && this.option <= 6 && this.removedChildren.size() > 0;
    }

    public void execute() {
        this.originalSize = this.parent.getSize();
        for (Member member : this.parent.getMembers()) {
            this.originalChildren.put(member.getHandleIdentifier(), member);
        }
        this.redo();
    }

    public void redo() {
        for (Member child : this.removedChildren.values()) {
            this.parent.removeMember(child);
        }
        for (CallRelation call : this.callRelations) {
            call.detach();
        }
        for (CallRelation call : this.callRelationPreviews) {
            call.detach();
        }
        this.callRelationPreviews.clear();
        this.parent.setSize(new Dimension(Math.min(this.originalSize.width, this.parent.predictSize().width), Math.min(this.originalSize.height, this.parent.predictSize().height)));
    }

    public void undo() {
        for (Member child : this.removedChildren.values()) {
            this.parent.addMember(child, null);
        }
        for (CallRelation call : this.callRelations) {
            call.attach();
        }
        this.parent.setSize(this.originalSize);
    }

    private void parseJdtMembers() {
        if (!this.selectionParsed) {
            try {
                IJavaElement[] iJavaElementArray = this.parent.getJdtData().getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    if (element instanceof IMember) {
                        boolean isPrivateDefaultOrProtected;
                        int flags;
                        boolean isPrivate;
                        boolean isField;
                        IMember member = (IMember)element;
                        if (this.option == 3) {
                            this.parseMember(member);
                        }
                        boolean bl = isField = member.getElementType() == 8;
                        if (isField && this.option == 6) {
                            this.parseMember(member);
                        }
                        if ((isPrivate = Flags.isPrivate((int)(flags = member.getFlags()))) && this.option == 1) {
                            this.parseMember(member);
                        }
                        if (isPrivate && isField && this.option == 4) {
                            this.parseMember(member);
                        }
                        boolean bl2 = isPrivateDefaultOrProtected = Flags.isProtected((int)flags) || Flags.isPackageDefault((int)flags) || isPrivate;
                        if (isPrivateDefaultOrProtected && this.option == 2) {
                            this.parseMember(member);
                        }
                        if (isPrivateDefaultOrProtected && isField && this.option == 5) {
                            this.parseMember(member);
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            this.selectionParsed = true;
        }
    }

    private void parseMember(IMember member) {
        Member removedChild;
        IMember memberParent = member;
        while (!(memberParent instanceof IType)) {
            if ((memberParent = memberParent.getParent()) != null) continue;
            return;
        }
        IType type = (IType)memberParent;
        if (type.equals(this.parent.getJdtData()) && (removedChild = this.parent.findMember(member)) != null) {
            this.removedChildren.put(removedChild.getHandleIdentifier(), removedChild);
            for (CallRelation call : removedChild.getIncomingCalls().values()) {
                if (call.isPermanent()) {
                    this.callRelations.add(call);
                    continue;
                }
                this.callRelationPreviews.add(call);
            }
            for (CallRelation call : removedChild.getOutgoingCalls().values()) {
                if (call.isPermanent()) {
                    this.callRelations.add(call);
                    continue;
                }
                this.callRelationPreviews.add(call);
            }
        }
    }
}

