/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.controller.command.ColorChangeCommand;
import edu.rwth.hci.codegestalt.model.TagRegion;
import org.eclipse.swt.graphics.RGB;

public class TagRegionColorChangeCommand
extends ColorChangeCommand {
    private TagRegion region = null;
    private RGB originalColor = null;

    public TagRegionColorChangeCommand(TagRegion region) {
        this.region = region;
        this.setLabel("Change color of " + (region != null ? region.toString() : "null"));
        this.setDebugLabel("Change color of " + (region != null ? region.toString() : "null"));
    }

    public boolean canExecute() {
        return this.region != null && this.getColor() != null;
    }

    public void execute() {
        this.originalColor = this.region.getFillColor();
        this.redo();
    }

    public void redo() {
        this.region.setFillColor(this.getColor());
    }

    public void undo() {
        this.region.setFillColor(this.originalColor);
    }

    @Override
    public Object clone() {
        TagRegionColorChangeCommand result = new TagRegionColorChangeCommand(this.region);
        result.setColor(this.getColor());
        return result;
    }
}

