/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import org.eclipse.gef.commands.Command;

public class TagPinCommand
extends Command {
    private Tag child;
    private CgtDiagram parent;
    private TagRegion region;

    public TagPinCommand(CgtDiagram parent, Tag child) {
        this.child = child;
        this.parent = parent;
        this.setLabel("Pin Tag");
        this.setDebugLabel("Pin " + (child != null ? child : "null from " + (parent != null ? parent : "null")));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null;
    }

    public void execute() {
        this.region = new TagRegion(this.child);
        this.redo();
    }

    public void redo() {
        this.parent.pinTag(this.child, true);
        this.child.setPinned(this.parent.isPinned(this.child));
        this.parent.addChild(this.region);
        this.region.updateBounds();
    }

    public void undo() {
        this.parent.pinTag(this.child, false);
        this.child.setPinned(this.parent.isPinned(this.child));
        this.parent.removeChild(this.region);
        this.region.updateBounds();
    }
}

