/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class MemberDeleteCommand
extends Command {
    private Member child;
    private List<CallRelation> incomingCalls = new LinkedList<CallRelation>();
    private List<CallRelation> outgoingCalls = new LinkedList<CallRelation>();
    private int index;
    private Type parent;

    public MemberDeleteCommand(Type parent, Member child) {
        this.child = child;
        this.parent = parent;
        this.setLabel("Delete Member");
        this.setDebugLabel("Delete " + (child != null ? child : "null from " + (parent != null ? parent : "null")));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null;
    }

    public void execute() {
        try {
            this.index = this.parent.getMembers().indexOf(this.child);
        }
        catch (Exception exception) {
            this.index = 0;
        }
        for (CallRelation call : this.child.getIncomingCalls().values()) {
            if (!call.isPermanent()) continue;
            this.incomingCalls.add(call);
        }
        for (CallRelation call : this.child.getOutgoingCalls().values()) {
            if (!call.isPermanent()) continue;
            this.outgoingCalls.add(call);
        }
        this.redo();
    }

    public void redo() {
        if (this.parent.removeMember(this.child)) {
            for (CallRelation call : this.child.getIncomingCalls().values()) {
                call.detach();
            }
            for (CallRelation call : this.child.getOutgoingCalls().values()) {
                call.detach();
            }
        }
    }

    public void undo() {
        if (this.parent.addMember(this.child, this.index)) {
            for (CallRelation call : this.incomingCalls) {
                call.attach();
            }
            for (CallRelation call : this.outgoingCalls) {
                call.attach();
            }
        }
    }
}

