/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class MemberCreateCommand
extends Command {
    private Member child;
    private Type parent;
    private Member after;
    private Dimension originalSize;

    public MemberCreateCommand(Member child, Type parent, Member after) {
        this.child = child;
        this.parent = parent;
        this.after = after;
        this.setLabel("Create Member");
        this.setDebugLabel("Create " + (child != null ? child : "null") + " in " + (parent != null ? parent : "null") + " after " + (after != null ? after : "null"));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null;
    }

    public void execute() {
        this.originalSize = this.parent.getSize();
        this.redo();
    }

    public void redo() {
        this.parent.addMember(this.child, this.after);
        this.parent.setSize(new Dimension(Math.max(this.originalSize.width, this.parent.predictSize().width), Math.max(this.originalSize.height, this.parent.predictSize().height)));
    }

    public void undo() {
        this.parent.removeMember(this.child);
        this.parent.setSize(this.originalSize);
    }
}

