/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.StructuredSelection;

public class DiagramChildrenCreateCommand
extends Command {
    public static final int PREFERENCE_NO_MEMBERS = 0;
    public static final int PREFERENCE_PUBLIC_MEMBERS = 1;
    public static final int PREFERENCE_PUBLIC_DEFAULT_AND_PROTECTED_MEMBERS = 2;
    public static final int PREFERENCE_ALL_MEMBERS = 3;
    public static final int PREFERENCE_PUBLIC_METHODS = 4;
    public static final int PREFERENCE_PUBLIC_DEFAULT_AND_PROTECTED_METHODS = 5;
    public static final int PREFERENCE_ALL_METHODS = 6;
    private StructuredSelection selection = null;
    private CgtDiagram parent = null;
    private Point location = null;
    private boolean selectionParsed = false;
    private TreeMap<String, Type> newChildren = new TreeMap();
    private boolean userPreference = false;
    private int userPreferenceMembers = 0;

    public DiagramChildrenCreateCommand(StructuredSelection selection, CgtDiagram parent, Point location) {
        this.selection = selection;
        this.parent = parent;
        this.location = location;
        this.setLabel("Drag and Drop Type Creation");
        this.setDebugLabel("Drag and Drop Type Creation " + (selection != null ? selection : "null") + " in " + (parent != null ? parent : "null") + " at " + (location != null ? location : "null"));
    }

    public DiagramChildrenCreateCommand(StructuredSelection selection, CgtDiagram parent, Point location, int userPreferenceMembers) {
        this(selection, parent, location);
        this.userPreference = true;
        this.userPreferenceMembers = userPreferenceMembers;
    }

    public boolean canExecute() {
        this.parseSelection();
        this.filterNewChildren();
        return this.parent != null && this.newChildren.size() > 0;
    }

    public void execute() {
        int dim = (int)Math.round(Math.nextUp(Math.sqrt(this.newChildren.size())));
        int x = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int margin = 2;
        for (Type child : this.newChildren.values()) {
            child.setSize(child.predictSize());
            maxWidth = Math.max(maxWidth, child.getSize().width);
            maxHeight = Math.max(maxHeight, child.getSize().height);
        }
        Point offsetLocation = this.location.getCopy();
        offsetLocation.x -= (dim * maxWidth + (dim - 1) * margin) / 2;
        offsetLocation.y -= (dim * maxHeight + (dim - 1) * margin) / 2;
        for (Type child : this.newChildren.values()) {
            child.setLocation(offsetLocation);
            offsetLocation.x += maxWidth + margin;
            if (++x < dim) continue;
            x = 0;
            offsetLocation.x -= dim * (maxWidth + margin);
            offsetLocation.y += maxHeight + margin;
        }
        this.redo();
    }

    public void redo() {
        for (Type child : this.newChildren.values()) {
            this.parent.addChild(child);
        }
    }

    public void undo() {
        for (Type child : this.newChildren.values()) {
            this.parent.removeChild(child);
        }
    }

    private void parseSelection() {
        if (!this.selectionParsed) {
            for (Object object : this.selection.toList()) {
                if (!(object instanceof IJavaElement)) continue;
                IJavaElement element = (IJavaElement)object;
                if (element.getElementType() == 2) {
                    this.parseJavaProject((IJavaProject)element);
                    continue;
                }
                if (element.getElementType() == 4) {
                    this.parsePackageFragment((IPackageFragment)element);
                    continue;
                }
                if (element.getElementType() == 5) {
                    this.parseCompilationUnit((ICompilationUnit)element);
                    continue;
                }
                if (element.getElementType() == 7) {
                    this.parseType((IType)element, this.userPreference ? this.userPreferenceMembers : 3);
                    continue;
                }
                if (element.getElementType() == 8) {
                    this.parseMember((IMember)element);
                    continue;
                }
                if (element.getElementType() != 9) continue;
                this.parseMember((IMember)element);
            }
            this.selectionParsed = true;
        }
    }

    private void parseJavaProject(IJavaProject javaProject) {
        try {
            IJavaElement[] iJavaElementArray = javaProject.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element.getElementType() == 3) {
                    this.parsePackageFragmentRoot((IPackageFragmentRoot)element);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void parsePackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        try {
            IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element.getElementType() == 4) {
                    this.parsePackageFragment((IPackageFragment)element);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void parsePackageFragment(IPackageFragment packageFragment) {
        try {
            IJavaElement[] iJavaElementArray = packageFragment.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element.getElementType() == 5) {
                    this.parseCompilationUnit((ICompilationUnit)element);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void parseCompilationUnit(ICompilationUnit compilationUnit) {
        IType type = compilationUnit.findPrimaryType();
        if (type != null) {
            this.parseType(type, this.userPreference ? this.userPreferenceMembers : 0);
        }
    }

    private void parseType(IType type, int userPreferenceMembers) {
        if (!this.newChildren.containsKey(type.getFullyQualifiedName())) {
            Type child = new Type();
            child.setHandleIdentifier(type.getHandleIdentifier());
            this.newChildren.put(type.getFullyQualifiedName(), child);
            if (userPreferenceMembers != 0) {
                try {
                    IJavaElement[] iJavaElementArray = type.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement element = iJavaElementArray[n2];
                        if (element instanceof IMember) {
                            boolean isPublicDefaultOrProtected;
                            int flags;
                            boolean isPublic;
                            boolean isMethod;
                            IMember member = (IMember)element;
                            if (userPreferenceMembers == 3) {
                                this.parseMember(member);
                            }
                            boolean bl = isMethod = member.getElementType() == 9;
                            if (isMethod && userPreferenceMembers == 6) {
                                this.parseMember(member);
                            }
                            if ((isPublic = Flags.isPublic((int)(flags = member.getFlags()))) && userPreferenceMembers == 1) {
                                this.parseMember(member);
                            }
                            if (isPublic && isMethod && userPreferenceMembers == 4) {
                                this.parseMember(member);
                            }
                            boolean bl2 = isPublicDefaultOrProtected = Flags.isProtected((int)flags) || Flags.isPackageDefault((int)flags) || isPublic;
                            if (isPublicDefaultOrProtected && userPreferenceMembers == 2) {
                                this.parseMember(member);
                            }
                            if (isPublicDefaultOrProtected && isMethod && userPreferenceMembers == 5) {
                                this.parseMember(member);
                            }
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void parseMember(IMember member) {
        IMember memberParent = member;
        while (!(memberParent instanceof IType)) {
            if ((memberParent = memberParent.getParent()) != null) continue;
            return;
        }
        IType type = (IType)memberParent;
        if (!this.newChildren.containsKey(type.getFullyQualifiedName())) {
            this.parseType(type, this.userPreference ? this.userPreferenceMembers : 0);
        }
        Type parentType = this.newChildren.get(type.getFullyQualifiedName());
        Member newChildMember = new Member();
        newChildMember.setHandleIdentifier(member.getHandleIdentifier());
        parentType.addMember(newChildMember, null);
    }

    private void filterNewChildren() {
        Collection<Type> types = this.newChildren.values();
        for (Type type : types) {
            if (!this.parent.contains(type)) continue;
            this.newChildren.remove(type.getHandleIdentifier());
        }
    }
}

