/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CallRelation;
import java.util.Collection;
import org.eclipse.gef.commands.Command;

public class CallRelationPermanentCommand
extends Command {
    private Collection<CallRelation> relations;

    public CallRelationPermanentCommand(Collection<CallRelation> relations) {
        this.relations = relations;
        this.setLabel("Make " + relations.size() + " call " + (relations.size() == 1 ? "relation" : "relations") + " permanent");
        this.setDebugLabel("Make " + relations.size() + " call " + (relations.size() == 1 ? "relation" : "relations") + " permanent");
    }

    public boolean canExecute() {
        return this.relations != null && this.relations.size() > 0;
    }

    public void execute() {
        for (CallRelation relation : this.relations) {
            if (relation.isPermanent()) {
                this.relations.remove(relation);
                continue;
            }
            relation.attach();
        }
        this.redo();
    }

    public void redo() {
        for (CallRelation relation : this.relations) {
            relation.setPermanent(true);
        }
    }

    public void undo() {
        for (CallRelation relation : this.relations) {
            relation.setPermanent(false);
        }
    }
}

