/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.policy.DelegateToParentSelectionFeedbackPolicy;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.model.TypeTagCloud;
import edu.rwth.hci.codegestalt.view.TypeTagCloudFigure;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.cs3.cultivate.concepts.analysis.TermMeasurement;
import org.cs3.cultivate.concepts.prolog.query.TermMetricFrequency;
import org.cs3.cultivate.concepts.prolog.query.TermMetricQuery;
import org.cs3.cultivate.concepts.termcloud.comparators.TermValueComparatorDesc;
import org.cs3.cultivate.core.repository.ConsumesRepositoryChanges;
import org.cs3.cultivate.model.prolog.IPrologQuery;
import org.cs3.cultivate.model.prolog.query.IDForFullQualifiedNameQuery;
import org.cs3.cultivate.nature.ICultivateNature;
import org.cs3.cultivate.nature.ILifecycleListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jdt.core.IType;

public class TypeTagCloudEditPart
extends AbstractCgtGraphicalEditPart
implements NodeEditPart,
ILifecycleListener,
ConsumesRepositoryChanges {
    private TermMetricQuery termQuery = null;
    private IDForFullQualifiedNameQuery idQuery = null;
    private boolean termQuerySubscribed = false;
    private boolean idQuerySubscribed = false;
    private String cultivateId = "";
    private final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        private boolean isDescriptionUpdate(IResourceDelta delta) {
            return (delta.getFlags() & 0x80000) == 524288;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (TypeTagCloudEditPart.this.getProject() == null) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            if (rootDelta.getKind() != 4) {
                return;
            }
            if (rootDelta.getAffectedChildren().length == 0) {
                return;
            }
            IResourceDelta delta = rootDelta.findMember(TypeTagCloudEditPart.this.getProject().getFullPath());
            if (delta == null) {
                return;
            }
            if (this.isDescriptionUpdate(delta)) {
                TypeTagCloudEditPart.this.listenToLifecycle();
            }
        }
    };

    private TypeTagCloud getCastedModel() {
        return (TypeTagCloud)this.getModel();
    }

    private TypeTagCloudFigure getCastedView() {
        return (TypeTagCloudFigure)this.getFigure();
    }

    private IType getType() {
        return ((Type)this.getParent().getModel()).getJdtData();
    }

    private IProject getProject() {
        return this.getType().getJavaProject().getProject();
    }

    private boolean hasCultivateNature() {
        return this.hasCultivateNature(this.getProject());
    }

    private ICultivateNature getCultivateNature() {
        return this.getCultivateNature(this.getProject());
    }

    private void unsubscribeIdQuery() {
        if (this.idQuerySubscribed && this.hasCultivateNature() && this.getCultivateNature().isRunning()) {
            this.getCultivateNature().unsubscribe((IPrologQuery)this.idQuery, (ConsumesRepositoryChanges)this);
            this.idQuery = null;
            this.idQuerySubscribed = false;
        }
    }

    private void unsubscribeTermQuery() {
        if (this.termQuerySubscribed && this.hasCultivateNature() && this.getCultivateNature().isRunning()) {
            this.getCultivateNature().unsubscribe((IPrologQuery)this.termQuery, (ConsumesRepositoryChanges)this);
            this.termQuery = null;
            this.termQuerySubscribed = false;
        }
    }

    private void subscribeIdQuery() {
        if (!this.idQuerySubscribed && this.hasCultivateNature() && this.getCultivateNature().isRunning()) {
            String fullyQualifiedName = this.getType().getFullyQualifiedName();
            this.idQuery = new IDForFullQualifiedNameQuery(fullyQualifiedName);
            this.unsubscribeIdQuery();
            this.getCultivateNature().subscribe((IPrologQuery)this.idQuery, (ConsumesRepositoryChanges)this);
            this.idQuerySubscribed = true;
        }
    }

    private void subscribeTermQuery() {
        if (!this.termQuerySubscribed && this.hasCultivateNature() && this.getCultivateNature().isRunning()) {
            this.termQuery = new TermMetricFrequency(this.cultivateId, TermMetricQuery.TermScopeLevel.TYPE);
            this.unsubscribeTermQuery();
            this.getCultivateNature().subscribe((IPrologQuery)this.termQuery, (ConsumesRepositoryChanges)this);
            this.termQuerySubscribed = true;
        }
    }

    private void listenToLifecycle() {
        if (!this.hasCultivateNature()) {
            return;
        }
        if (!this.getCultivateNature().isRunning()) {
            this.getCultivateNature().start();
        }
        this.getCultivateNature().addLifecycleListener((ILifecycleListener)this);
    }

    private void stopListeningToLifecycle() {
        if (this.hasCultivateNature()) {
            this.getCultivateNature().removeLifecycleListener((ILifecycleListener)this);
        }
    }

    private void updateModel(TermMetricQuery query) {
        ArrayList termList = new ArrayList(query.getComputedTerms());
        Collections.sort(termList, new TermValueComparatorDesc());
        TreeMap<String, Double> termMap = new TreeMap<String, Double>();
        for (TermMeasurement entry : termList) {
            termMap.put(entry.getName(), entry.getMeasurement());
        }
        this.getCastedModel().setTags(termMap);
        this.refreshVisuals();
    }

    private void setViewAlpha(int alpha) {
        this.getCastedView().setAlpha(alpha);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
            this.listenToLifecycle();
            this.subscribeIdQuery();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.unsubscribeTermQuery();
            this.unsubscribeIdQuery();
            this.stopListeningToLifecycle();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected IFigure createFigure() {
        TypeTagCloudFigure result = new TypeTagCloudFigure();
        return result;
    }

    protected void refreshVisuals() {
        this.getCastedView().setTags(this.getCastedModel().getTopTagsSortedByTerms(10));
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DelegateToParentSelectionFeedbackPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (TypeTagCloud.TERM_MAP_PROPERTY.equals(prop)) {
            this.refreshVisuals();
        } else if ("IFadeable.alpha".equals(prop)) {
            this.setViewAlpha((Integer)evt.getNewValue());
        }
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public void handleChange(IPrologQuery query) {
        if (query instanceof IDForFullQualifiedNameQuery) {
            this.cultivateId = ((IDForFullQualifiedNameQuery)query).getId();
            this.unsubscribeTermQuery();
            this.subscribeTermQuery();
        } else if (query instanceof TermMetricQuery) {
            this.updateModel((TermMetricQuery)query);
        }
    }

    public void handleOverallInvalidation() {
    }

    public void refreshComplete() {
    }

    public void stateChanged() {
        this.subscribeIdQuery();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }
}

