/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.TagRegionEditPart;
import edu.rwth.hci.codegestalt.controller.policy.NoSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import edu.rwth.hci.codegestalt.model.TagRegionWedge;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.view.TagRegionWedgeFigure;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class TagRegionWedgeEditPart
extends AbstractCgtGraphicalEditPart {
    private TagRegionWedge getCastedModel() {
        return (TagRegionWedge)this.getModel();
    }

    private TagRegionWedgeFigure getCastedView() {
        return (TagRegionWedgeFigure)this.getFigure();
    }

    private TagRegionEditPart getCastedParent() {
        return (TagRegionEditPart)this.getParent();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().getTag().addPropertyChangeListener(this);
            this.getCastedModel().getType().addPropertyChangeListener(this);
            this.getCastedParent().getCastedModel().addPropertyChangeListener(this);
            this.getCastedView().setBackgroundColor(new Color((Device)Display.getDefault(), this.getCastedParent().getCastedModel().getFillColor()));
            this.updateViewAlpha();
            this.refreshVisuals();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().getTag().removePropertyChangeListener(this);
            this.getCastedModel().getType().removePropertyChangeListener(this);
            this.getCastedParent().getCastedModel().removePropertyChangeListener(this);
            this.getCastedView().getBackgroundColor().dispose();
        }
    }

    protected IFigure createFigure() {
        return new TagRegionWedgeFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new NoSelectionEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() instanceof TagRegion) {
            if (propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.refreshVisuals();
            } else if (propertyName.equals("edu.rwth.hci.codegestalt.model.ModelNode.fillColor")) {
                this.updateViewColor();
            }
        }
        if (evt.getSource() instanceof Tag) {
            if (propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.refreshVisuals();
            } else if (propertyName.equals("Tag.updatedWeightAndPosition")) {
                this.updateViewAlpha();
            }
        }
        if (evt.getSource() instanceof Type && propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
            this.refreshVisuals();
        }
    }

    private void updateViewAlpha() {
        this.getCastedView().setAlpha((int)(64.0 * this.getCastedModel().getTag().getNormalizedWeightForType(this.getCastedModel().getType())));
    }

    private void updateViewColor() {
        this.getCastedView().getBackgroundColor().dispose();
        this.getCastedView().setBackgroundColor(new Color((Device)Display.getDefault(), this.getCastedParent().getCastedModel().getFillColor()));
    }

    protected void refreshVisuals() {
        Rectangle typeBounds = new Rectangle(this.getCastedModel().getType().getLocation(), this.getCastedModel().getType().getSize());
        Point tagCenter = this.getCastedModel().getTag().getBounds().getCenter().getCopy();
        Point point0 = new Point();
        Point point1 = new Point();
        if (tagCenter.x < typeBounds.x) {
            if (tagCenter.y < typeBounds.y) {
                point0 = typeBounds.getBottomLeft().getCopy();
                point1 = typeBounds.getTopRight().getCopy();
            } else if (tagCenter.y >= typeBounds.y && tagCenter.y <= typeBounds.y + typeBounds.height) {
                point0 = typeBounds.getBottomLeft().getCopy();
                point1 = typeBounds.getTopLeft().getCopy();
            } else {
                point0 = typeBounds.getBottomRight().getCopy();
                point1 = typeBounds.getTopLeft().getCopy();
            }
        } else if (tagCenter.x >= typeBounds.x && tagCenter.x <= typeBounds.x + typeBounds.width) {
            if (tagCenter.y < typeBounds.y) {
                point0 = typeBounds.getTopLeft().getCopy();
                point1 = typeBounds.getTopRight().getCopy();
            } else if (tagCenter.y >= typeBounds.y && tagCenter.y <= typeBounds.y + typeBounds.height) {
                point0 = typeBounds.getCenter().getCopy();
                point1 = typeBounds.getCenter().getCopy();
            } else {
                point0 = typeBounds.getBottomRight().getCopy();
                point1 = typeBounds.getBottomLeft().getCopy();
            }
        } else if (tagCenter.y < typeBounds.y) {
            point0 = typeBounds.getTopLeft().getCopy();
            point1 = typeBounds.getBottomRight().getCopy();
        } else if (tagCenter.y >= typeBounds.y && tagCenter.y <= typeBounds.y + typeBounds.height) {
            point0 = typeBounds.getTopRight().getCopy();
            point1 = typeBounds.getBottomRight().getCopy();
        } else {
            point0 = typeBounds.getTopRight().getCopy();
            point1 = typeBounds.getBottomLeft().getCopy();
        }
        this.getCastedView().removeAllPoints();
        PointList triangle = new PointList();
        int minX = Math.min(Math.min(point0.x, point1.x), tagCenter.x);
        int minY = Math.min(Math.min(point0.y, point1.y), tagCenter.y);
        triangle.addPoint(point0.getCopy().translate(-minX, -minY));
        triangle.addPoint(point1.getCopy().translate(-minX, -minY));
        triangle.addPoint(tagCenter.getCopy().translate(-minX, -minY));
        this.getCastedView().setPoints(triangle);
        this.getCastedView().setPreferredSize(triangle.getBounds().getSize());
        this.getCastedModel().setBounds(new Rectangle(new Point(minX, minY), triangle.getBounds().getSize()));
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getCastedView(), (Object)this.getCastedModel().getBounds());
    }
}

