/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.policy.NoSelectionEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.TagRegionXYLayoutEditPolicy;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import edu.rwth.hci.codegestalt.model.TagRegionWedge;
import edu.rwth.hci.codegestalt.model.Type;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

public class TagRegionEditPart
extends AbstractCgtGraphicalEditPart {
    public TagRegion getCastedModel() {
        return (TagRegion)this.getModel();
    }

    public FreeformLayer getCastedView() {
        return (FreeformLayer)this.getFigure();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().getTag().addPropertyChangeListener(this);
            this.getCastedModel().addPropertyChangeListener(this);
            for (TagRegionWedge wedge : this.getCastedModel().getChildren()) {
                wedge.getType().addPropertyChangeListener(this);
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().removePropertyChangeListener(this);
            this.getCastedModel().getTag().removePropertyChangeListener(this);
            for (TagRegionWedge wedge : this.getCastedModel().getChildren()) {
                wedge.getType().removePropertyChangeListener(this);
            }
        }
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new NoSelectionEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TagRegionXYLayoutEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() instanceof TagRegion) {
            if (propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.refreshVisuals();
            }
            if (propertyName.equals("edu.rwth.hci.codegestalt.model.ModelNode.wedgeAdded") || evt.getPropertyName().equals("edu.rwth.hci.codegestalt.model.ModelNode.wedgeRemoved")) {
                this.refreshChildren();
            }
        } else if (evt.getSource() instanceof Tag) {
            if (propertyName.equals("Tag.typeAdded")) {
                this.getCastedModel().addWedge(new TagRegionWedge((Type)evt.getNewValue(), this.getCastedModel().getTag()));
                ((Type)evt.getNewValue()).addPropertyChangeListener(this);
            } else if (propertyName.equals("Tag.typeRemoved")) {
                this.getCastedModel().removeWedge(this.getCastedModel().getWedgeForType((Type)evt.getNewValue()));
                ((Type)evt.getNewValue()).removePropertyChangeListener(this);
            } else if (propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.getCastedModel().updateBounds();
            }
        } else if (evt.getSource() instanceof Type && propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
            this.getCastedModel().updateBounds();
        }
    }

    protected void refreshVisuals() {
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getCastedView(), (Object)this.getCastedModel().getBounds());
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }
}

