/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.command.TagFontChangeCommand;
import edu.rwth.hci.codegestalt.controller.command.TagPinCommand;
import edu.rwth.hci.codegestalt.controller.command.TagRegionColorChangeCommand;
import edu.rwth.hci.codegestalt.controller.command.TagUnpinCommand;
import edu.rwth.hci.codegestalt.controller.policy.TagComponentEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.TagSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.view.TagFigure;
import edu.rwth.hci.codegestalt.view.ui.ColorButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.FontButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.PinButtonFigure;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TagEditPart
extends AbstractCgtGraphicalEditPart
implements NodeEditPart {
    PinButtonFigure pinButton = null;
    ColorButtonFigure colorButton = null;
    FontButtonFigure fontButton = null;

    public Tag getCastedModel() {
        return (Tag)this.getModel();
    }

    public CgtDiagram getDiagram() {
        return (CgtDiagram)this.getParent().getModel();
    }

    public TagFigure getCastedView() {
        return (TagFigure)this.getFigure();
    }

    public TagRegion getTagRegion() {
        return this.getDiagram().findTagRegionForTag(this.getCastedModel());
    }

    public PinButtonFigure getPinButton() {
        return this.pinButton;
    }

    public ColorButtonFigure getColorButton() {
        return this.colorButton;
    }

    public FontButtonFigure getFontButton() {
        return this.fontButton;
    }

    private void updateModelPreferredBounds() {
        Point location = this.getCastedModel().getPreferredLocation();
        location.x = (int)((double)location.x - (double)this.getCastedView().getPreferredSize().width * 0.5);
        location.y = (int)((double)location.y - (double)this.getCastedView().getPreferredSize().height * 0.5);
        this.getCastedModel().setPreferredBounds(new Rectangle(location, this.getCastedView().getPreferredSize()));
    }

    private void updateViewFont() {
        Point center = this.getCastedView().getBounds().getCenter();
        this.getCastedView().setFontAndWeight(this.getCastedModel().getFontName(), this.getCastedModel().getWeight(), this.getDiagram().getMaxTagWeight());
        Point newTopLeft = center.getCopy();
        newTopLeft.x = (int)((double)newTopLeft.x - (double)this.getCastedView().getPreferredSize().width * 0.5);
        newTopLeft.y = (int)((double)newTopLeft.y - (double)this.getCastedView().getPreferredSize().height * 0.5);
        this.getCastedModel().setBounds(new Rectangle(newTopLeft, this.getCastedView().getPreferredSize()));
    }

    private void updateViewToolTip() {
        int numberOfTypes = this.getCastedModel().getTypeWeightMap().size();
        this.getCastedView().setToolTip((IFigure)new Label("The term \"" + this.getCastedModel().getTerm() + "\" is used by " + numberOfTypes + (numberOfTypes == 1 ? " type" : " types") + " in this diagram."));
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            for (Type type : this.getCastedModel().getTypeWeightMap().keySet()) {
                type.addPropertyChangeListener(this);
            }
            ((ModelNode)this.getParent().getModel()).addPropertyChangeListener(this);
            CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
            if (((CgtDiagram)this.getParent().getModel()).isPinned(this.getCastedModel())) {
                this.pinButton = new PinButtonFigure(commandStack, new TagUnpinCommand(((CgtDiagramEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
                this.pinButton.updatePinnedState(true, new TagUnpinCommand(((CgtDiagramEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
                this.colorButton = new ColorButtonFigure(commandStack, new TagRegionColorChangeCommand(this.getTagRegion()), this.getTagRegion().getFillColor());
                this.getTagRegion().addPropertyChangeListener(this);
                this.fontButton = new FontButtonFigure(commandStack, new TagFontChangeCommand(this.getCastedModel()), this.getCastedModel().getFontName());
            } else {
                this.pinButton = new PinButtonFigure(commandStack, new TagPinCommand(((CgtDiagramEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
            }
            this.getDiagram().addPropertyChangeListener(this);
            this.updateModelPreferredBounds();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().removePropertyChangeListener(this);
            for (Type type : this.getCastedModel().getTypeWeightMap().keySet()) {
                type.removePropertyChangeListener(this);
            }
            ((ModelNode)this.getParent().getModel()).removePropertyChangeListener(this);
            this.getDiagram().removePropertyChangeListener(this);
            TagRegion region = this.getDiagram().findTagRegionForTag(this.getCastedModel());
            if (region != null) {
                region.removePropertyChangeListener(this);
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new TagSelectionEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TagComponentEditPolicy());
    }

    protected IFigure createFigure() {
        TagFigure result = new TagFigure();
        result.setText(this.getCastedModel().getTerm());
        result.setFont(new Font((Device)Display.getDefault(), Display.getDefault().getSystemFont().getFontData()[0]));
        result.setFontAndWeight(this.getCastedModel().getFontName(), this.getCastedModel().getWeight(), this.getDiagram().getMaxTagWeight());
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyId = evt.getPropertyName();
        if (evt.getSource() instanceof Tag) {
            if (propertyId.equals("Tag.updatedWeightAndPosition")) {
                this.updateViewFont();
                this.updateModelPreferredBounds();
            }
            if (propertyId.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.refreshVisuals();
            }
            if (propertyId.equals("Tag.pinned")) {
                this.setPinButtonState((Boolean)evt.getNewValue());
            }
            if (propertyId.equals("Tag.fontName")) {
                this.getCastedView().setFontAndWeight(this.getCastedModel().getFontName(), this.getCastedModel().getWeight(), this.getDiagram().getMaxTagWeight());
                this.getCastedModel().setSize(this.getCastedView().getPreferredSize());
                this.updateViewFont();
            }
            if (propertyId.equals("Tag.typeAdded")) {
                ((Type)evt.getNewValue()).addPropertyChangeListener(this);
            }
            if (propertyId.equals("Tag.typeRemoved")) {
                ((Type)evt.getNewValue()).removePropertyChangeListener(this);
            }
            if (propertyId.equals("Tag.tagOverlayNotification")) {
                ((TagSelectionEditPolicy)this.getEditPolicy("Selection Feedback")).tagOverlayChanged((Boolean)evt.getNewValue());
            }
        }
        if (evt.getSource() instanceof TagRegion && propertyId.equals("edu.rwth.hci.codegestalt.model.ModelNode.fillColor")) {
            this.getColorButton().setColor((RGB)evt.getNewValue());
        }
        if (evt.getSource() instanceof CgtDiagram) {
            TagRegion region;
            if (propertyId.equals("CgtDiagram.tagRegionAdded") && (region = (TagRegion)evt.getNewValue()).getTag().getTerm().equals(this.getCastedModel().getTerm())) {
                region.addPropertyChangeListener(this);
                CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
                if (this.colorButton == null) {
                    this.colorButton = new ColorButtonFigure(commandStack, new TagRegionColorChangeCommand(this.getTagRegion()), this.getTagRegion().getFillColor());
                }
                ((TagSelectionEditPolicy)this.getEditPolicy("Selection Feedback")).pinStateChanged();
            }
            if (propertyId.equals("CgtDiagram.tagRegionRemoved") && (region = (TagRegion)evt.getNewValue()).getTag().getTerm().equals(this.getCastedModel().getTerm())) {
                region.removePropertyChangeListener(this);
            }
            if (propertyId.equals("CgtDiagram.maxTagWeight")) {
                this.refreshVisuals();
            }
        }
        if (evt.getSource() instanceof Type && propertyId.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
            this.getCastedModel().calculateWeightAndPosition();
        }
    }

    protected void refreshVisuals() {
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.getCastedModel().getBounds());
        this.updateViewToolTip();
        this.updatePinButtonPosition();
        if (this.getCastedModel().isPinned()) {
            this.updateColorButtonPosition();
            this.updateFontButtonPosition();
        }
    }

    public void updatePinButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getBounds().getTopRight();
            pos.x -= 0;
            pos.y -= 16;
            this.getPinButton().setLocation(pos);
        }
    }

    public void updateColorButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getBounds().getTopRight();
            pos.x -= 0;
            pos.y -= 0;
            this.getColorButton().setLocation(pos);
        }
    }

    public void updateFontButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getBounds().getTopRight();
            pos.x -= 0;
            pos.y -= -16;
            this.getFontButton().setLocation(pos);
        }
    }

    private void setPinButtonState(boolean pinned) {
        Command command = pinned ? new TagUnpinCommand(this.getDiagram(), this.getCastedModel()) : new TagPinCommand(this.getDiagram(), this.getCastedModel());
        this.getPinButton().updatePinnedState(pinned, command);
        if (pinned) {
            CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
            this.fontButton = new FontButtonFigure(commandStack, new TagFontChangeCommand(this.getCastedModel()), this.getCastedModel().getFontName());
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }
}

