/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.Activator;
import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.ContextDeletable;
import edu.rwth.hci.codegestalt.controller.TypeEditPart;
import edu.rwth.hci.codegestalt.controller.command.MemberDeleteCommand;
import edu.rwth.hci.codegestalt.controller.factory.MemberIconFactory;
import edu.rwth.hci.codegestalt.controller.policy.MemberComponentEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.MemberSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.view.MemberFigure;
import edu.rwth.hci.codegestalt.view.ui.CallRelationAnchorButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.CloseButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.LeftConnectionAnchor;
import edu.rwth.hci.codegestalt.view.ui.RightConnectionAnchor;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class MemberEditPart
extends AbstractCgtGraphicalEditPart
implements NodeEditPart,
ContextDeletable {
    private CloseButtonFigure closeButton = null;
    private CallRelationAnchorButtonFigure incomingCallsAnchorButton = null;
    private CallRelationAnchorButtonFigure outgoingCallsAnchorButton = null;
    private ConnectionAnchor incomingAnchor = null;
    private ConnectionAnchor outgoingAnchor = null;

    @Override
    public void updateCloseButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedView().getLocation();
            pos.x += this.getCastedView().getSize().width - 20;
            this.getCloseButton().setLocation(pos);
        }
    }

    public void updateAnchorButtonPositions() {
        if (this.isActive()) {
            Point pos = this.getCastedView().getLocation();
            pos.x -= this.getIncomingCallsAnchorButton().getSize().width / 2;
            pos.y += (this.getCastedView().getSize().height - this.getIncomingCallsAnchorButton().getSize().height) / 2;
            this.getIncomingCallsAnchorButton().setLocation(pos.getCopy());
            pos.x += this.getCastedView().getSize().width;
            this.getOutgoingCallsAnchorButton().setLocation(pos.getCopy());
        }
    }

    private void openMemberInEditor() throws PartInitException, JavaModelException {
        ICompilationUnit cu = this.getCastedModel().getJdtData().getCompilationUnit();
        IEditorPart javaEditor = JavaUI.openInEditor((IJavaElement)cu);
        JavaUI.revealInEditor((IEditorPart)javaEditor, (IJavaElement)this.getCastedModel().getJdtData());
    }

    private void setViewAlpha(int alpha) {
        this.getCastedView().setAlpha(alpha);
        this.getCloseButton().setAlpha(alpha);
        this.getIncomingCallsAnchorButton().setAlpha(alpha);
        this.getOutgoingCallsAnchorButton().setAlpha(alpha);
    }

    public Member getCastedModel() {
        return (Member)this.getModel();
    }

    public MemberFigure getCastedView() {
        return (MemberFigure)this.getFigure();
    }

    @Override
    public CloseButtonFigure getCloseButton() {
        return this.closeButton;
    }

    public CallRelationAnchorButtonFigure getIncomingCallsAnchorButton() {
        return this.incomingCallsAnchorButton;
    }

    public CallRelationAnchorButtonFigure getOutgoingCallsAnchorButton() {
        return this.outgoingCallsAnchorButton;
    }

    private ConnectionAnchor getIncomingAnchor() {
        if (this.incomingAnchor == null) {
            this.incomingAnchor = new LeftConnectionAnchor(this.getFigure());
        }
        return this.incomingAnchor;
    }

    private ConnectionAnchor getOutgoingAnchor() {
        if (this.outgoingAnchor == null) {
            this.outgoingAnchor = new RightConnectionAnchor(this.getFigure());
        }
        return this.outgoingAnchor;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
            this.closeButton = new CloseButtonFigure(commandStack, new MemberDeleteCommand(((TypeEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
            this.incomingCallsAnchorButton = new CallRelationAnchorButtonFigure(commandStack, null);
            this.outgoingCallsAnchorButton = new CallRelationAnchorButtonFigure(commandStack, null);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MemberComponentEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MemberSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        return new MemberFigure(this.getCastedModel().toString(), MemberIconFactory.getImageForMember(this.getCastedModel().getJdtData(), Activator.diagramIconSize), this.getCastedModel().getNameWithFullDeclaration());
    }

    protected List<CallRelation> getModelSourceConnections() {
        return new ArrayList<CallRelation>(this.getCastedModel().getOutgoingCalls().values());
    }

    protected List<CallRelation> getModelTargetConnections() {
        return new ArrayList<CallRelation>(this.getCastedModel().getIncomingCalls().values());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            try {
                this.openMemberInEditor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getOutgoingAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getOutgoingAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getIncomingAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getIncomingAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Member.incomingCallAdded".equals(prop) || "Member.incomingCallRemoved".equals(prop)) {
            this.updateAnchorButtonPositions();
            this.refreshTargetConnections();
        } else if ("Member.outgoingCallAdded".equals(prop) || "Member.outgoingCallRemoved".equals(prop)) {
            this.updateAnchorButtonPositions();
            this.refreshSourceConnections();
        } else if ("IFadeable.alpha".equals(prop)) {
            this.setViewAlpha((Integer)evt.getNewValue());
        }
    }
}

