/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.command.InheritanceRelationPermanentCommand;
import edu.rwth.hci.codegestalt.controller.policy.FixedConnectionEndpointEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.InheritanceRelationConnectionEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.InheritanceRelationSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.InheritanceRelation;
import edu.rwth.hci.codegestalt.view.InheritanceRelationFigure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jdt.core.JavaModelException;

public class InheritanceRelationEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    public InheritanceRelation getCastedModel() {
        return (InheritanceRelation)this.getModel();
    }

    public InheritanceRelationFigure getCastedView() {
        return (InheritanceRelationFigure)this.figure;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            if (this.getCastedModel().isPermanent()) {
                this.getCastedView().setToolTip((IFigure)this.createViewToolTip());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FixedConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new InheritanceRelationConnectionEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new InheritanceRelationSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
        InheritanceRelationFigure connection = new InheritanceRelationFigure(commandStack, this.getCastedModel().isPermanent() ? null : this.createViewCommand());
        connection.setAntialias(1);
        connection.setLineWidth(2);
        if (!this.getCastedModel().isPermanent()) {
            connection.setForegroundColor(ColorConstants.lightGray);
        }
        try {
            if (this.getCastedModel().getSuper().getJdtData().isInterface()) {
                connection.setLineStyle(2);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setAntialias(1);
        connection.setTargetDecoration((RotatableDecoration)arrow);
        return connection;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if ("InheritanceRelation.setToPermanent".equals(prop)) {
            this.getCastedView().setForegroundColor(ColorConstants.black);
            this.getCastedView().setCommand(null);
            this.getCastedView().setToolTip((IFigure)this.createViewToolTip());
        } else if ("InheritanceRelation.setToPreview".equals(prop)) {
            this.getCastedView().setForegroundColor(ColorConstants.lightGray);
            if (!this.getTarget().hasFocus() && !this.getSource().hasFocus()) {
                this.getCastedModel().detach();
                this.getCastedView().setCommand(this.createViewCommand());
            }
        } else if ("IFadeable.alpha".equals(prop)) {
            this.setViewAlpha(this.getCastedModel().getAlpha());
        }
    }

    private void setViewAlpha(int alpha) {
        this.getCastedView().setAlpha(alpha);
    }

    private Command createViewCommand() {
        LinkedList<InheritanceRelation> relations = new LinkedList<InheritanceRelation>();
        relations.add(this.getCastedModel());
        return new InheritanceRelationPermanentCommand(relations);
    }

    private Figure createViewToolTip() {
        return new Label("Type \"" + this.getCastedModel().getChild().toString() + "\" inherites from type \"" + this.getCastedModel().getSuper().toString() + "\".");
    }
}

