//
//  main.m
//  TestMultitouchFramework
//
//  Created by Chatchavan Wacharamanotham on 11/04/2011.
//  Copyright 2011 Media Computing Group, RWTH Aachen. All rights reserved.
//

#import <Foundation/Foundation.h>

#include <unistd.h>
#include <CoreFoundation/CoreFoundation.h>
#include "MTDeviceDeclarations.h"


int touchCallback(int device, Touch *data, int nFingers, double timestamp, int frame)
{
		printf("Device: %d\n",device);
		for (int i=0; i<nFingers; i++)
		{
			Touch *f = &data[i];
			printf("frame: %d, timestamp: %f, ID: %d, state: %d, PosX: %f, PosY: %f, VelX: %f, VelY: %f, Angle: %f, MajorAxis: %f, MinorAxis: %f\n",
                   f->frame,
                   f->timestamp,
                   f->identifier,
                   f->state,
                   f->normalized.position.x,
                   f->normalized.position.y,
                   f->normalized.velocity.x,
                   f->normalized.velocity.y,
                   f->angle,
                   f->majorAxis,
                   f->minorAxis);
		}
		printf("\n");
    return 0;
}

int main(void)
{	
	NSMutableArray* deviceList = (NSMutableArray*)MTDeviceCreateList(); //grab our device list
	
	for(int i = 0; i<[deviceList count]; i++) //iterate available devices
	{
		MTRegisterContactFrameCallback([deviceList objectAtIndex:i], touchCallback); //assign callback for device
        MTDeviceStart([deviceList objectAtIndex:i], 0); //start sending events
	}
    printf("Ctrl-C to abort\n");
    sleep(-1);
    return 0;
}