//
//  InputViewController.m
//  iSlang
//
//  Created by Azmat Arif on 3/8/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "InputViewController.h"
#import "TextViewController.h"

#define INIT_WORD_ARRAY 0

@implementation InputViewController

@synthesize words;
//int i = 2;

- (BOOL)canBecomeFirstResponder {
    return YES;
}

- (void)viewDidAppear:(BOOL)animated {
    [self becomeFirstResponder];
}

- (void)motionBegan:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
	
	int i = (arc4random()%[self.words count]);
	
	NSString *theWord = [[words allKeys] objectAtIndex:i];
	
	
	NSLog(@"%d",i);
	
	
	NSLog(@"%@", theWord);
	
	NSString *result = [self.words objectForKey:theWord];
	
	TextViewController *textViewController = [[TextViewController alloc] initWithWord:theWord
																	   andTranslation:result];
	
	// display a more detailed view controller
	
	[self.navigationController pushViewController:textViewController animated:YES];
	
	[textViewController release];	
}

- (void)motionEnded:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
		
	
}

- (void)motionCancelled:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
	
}




- (void)search{
	

	[textField resignFirstResponder];
	
	// get the search term from the text field
	NSString *searchTerm = textField.text;
	
	NSLog(@"text entered: %@", searchTerm);
	
	NSLog(@"%d", words.count);

/*
	for(int i = 0; i<words.count; i++){
		if([searchTerm caseInsensitiveCompare:[words objectAtIndex:i]] == NSOrderedSame)
		{
			NSLog(@"word found in array");
		}
		else {
			NSLog(@"The word you looked for does not exist.");
		}
	}
*/	

	NSString *result = [self.words objectForKey:searchTerm];

	NSLog(@"The results is: %@", result);

	if (result != nil) {
		NSLog(@"word found in array");
		
		
		TextViewController *textViewController = [[TextViewController alloc] initWithWord:searchTerm
																		   andTranslation:result];
		
		// display a more detailed view controller
		
		[self.navigationController pushViewController:textViewController animated:YES];
		
		[textViewController release];		
		
		
	}
	else {
		NSLog(@"word not found in array");
	}
	
/*	for(NSArray *keyArray in words){
		if ([searchTerm caseInsensitiveCompare:[words objectForKey:keyArray] == NSOrderedSame]) {
			
		}
	}*/
	
	
	
	
	// update the table view below
//	[outputViewController setSearchTerm:searchTerm];
	[self becomeFirstResponder];
}


// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization.
    }
    return self;
}
*/


- (IBAction) edit:(id)sender {
	[self setEditing:YES animated:YES];
}


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	
	self.title = @"Slang it!";
	
	// DO NOT DELETE YET!

#if INIT_WORD_ARRAY > 0	
	NSArray *keyArray = [NSArray arrayWithObjects:@"Snowbooking", @"Bowl noob", @"Shawty", @"Boo", @"Homie", @"DBS", @"Captain Obvious", @"Lamo", @"FBI", nil];
	NSArray *wordArray = [NSArray arrayWithObjects:@"To constantly update your status or post on Facebook during a snowstorm. Normally, because your stuck inside and bored out of your mind.", 
						  @"Someone who puts a bowl in the dishwasher facing down with a less than 45 degree angle of attack. Hence the dishwasher can not wash the inners on the bowl.", 
						  @"Used mostly by individuals from the Atlanta area.\n"
						  "Referring to a sexy female.\n" 
						  "Referring to a friend or associate.\n"
						  "1) Aye shawty! Let me holla at ya.\n" 
						  "2) Was up shawty. ", 
						  @"1. Boyfriend or girlfriend.\n" 
						  "2. It is a pet name like your honey,sweety,baby.\n"
						  "3. To scare people.\n",
						  @"Friend.\n"
						  "That boy is my homie!\n",
						  @"Dumb Bitch Syndrome.\n" 
						  "Example: Your girl stole my liquor, she must suffer from DBS.\n",
						  @"One who always points out the things we already know.\n"
						  "Example: Thank you, Captain Obvious! \n",
						  @"Someone who is really lame. \n"
						  "Example: Ryan Schieve is a total Lamo!\n",
						  @"Female Body Inspector.\n" 
						  "Example: Can we get the FBI over here? \n",						  
						  nil];
	

	
#endif
	
	//add a button to add more words
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] 
								  initWithBarButtonSystemItem:UIBarButtonSystemItemAdd
								  target:self
								  action:@selector(addWord)];
	self.navigationItem.rightBarButtonItem = addButton;
	[addButton release];
	
	
	// Uncomment the following line to display an Edit button in the navigation bar for this view controller.
	//self.navigationItem.leftBarButtonItem = self.editButtonItem;
	
	NSString *editTitle = @"Edit"; 
	UIBarButtonItem *editButton = [[UIBarButtonItem alloc] 
								   initWithBarButtonSystemItem:UIBarButtonSystemItemEdit 
								   target:self 
								   action:@selector(editRow)]; 
	self.navigationItem.leftBarButtonItem = editButton; 
	[editButton release]; 
	
#if INIT_WORD_ARRAY > 0 
	self.words = [NSMutableDictionary dictionaryWithObjects:wordArray forKeys:keyArray];

	[self saveToFile];
#endif
	
	[self loadFromFile];

	
	/*
	
	//Initialize the array//
	listOfWords = [[NSMutableArray alloc] init];
	NSArray *testWords = [NSArray arrayWithObjects:@"Snowbooking", @"Bowl noob", @"Shawty", nil];
//	NSDictionary *testWordsDictionary = [NSArray dictionaryWithObject: testWords forKey:@"Words"];
	
//	[listOfWords addObject:testWordsDictionary];
	
	//Initialize the array of search results
	searchedListOfWords = [[NSMutableArray alloc] init];
	
	//Add the search bar
//	self.tableView.tableHeaderView = searchBar;
	textField.autocorrectionType = UITextAutocorrectionTypeNo;
	
	//searching = NO;
	//letUserSelectRow = YES;
	*/
}

- (void)editRow
{
	UIBarButtonItem *editButton = [[UIBarButtonItem alloc] 
								   initWithBarButtonSystemItem:UIBarButtonSystemItemEdit 
								   target:self 
								   action:@selector(editRow)];
	
	if ([editButton.title isEqualToString:@"Edit"]) {
		[self.inputView setEditing:YES animated:YES];
		[editButton setTitle:@"Done"];
	}
	else {
		[self.inputView setEditing:NO animated:YES];
		[editButton setTitle:@"Edit"];
	}
}


- (void)saveToFile
{
	NSArray *documentDirectories = 
	NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
										NSUserDomainMask,
										YES);
	NSString *documentDirectory = [documentDirectories objectAtIndex:0];
	
	[NSKeyedArchiver archiveRootObject:self.words toFile:[documentDirectory stringByAppendingPathComponent:@"iSlang"]];
	
	
}
	 
- (void)loadFromFile
{
	NSArray *documentDirectories = 
	NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
										NSUserDomainMask,
										YES);
	NSString *documentDirectory = [documentDirectories objectAtIndex:0];
	
	self.words = [NSKeyedUnarchiver unarchiveObjectWithFile:[documentDirectory stringByAppendingPathComponent:@"iSlang"]];

}

-(void)addWord
{
	NSLog(@"Word was entered.");

	//newWordEntered:@"translation" ;withTranslation: @"titleField";
	TextViewController *textViewController = [[TextViewController alloc] initForNewWordWithDictionary:self.words];
	textViewController.titleField.hidden = NO;
	
	// display a more detailed view controller
	
	textViewController.delegate = self;
	[self.navigationController pushViewController:textViewController animated:YES];
	
    [textViewController release];
	
}

// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    NSLog(@"here!!");

	
	// Return NO if you do not want the specified item to be editable.
    return YES;
}


// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
	NSLog(@"Method reached.");
    if (editingStyle == UITableViewCellEditingStyleDelete) {
		NSLog(@"Method reached.");

		
		NSString *theKey = [[words allKeys] objectAtIndex:indexPath.row];
        [words removeObjectForKey:theKey];
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath]
						 withRowAnimation:UITableViewRowAnimationFade];
		[self saveToFile];
    }   
}

/*//
 - (void)newWordEntered:(NSString *)word withTranslation:(NSString *)aTranslation;
 {
 [self.words setObject:aTranslation forKey:word];
 }
 
*/
/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
    return [self.words count];
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
	
	NSString *info = [[self.words allKeys] objectAtIndex:indexPath.row];

	//[[self.words allKeys] objectAtIndex:indexPath.row];
	
    // Configure the cell...
//	cell.textLabel.text = [[self.words allKeys] objectAtIndex:indexPath.row];
	cell.textLabel.text = info;

    return cell;
}


/*
 // Override to support conditional editing of the table view.
 - (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the specified item to be editable.
 return YES;
 }
 */


/*
 // Override to support editing the table view.
 - (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
 
 if (editingStyle == UITableViewCellEditingStyleDelete) {
 // Delete the row from the data source.
 [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
 }   
 else if (editingStyle == UITableViewCellEditingStyleInsert) {
 // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
 }   
 }
 */


/*
 // Override to support rearranging the table view.
 - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
 }
 */


/*
 // Override to support conditional rearranging of the table view.
 - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the item to be re-orderable.
 return YES;
 }
 */


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	
	
	TextViewController *textViewController;
	
//	NSDictionary *info;
//	info = [[self.words allKeys] objectAtIndex:indexPath.row];
	
	//textViewController = [[TextViewController alloc] initWithInfo:info];
	textViewController = [[TextViewController alloc] initWithWord:[[self.words allKeys] objectAtIndex:indexPath.row] andTranslation:[self.words objectForKey:[[self.words allKeys] objectAtIndex:indexPath.row]]];
	textViewController.titleField.hidden = YES;
	
	// display a more detailed view controller
	
	// TODO: textViewController.lastViewController = self;
	[self.navigationController pushViewController:textViewController animated:YES];
	
    [textViewController release];
    
}




- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


#pragma mark New word was entered
// TODO: implement that stuff
- (void)newWordAdded{
	//[self.words setObject:aTranslation forKey:word];
	NSLog(@"%@",self.words);
	[self saveToFile];
}


- (void)dealloc {
	
//	[words release];
    [super dealloc];
}


@end
