//
//  TextViewController.m
//  iSlang
//
//  Created by Azmat Arif on 3/9/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "TextViewController.h"
#import "InputViewController.h";


@implementation TextViewController

@synthesize textView, titleField, delegate;
@synthesize word, translation;




- (id)initWithWord:(NSString *)someWord andTranslation:(NSString *)someTranslation;

{
	self = [super init];
	if (self != nil) {
		self.title = someWord;
		self.word = someWord;
		self.translation = someTranslation;
		
		titleShouldBeHidden = YES;


	}
	return self;
}

- (id) initForNewWordWithDictionary:(NSMutableDictionary *)aDictionary;
{
	self = [super init];
	if (self != nil) {
		words = [aDictionary retain];
		titleShouldBeHidden = NO;

		
		UIBarButtonItem *saveButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemSave target:self action:@selector(saveButtonClicked:)];
		self.navigationItem.rightBarButtonItem = saveButton;
		[saveButton release];
	}
	return self;
}


- (void)saveButtonClicked:(id)sender;
{
	NSLog(@"Save button clicked");
	[words setValue:textView.text forKey:titleField.text];
	if ([delegate respondsToSelector:@selector(newWordAdded)]) {
		[delegate newWordAdded];
	}
}


/*
- (id)initWithInfo:(NSMutableDictionary *)someInfo;
{
	self = [super initWithNibName:@"TextViewController" bundle:nil];
	if (self != nil) {
		
		info = [someInfo retain];
	//	self.words = [NSMutableDictionary dictionaryWithObjects:wordArray forKeys:keyArray];

	//	self.words = [NSMutableDictionary dictionaryWithObjects:words];
		
		self.title = [info objectForKey:@"word"];

	}
	return self;
}
*/
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
	
    [super viewDidLoad];
		textView.text = self.translation;
	
	if (titleShouldBeHidden)
	{
		self.titleField.hidden = YES;
		self.titleField.enabled = NO;
		self.titleField.alpha = 0.;
	}
	else {
		
		self.titleField.hidden = NO;
		self.titleField.enabled = YES;
		self.titleField.alpha = 1.;
	}

	//textView.text = [info objectForKey:@"translation"];
//	textView.text = [self.words allKeys];
	
	
//		cell.textLabel.text = [[self.words allKeys] objectAtIndex:indexPath.row];

}


// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization.
    }
    return self;
}
*/

/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
	[word release];
}


- (void)dealloc {
	self.translation = nil;
	self.word = nil;
    [super dealloc];
}


@end
