//
//  PocketPets0_2ViewController.m
//  PocketPets0.2
//
//  Created by Al Harith Al-Jamali on 3/8/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "PocketPets0_2ViewController.h"
#import "MenuTableViewController.h"
#import "DraggableFood.h"
#import <AudioToolbox/AudioServices.h>

@implementation PocketPets0_2ViewController

@synthesize imageView, tapRecognizer, containerView, strokeView, imageViewGesture, imageViewFood;//, segmentedControl;


- (BOOL)canBecomeFirstResponder {
    return YES;
}


/*- (void)createGestureRecognizers {
    UITapGestureRecognizer *singleFingerDTap = [[UITapGestureRecognizer alloc]
												initWithTarget:self action:@selector(handleSingleDoubleTap:)];
    singleFingerDTap.numberOfTapsRequired = 2;
    [self.imageView addGestureRecognizer:singleFingerDTap];
    [singleFingerDTap release];
}



- (IBAction)handleSingleDoubleTap:(UIGestureRecognizer *)sender {
	self.imageView.image = [UIImage imageNamed:@"PetHappy1.1.png"];
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
}
*/


- (void)motionBegan:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
	self.imageView.image = [UIImage imageNamed:@"Pet2Dizzy.png"];
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];

}

- (void)motionEnded:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
	
}

- (void)motionCancelled:(UIEventSubtype)motion withEvent:(UIEvent *)event
{
	
	
}


- (IBAction)openMenu;

{
	MenuTableViewController *menuViewController = [[MenuTableViewController alloc] initWithNibName:@"MenuTableViewController" bundle:nil];
	
	UINavigationController *navController = [[UINavigationController alloc] initWithRootViewController:menuViewController];
	[menuViewController release];
	
	[self presentModalViewController:navController animated:YES];
	[navController release];
}
- (IBAction)dismissMenu {
    [self dismissModalViewControllerAnimated:YES];
}



- (IBAction)punishPet
{
	self.imageView.image = [UIImage imageNamed:@"Pet2.1Angry.png"];
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
	
	}


- (IBAction)petPet
{
	self.imageView.image = [UIImage imageNamed:@"Pet2Cool.png"];
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
}


- (IBAction)feedPet

{
	if(imageViewFood.hidden=false)
		imageViewFood.hidden=true;
	
	else if(imageViewFood.hidden=true)
		imageViewFood.hidden=false;

	

}



- (void) touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event
{
	CGPoint orangePoint;
	orangePoint.x = 45;
	orangePoint.y = 370;
	UITouch *myTouch = [[event allTouches] anyObject];
	if (imageViewFood.hidden==false) 
	imageViewFood.center = [myTouch locationInView:self.view];
	else {
		imageViewFood.center = orangePoint;
	}


	
	[self checkCollision];
	
	
	
}

-(void)checkCollision {
	
	if(CGRectIntersectsRect(imageViewFood.frame, imageView.frame))
	{
	
		self.imageView.image = [UIImage imageNamed:@"Pet2Full.png"];
		[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
	    imageViewFood.hidden=true;
		
		//Get the filename of the sound file:
		NSString *path = [NSString stringWithFormat:@"%@%@",
						  [[NSBundle mainBundle] resourcePath],
						  @"/aud_chomp.aif"];
		
		//declare a system sound id
		SystemSoundID soundID4;
		
		//Get a URL for the sound file
		NSURL *filePath = [NSURL fileURLWithPath:path isDirectory:NO];
		
		//Use audio sevices to create the sound
		AudioServicesCreateSystemSoundID((CFURLRef)filePath, &soundID4);
		
		//Use audio services to play the sound
		AudioServicesPlaySystemSound(soundID4);
		

		
	}


	
}
		





- (void)update:(NSTimer *)timer;
{
	self.imageView.image = [UIImage imageNamed:@"Pet2Blink.png"];
	[NSTimer scheduledTimerWithTimeInterval:0.2 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
}

- (void)update2:(NSTimer *)timer;
{
	self.imageView.image = [UIImage imageNamed:@"Pet2.png"];
}

- (void)viewDidAppear:(BOOL)animated;
{
    [self becomeFirstResponder];
	
	[NSTimer scheduledTimerWithTimeInterval:3.0 target:self selector:@selector(update:) userInfo:nil repeats:YES];
	float randomTime = 5.0 + (rand() % 100) / 10.0;
}


/*
 UIImage *image = [UIImage imageNamed:@"PetNormal.png"];
 UIImageView *newObject = [[UIImageView alloc] initWithImage:image];
 */
/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	srand(time(0));
	
	UIGestureRecognizer *recognizer;
	
	recognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleTapFrom:)];
	[self.containerView addGestureRecognizer:recognizer];
    self.tapRecognizer = (UITapGestureRecognizer *)recognizer;
    recognizer.delegate = self;
	[recognizer release];
	
	recognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:self action:@selector(handleSwipeFrom:)];
	[self.containerView addGestureRecognizer:recognizer];
	[recognizer release];
	
	recognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:self action:@selector(handleSwipeFromStroke:)];
	[self.strokeView addGestureRecognizer:recognizer];
	[recognizer release];
	
		
	
	
	

	//[segmentedControl setExclusiveTouch:YES];
	
	/*recognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:self action:@selector(handleSwipeFrom:)];
	self.swipeLeftRecognizer = (UISwipeGestureRecognizer *)recognizer;
    swipeLeftRecognizer.direction = UISwipeGestureRecognizerDirectionLeft;	
	*/
}

/*- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch {
	
    // Disallow recognition of tap gestures in the segmented control.
    if ((touch.view == segmentedControl) && (gestureRecognizer == tapRecognizer)) {
        return NO;
    }
    return YES;
}*/



- (void)showImageWithText:(NSString *)string atPoint:(CGPoint)centerPoint {
	
    
     //Set the appropriate image for the image view, move the image view to the given point, then dispay it by setting its alpha to 1.0.
     
	NSString *imageName = [string stringByAppendingString:@".png"];
	imageViewGesture.image = [UIImage imageNamed:imageName];
	imageViewGesture.center = centerPoint;
	imageViewGesture.alpha = 1.0;	
}


- (void)handleTapFrom:(UITapGestureRecognizer *)recognizer {
	
	self.imageView.image = [UIImage imageNamed:@"Pet2Fed.png"];
	
	CGPoint location = [recognizer locationInView:self.view];
	
	[self showImageWithText:@"Pat" atPoint:location];
	location.y += 50;
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.3];
	imageViewGesture.alpha = 0.0;
	imageViewGesture.center = location;
	[UIView commitAnimations];
	
	//Get the filename of the sound file:
	NSString *path = [NSString stringWithFormat:@"%@%@",
					  [[NSBundle mainBundle] resourcePath],
					  @"/pet.wav"];
	
	//declare a system sound id
	SystemSoundID soundID3;
	
	//Get a URL for the sound file
	NSURL *filePath = [NSURL fileURLWithPath:path isDirectory:NO];
	
	//Use audio sevices to create the sound
	AudioServicesCreateSystemSoundID((CFURLRef)filePath, &soundID3);
	
	//Use audio services to play the sound
	AudioServicesPlaySystemSound(soundID3);
	
	
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
	NSLog(@"PetHappyGesture!");
}

- (void)handleSwipeFrom:(UITapGestureRecognizer *)recognizer {
	
	if(imageViewFood.hidden=true){
	
	self.imageView.image = [UIImage imageNamed:@"Pet2.1Angry.png"];
	
	CGPoint location = [recognizer locationInView:self.view];
	[self showImageWithText:@"Slap" atPoint:location];
	location.x += 330.0;
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.55];
	imageViewGesture.alpha = 0.0;
		imageViewGesture.center = location;}
	
	
	
	//Get the filename of the sound file:
	NSString *path = [NSString stringWithFormat:@"%@%@",
					 [[NSBundle mainBundle] resourcePath],
					  @"/slap_2.wav"];
	
	//declare a system sound id
	SystemSoundID soundID;
	
	//Get a URL for the sound file
	NSURL *filePath = [NSURL fileURLWithPath:path isDirectory:NO];
	
	//Use audio sevices to create the sound
	AudioServicesCreateSystemSoundID((CFURLRef)filePath, &soundID);
	
	//Use audio services to play the sound
	AudioServicesPlaySystemSound(soundID);
	
	

	
	
	[UIView commitAnimations];
	
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
	
	
}

- (void)handleSwipeFromStroke:(UITapGestureRecognizer *)recognizer {
	

	
	self.imageView.image = [UIImage imageNamed:@"Pet2Cool.png"];
	
	CGPoint location = [recognizer locationInView:self.view];
	[self showImageWithText:@"Stroke" atPoint:location];
	location.x += 110.0;
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:1.10];
	imageViewGesture.alpha = 0.0;
	imageViewGesture.center = location;
	
	
	//Get the filename of the sound file:
	NSString *path = [NSString stringWithFormat:@"%@%@",
					  [[NSBundle mainBundle] resourcePath],
					  @"/stroke2.wav"];
	
	//declare a system sound id
	SystemSoundID soundID2;
	
	//Get a URL for the sound file
	NSURL *filePath = [NSURL fileURLWithPath:path isDirectory:NO];
	
	//Use audio sevices to create the sound
	AudioServicesCreateSystemSoundID((CFURLRef)filePath, &soundID2);
	
	//Use audio services to play the sound
	AudioServicesPlaySystemSound(soundID2);

	
	
	[UIView commitAnimations];
	
	[NSTimer scheduledTimerWithTimeInterval:2.75 target:self selector:@selector(update2:) userInfo:nil repeats:NO];
	
}




/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
	self.tapRecognizer = nil;
	//self.swipeLeftRecognizer = nil;
	
}


- (void)dealloc {
	self.containerView = nil;
	[tapRecognizer release];
	//[segmentedControl release];
	//[swipeLeftRecognizer release];
	[super dealloc];
}
		

@end
