//
//  DraggableFood.m
//  PocketPets0.2
//
//  Created by Al Harith Al-Jamali on 3/16/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "DraggableFood.h"


@implementation DraggableFood

- (id)initWithImage:(UIImage *)image
{
	if (self = [super initWithImage:image])
		self.userInteractionEnabled = YES;
	return self;
}

- (void) touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event
{
	// When a touch starts, get the current location in the view
	currentPoint = [[touches anyObject] locationInView:self];
}

- (void) touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event
{
	// Get active location upon move
	CGPoint activePoint = [[touches anyObject] locationInView:self];
	
	// Determine new point based on where the touch is now located
	CGPoint newPoint = CGPointMake(self.center.x + (activePoint.x - currentPoint.x),
								   self.center.y + (activePoint.y - currentPoint.y));
	
	
	

	//--------------------------------------------------------
	// Make sure we stay within the bounds of the parent view
	//--------------------------------------------------------
	float midPointX = CGRectGetMidX(self.bounds);
	// If too far right...
	if (newPoint.x > self.superview.bounds.size.width  - midPointX)
		newPoint.x = self.superview.bounds.size.width - midPointX;
	else if (newPoint.x < midPointX) 	// If too far left...
		newPoint.x = midPointX;
	
	float midPointY = CGRectGetMidY(self.bounds);
	// If too far down...
	if (newPoint.y > self.superview.bounds.size.height  - midPointY)
		newPoint.y = self.superview.bounds.size.height - midPointY;
	else if (newPoint.y < midPointY)	// If too far up...
		newPoint.y = midPointY;
	
	// Set new center location
	self.center = newPoint;

	
}



// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization.
    }
    return self;
}
*/

/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
