//
//  SmileyViewController.m
//  Smiley
//
//  Created by Carl Friedrich Huch on 21.02.11.
//  Copyright 2011 RWTH Aachen University. All rights reserved.
//

// Define minimal and maximal size of the smiley
#define kMAX_SIZE 128.0
#define kMIN_SIZE 64.0

#import "SmileyViewController.h"


@interface SmileyViewController ()
- (void)updatePosition:(CGRect *)frame;
- (void)updateSize:(CGRect *)frame;
@end



@implementation SmileyViewController

@synthesize smileyView;


// will be run by a repeating timer
- (void)update;
{
	CGRect frame = self.smileyView.frame;
	
	[self updateSize:&frame];
	[self updatePosition:&frame];
	
	self.smileyView.frame = frame;
}

#pragma mark private methods

// update the speed and change the position
- (void)updatePosition:(CGRect *)frame;
{
	CGRect bounds = self.view.bounds;
	
	// check horizontal bounding box
	if((frame->origin.x + frame->size.width >= bounds.origin.x + bounds.size.width) ||
	   (frame->origin.x <= bounds.origin.x)) {
		speed.x *= -1.0;
	}
	
	// check vertical bounding box
	if((frame->origin.y + frame->size.height >= bounds.origin.y + bounds.size.height) ||
	   (frame->origin.y <= bounds.origin.y)) {
		speed.y *= -1.0;
	}
	
	// move the smiley
	frame->origin.x += speed.x;
	frame->origin.y += speed.y;
}

// update the deltaSize and change the size
- (void)updateSize:(CGRect *)frame;
{
	// check width limit
	if(frame->size.width >= kMAX_SIZE || frame->size.width <= kMIN_SIZE) {
		deltaSize.width *= -1.0;
	}
	
	// check height limit
	if(frame->size.height >= kMAX_SIZE || frame->size.height <= kMIN_SIZE) {
		deltaSize.height *= -1.0;
	}
	
	// update the size
	frame->size.width += deltaSize.width;
	frame->size.height += deltaSize.height;
	
}


#pragma mark UIViewController

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	
	// init speed
	speed = CGPointMake(3.0, 2.0);
	// stretch factor
	deltaSize = CGSizeMake(3.0, 3.0);
	
	// start update timer
	[NSTimer scheduledTimerWithTimeInterval:1.0/60.0 target:self selector:@selector(update) userInfo:nil repeats:YES];
}


- (void)dealloc {
    [super dealloc];
}

@end