//
//  CAPongViewController.m
//  CAPong
//
//  Created by Florian Heller on 11/22/10.
//  Copyright 2010 RWTH Aachen University. All rights reserved.
//

#import "CAPongViewController.h"

@implementation CAPongViewController

// draw the layer
- (void)drawLayer:(CALayer *)layer inContext:(CGContextRef)context;
{
	CGImageRef ballImage = [UIImage imageNamed:@"ball.png"].CGImage;
	CGContextDrawImage(context, layer.bounds, ballImage);
}

// react to touches
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event;
{
	UITouch *touch = [touches anyObject];
	
	// update the position of the ball layer
	// this creates an implicit animation
	ballLayer.position = [touch locationInView:self.view];
}

// init
- (void)viewDidLoad;
{
	[super viewDidLoad];
	
	// create the ball layer
	ballLayer = [[CALayer alloc] init];
	ballLayer.delegate = self;
	ballLayer.frame = CGRectMake(135.0, 205.0, 50.0, 50.0);
	[self.view.layer addSublayer:ballLayer];
	[ballLayer setNeedsDisplay];
	
	// make it spin
	CABasicAnimation *spinAmination = [CABasicAnimation animationWithKeyPath:@"transform.rotation"];
	spinAmination.duration = 0.5;
	spinAmination.fromValue = [NSNumber numberWithInt:0];
	spinAmination.toValue = [NSNumber numberWithFloat:(2*M_PI)];
	spinAmination.repeatCount = 1e100;
	[ballLayer addAnimation:spinAmination forKey:@"spin"];
	
}

- (void)dealloc {
    [super dealloc];
}

@end
