//
//  BounceViewController.m
//  Bounce
//
//  Created by Florian Heller on 11/22/10.
//  Copyright 2010 RWTH Aachen University. All rights reserved.
//

#import "BounceViewController.h"
#import <QuartzCore/QuartzCore.h>


@implementation BounceViewController


// bounce the sender
- (IBAction)bounce:(UIView *)sender;
{
	CAKeyframeAnimation *bounceAnimation = [[CAKeyframeAnimation alloc] init];
	
	// configure the animation
	bounceAnimation.keyPath = @"transform";
	bounceAnimation.duration = 0.5;
	
	// create the values it will pass through
	CATransform3D forward  = CATransform3DMakeScale(1.3, 1.3, 1.0);
	CATransform3D back     = CATransform3DMakeScale(0.7, 0.7, 1.0);
	CATransform3D forward2 = CATransform3DMakeScale(1.2, 1.2, 1.0);
	CATransform3D back2    = CATransform3DMakeScale(0.9, 0.9, 1.0);
	bounceAnimation.values = [NSArray arrayWithObjects:
					 [NSValue valueWithCATransform3D:CATransform3DIdentity],
					 [NSValue valueWithCATransform3D:forward],
					 [NSValue valueWithCATransform3D:back],
					 [NSValue valueWithCATransform3D:forward2],
					 [NSValue valueWithCATransform3D:back2],
					 [NSValue valueWithCATransform3D:CATransform3DIdentity],nil];
	
	// start animation
	[sender.layer addAnimation:bounceAnimation forKey:@"bounceAnimation"];
	[bounceAnimation release];
}

@end
