//
//  SmileyView.m
//  Smiley
//
//  Created by Carl Huch on 2/2/11.
//  Copyright 2011 RWTH Aachen University. All rights reserved.
//

#import "SmileyView.h"

// convert degrees to radians
CGFloat deg2rad(CGFloat deg) {
	return deg / 180.0 * M_PI;
}


@implementation SmileyView


// init
- (void)awakeFromNib;
{
	self.opaque = NO;
	self.backgroundColor = [UIColor colorWithWhite:1.0 alpha:0.0];
}


// draw the smiley
- (void)drawRect:(CGRect)rect {
	CGRect bounds = self.bounds;
	CGPoint origin = bounds.origin;
	CGSize size = bounds.size;
	CGFloat radius = MIN(size.height, size.width) / 2.0;
	CGPoint center = CGPointMake(origin.x + size.width / 2.0, origin.y + size.height / 2.0);
	
	// get the current graphics context
	CGContextRef context = UIGraphicsGetCurrentContext();
	
	/*
	// fill the background
	CGContextSetRGBFillColor(context, 1.0, 1.0, 1.0, 1.0);
	CGContextFillRect(context, bounds);
	 */

    // draw configuration
	CGContextSetLineWidth(context, 3.0);
	CGContextSetRGBFillColor(context, 1.0, 1.0, 0.0, 1.0);
	CGContextSetRGBStrokeColor(context, 0.0, 0.0, 0.0, 1.0);
	
	// smiley face
	CGContextFillEllipseInRect(context, CGRectMake(1.5, 1.5, size.width-3.0, size.height-3.0));
	CGContextStrokeEllipseInRect(context, CGRectMake(1.5, 1.5, size.width-3.0, size.height-3.0));

	// draw the mouth
	CGContextAddArc(context, center.x, center.y, radius * 0.8, deg2rad(30.0), deg2rad(150.0), 0);
	
	// draw the left eye
	CGContextMoveToPoint(context, center.x - (size.width * 0.2), center.y - (size.width * 0.1));
	CGContextAddLineToPoint(context, center.x - (size.width * 0.15), center.y - (size.width * 0.1));
	
	// draw the right eye
	CGContextMoveToPoint(context, center.x + (size.width * 0.2), center.y - (size.width * 0.1));
	CGContextAddLineToPoint(context, center.x + (size.width * 0.25), center.y - (size.width * 0.1));
	
	// stroke
	CGContextStrokePath(context);
	
}


- (void)dealloc {
    [super dealloc];
}


@end
