//
//  Path.h
//  TouchViz
//
//  Created by Jonathan Diehl on 25.11.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface RingBuffer : NSObject {
	
	// buffer settings
	NSUInteger capacity;
	size_t size;
	NSUInteger length;
	
	// buffer pointers
	void *buffer;
	void *buffer_end;
	
	// head and tail pointers
	void *head;
	void *tail;
}

@property(readonly) NSUInteger length;

// init
- (id)initWithSize:(size_t)aSize capacity:(NSUInteger)aCapacity;

// buffer manipulation
- (void)push:(void *)item;
- (void *)pop;

// array conversion
- (void)copyBuffer:(void *)copy;


@end
