//
//  UpDownGestureRecognizer.m
//  GestureRecognizers
//
//  Created by Jan-Peter Krämer on 01.09.10.
//  Copyright 2010 RWTH Aachen University. All rights reserved.
//

#import "UpDownGestureRecognizer.h"


@implementation UpDownGestureRecognizer

@synthesize numberOfTouchesRequired;


#pragma mark touch events

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event; 
{
	if([touches count] >= self.numberOfTouchesRequired) {
		self.state = UIGestureRecognizerStateBegan; 
	}
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event;
{
	if([touches count] >= self.numberOfTouchesRequired) {
		self.state = UIGestureRecognizerStateChanged; 
	}
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event;
{
	if([touches count] >= self.numberOfTouchesRequired) {
		self.state = UIGestureRecognizerStateEnded; 
	}
}

- (void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event;
{
	if([touches count] >= self.numberOfTouchesRequired) {
		self.state = UIGestureRecognizerStateCancelled; 
	}
}


#pragma mark reset

- (void)reset;
{
	// nothing
}


#pragma mark avoid conflicting gestures

-(BOOL)canPreventGestureRecognizer:(UIGestureRecognizer *)preventedGestureRecognizer; 
{
	return NO; 
}

- (BOOL)canBePreventedByGestureRecognizer:(UIGestureRecognizer *)preventingGestureRecognizer;
{
	return NO;
}

@end
