//
//  MultiFingerGestureControllerDelegate.h
//  GestureRecognizers
//
//  Created by Jan-Peter Krämer on 31.08.10.
//  Copyright 2010 RWTH Aachen University. All rights reserved.
//

enum GestureType_ {
	GestureTypeTap, 
	GestureTypeDoubleTap,
	GestureTypeSwipe,
	GestureTypeTouchDown,
	GestureTypeTouchUp
};
typedef enum GestureType_ GestureType; 

enum GestureDirection_ {
	GestureDirectionNone,
	GestureDirectionLeft, 
	GestureDirectionRight,
	GestureDirectionUp,
	GestureDirectionDown
};
typedef enum GestureDirection_ GestureDirection; 

@protocol MultiFingerGestureControllerDelegate
- (void)recognizedGestureType:(GestureType)type withNumberOfTouches:(int)fingerCount inDirection:(GestureDirection)direction; 
@end
