//
//  BuildInAppDelegate.m
//  BuildIn
//
//  Created by Jonathan Diehl on 03.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "BuildInAppDelegate.h"

#import <AddressBookUI/AddressBookUI.h>
#import <EventKitUI/EventKitUI.h>
#import <EventKit/EventKit.h>
#import <MediaPlayer/MediaPlayer.h>
#import <MessageUI/MessageUI.h>
#import <MapKit/MapKit.h>

@implementation BuildInAppDelegate

@synthesize window;


#pragma mark -
#pragma mark Application lifecycle

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	// Address Book UI
	// let the user pick a person from the local address book
	ABPeoplePickerNavigationController *addressBookVC = [[ABPeoplePickerNavigationController alloc] init];
	
	// EventKit
	// the event store will contain the events created by the edit view controller
	// just leaking for now...
	EKEventStore *eventStore = [[EKEventStore alloc] init];
	EKEventEditViewController *eventVC = [[EKEventEditViewController alloc] init];
	eventVC.eventStore = eventStore;
	
	// email
	MFMailComposeViewController *mailVC = [[MFMailComposeViewController alloc] init];
	
	// image picker
	UIImagePickerController *imagePickerVC = [[UIImagePickerController alloc] init];
	imagePickerVC.sourceType = UIImagePickerControllerSourceTypeCamera;
	
	// movie player
	NSURL *contentURL = [[NSBundle mainBundle] URLForResource:@"video" withExtension:@"mov"];
	MPMoviePlayerViewController *moviePlayerVC = [[MPMoviePlayerViewController alloc] initWithContentURL:contentURL];
	
	// media picker
	MPMediaPickerController *mediaPickerVC = [[MPMediaPickerController alloc] init];
	
	// map
	UIViewController *mapVC = [[UIViewController alloc] initWithNibName:@"MapViewController" bundle:nil];
	
	// web
	UIViewController *webVC = [[UIViewController alloc] initWithNibName:@"WebViewController" bundle:nil];
	[(UIWebView *)webVC.view loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"http://www.google.com"]]];
	
	// create the tab bar controller
    tabBarController = [[UITabBarController alloc] init];
	tabBarController.viewControllers = [NSArray arrayWithObjects:addressBookVC, eventVC, mailVC, imagePickerVC, moviePlayerVC, mediaPickerVC, mapVC, webVC, nil];
	
	// cleanup
	[addressBookVC release];
	[eventVC release];
	[imagePickerVC release];
	[moviePlayerVC release];
	[mediaPickerVC release];
	[mailVC release];
	[mapVC release];
	[webVC release];

    // Add the tab bar controller's view to the window and display.
    [self.window addSubview:tabBarController.view];
    [self.window makeKeyAndVisible];

    return YES;
}

@end

