/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import replicatorg.app.Base;
import replicatorg.app.syntax.SyntaxDocument;
import replicatorg.model.BuildElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCode
extends BuildElement
implements Comparable<BuildCode> {
    public String name;
    public File file;
    public String program;
    public SyntaxDocument document;
    public int selectionStart;
    public int selectionStop;
    public int scrollPosition;

    public BuildCode(String name, File file) {
        this.name = name;
        this.file = file;
        try {
            this.load();
        }
        catch (IOException e) {
            Base.logger.severe("error while loading code " + name);
        }
    }

    public void load() throws IOException {
        if (this.file == null) {
            this.program = "";
            this.setModified(true);
        } else {
            this.program = Base.loadFile(this.file);
            this.setModified(false);
        }
    }

    public void save() throws IOException {
        Base.saveFile(this.program, this.file);
        this.setModified(false);
    }

    public void saveAs(File newFile) throws IOException {
        Base.saveFile(this.program, newFile);
        this.file = newFile;
        this.name = this.file.getName();
        int lastIdx = this.name.lastIndexOf(46);
        if (lastIdx > 0) {
            this.name = this.name.substring(0, lastIdx);
        }
        this.setModified(false);
    }

    @Override
    public int compareTo(BuildCode other) {
        if (this.name == null) {
            return other.name == null ? 0 : -1;
        }
        return this.name.compareTo(other.name);
    }

    @Override
    public BuildElement.Type getType() {
        return BuildElement.Type.GCODE;
    }

    @Override
    void writeToStream(OutputStream ostream) {
    }
}

