/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

public class MachineState
implements Cloneable {
    private State state = State.NOT_ATTACHED;
    private Target target = Target.NONE;
    private boolean paused = false;

    public MachineState() {
    }

    public MachineState(State state) {
        this.state = state;
    }

    public MachineState(State state, Target target) {
        this.state = state;
        this.target = target;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isReady() {
        return this.state == State.READY;
    }

    public boolean isBuilding() {
        return this.state == State.BUILDING || this.state == State.PLAYBACK;
    }

    public boolean isSimulating() {
        return this.state == State.BUILDING && this.target == Target.SIMULATOR;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setState(State state) {
        this.state = state;
        this.paused = false;
    }

    public Target getTarget() {
        return this.target;
    }

    public State getState() {
        return this.state;
    }

    public boolean isInteractiveTarget() {
        return this.target == Target.MACHINE || this.target == Target.SIMULATOR;
    }

    public boolean isConnected() {
        return this.state != State.NOT_ATTACHED && this.state != State.CONNECTING;
    }

    public MachineState clone() {
        try {
            return (MachineState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MachineState)) {
            return false;
        }
        MachineState other = (MachineState)o;
        return other.state == this.state && other.target == this.target && other.paused == this.paused;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        NONE,
        MACHINE,
        SIMULATOR,
        SD_UPLOAD,
        FILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_ATTACHED,
        CONNECTING,
        READY,
        BUILDING,
        STOPPING,
        PLAYBACK,
        RESET;

    }
}

