/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.util.serial.Serial;
import replicatorg.drivers.BadFirmwareVersionException;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.PenPlotter;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SerialDriver;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketProcessor;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.uploader.FirmwareUploader;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sanguino3GDriver
extends SerialDriver
implements OnboardParameters,
SDCardCapture,
PenPlotter,
MultiTool {
    protected static final int DEFAULT_RETRIES = 5;
    Version toolVersion = new Version(0, 0);
    static boolean isNotifiedFinishedFeature = false;
    private final Version extendedStopVersion = new Version(2, 7);
    private boolean eepromChecked = false;
    private static final int EEPROM_CHECK_LOW = 90;
    private static final int EEPROM_CHECK_HIGH = 120;
    private static final int EEPROM_CHECK_OFFSET = 0;
    private static final int EEPROM_MACHINE_NAME_OFFSET = 32;
    private static final int EEPROM_AXIS_INVERSION_OFFSET = 2;
    private static final int EEPROM_ENDSTOP_INVERSION_OFFSET = 3;
    private static final int EC_EEPROM_EXTRA_FEATURES = 24;
    private static final int EC_EEPROM_SLAVE_ID = 26;
    private static final int MAX_MACHINE_NAME_LEN = 16;
    FileOutputStream fileCaptureOstream = null;

    public Sanguino3GDriver() {
        this.minimumVersion = new Version(1, 1);
        this.preferredVersion = new Version(2, 0);
        this.setInitialized(false);
    }

    @Override
    public void loadXML(Node xml) {
        super.loadXML(xml);
    }

    @Override
    public void initialize() {
        assert (this.serial != null) : "No serial port found.";
        if (!this.isInitialized()) {
            try {
                int timeout = 2600;
                this.connectToDevice(timeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isInitialized()) {
            if (this.version.compareTo(this.getMinimumVersion()) < 0) {
                throw new BadFirmwareVersionException(this.version, this.getMinimumVersion());
            }
            this.sendInit();
            super.initialize();
            this.invalidatePosition();
            return;
        }
        Base.logger.log(Level.INFO, "Unable to connect to firmware.");
        this.dispose();
    }

    private boolean attemptConnection() {
        this.serial.clear();
        this.version = this.getVersionInternal();
        if (this.getVersion() != null) {
            this.setInitialized(true);
        }
        return this.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToDevice(int timeoutMillis) {
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            this.serial.clear();
            this.serial.setTimeout(timeoutMillis);
            if (this.attemptConnection()) {
                return;
            }
            try {
                Thread.sleep(2600L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.attemptConnection()) {
                return;
            }
            Base.logger.warning("No connection; trying to pulse RTS to reset device.");
            this.serial.pulseRTSLow();
            try {
                Thread.sleep(2600L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            this.attemptConnection();
        }
    }

    protected PacketResponse runCommand(byte[] packet) throws RetryException {
        return this.runCommand(packet, 5);
    }

    protected PacketResponse runQuery(byte[] packet, int retries) {
        try {
            return this.runCommand(packet, retries);
        }
        catch (RetryException re) {
            throw new RuntimeException("Queries can not have valid retries!");
        }
    }

    protected PacketResponse runQuery(byte[] packet) {
        return this.runQuery(packet, 1);
    }

    void printDebugData(String title, byte[] data) {
        if (Base.logger.isLoggable(Level.FINER)) {
            StringBuffer buf = new StringBuffer(title + ": ");
            for (int i = 0; i < data.length; ++i) {
                buf.append(Integer.toHexString(data[i] & 0xFF));
                buf.append(" ");
            }
            Base.logger.log(Level.FINER, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketResponse runCommand(byte[] packet, int retries) throws RetryException {
        boolean isCommand;
        if (retries == 0) {
            Base.logger.severe("Packet timed out!");
            return PacketResponse.timeoutResponse();
        }
        if (packet == null || packet.length < 4) {
            Base.logger.severe("Attempt to send empty or too-small packet");
            return null;
        }
        boolean bl = isCommand = (packet[2] & 0x80) != 0;
        if (this.fileCaptureOstream != null) {
            try {
                if (isCommand) {
                    this.fileCaptureOstream.write(packet, 2, packet.length - 3);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return PacketResponse.okResponse();
        }
        if (this.serial == null) {
            return PacketResponse.timeoutResponse();
        }
        PacketResponse pr = new PacketResponse();
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            if (Thread.currentThread().isInterrupted()) {
                Thread.interrupted();
                try {
                    Thread.sleep(10L);
                    this.serial.clear();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Thread.currentThread().interrupt();
                return pr;
            }
            PacketProcessor pp = new PacketProcessor();
            this.serial.write(packet);
            this.printDebugData("OUT", packet);
            boolean completed = false;
            while (!completed) {
                int b = this.serial.read();
                if (b == -1) {
                    if (Thread.currentThread().isInterrupted()) break;
                    if (retries > 1) {
                        Base.logger.severe("Read timed out; retries remaining: " + Integer.toString(retries));
                    }
                    if (retries == -1) {
                        return PacketResponse.timeoutResponse();
                    }
                    if (retries < 0) {
                        return this.runCommand(packet, retries + 1);
                    }
                    return this.runCommand(packet, retries - 1);
                }
                try {
                    completed = pp.processByte((byte)b);
                }
                catch (PacketProcessor.CRCException e) {
                    Base.logger.severe("Bad CRC received; retries remaining: " + Integer.toString(retries));
                    return this.runCommand(packet, retries - 1);
                }
            }
            if (!(pr = pp.getResponse()).isOK()) {
                if (pr.getResponseCode() == PacketResponse.ResponseCode.BUFFER_OVERFLOW) {
                    throw new RetryException();
                }
                this.printDebugData("Unknown error sending, retry", packet);
                if (retries > 1) {
                    return this.runCommand(packet, retries - 1);
                }
            }
        }
        return pr;
    }

    @Override
    public boolean isFinished() {
        if (this.fileCaptureOstream != null) {
            return true;
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.IS_FINISHED.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (!pr.isOK()) {
            return false;
        }
        int v = pr.get8();
        if (pr.getResponseCode() == PacketResponse.ResponseCode.UNSUPPORTED) {
            if (!isNotifiedFinishedFeature) {
                Base.logger.severe("IsFinished not supported by this firmware. Update your firmware.");
                isNotifiedFinishedFeature = true;
            }
            return true;
        }
        boolean finished = v != 0;
        Base.logger.log(Level.FINE, "Is finished: " + Boolean.toString(finished));
        return finished;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public Version getVersionInternal() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.VERSION.getCode());
        pb.add16(24);
        PacketResponse pr = this.runQuery(pb.getPacket(), 1);
        if (pr.isEmpty()) {
            return null;
        }
        int versionNum = pr.get16();
        pb = new PacketBuilder(MotherboardCommandCode.GET_BUILD_NAME.getCode());
        pb.add16(24);
        String buildname = "";
        pr = this.runQuery(pb.getPacket(), 1);
        if (!pr.isEmpty()) {
            byte[] payload = pr.getPayload();
            byte[] subarray = new byte[payload.length - 1];
            System.arraycopy(payload, 1, subarray, 0, subarray.length);
            buildname = " (" + new String(subarray) + ")";
        }
        Base.logger.log(Level.FINE, "Reported version: " + versionNum + " " + buildname);
        if (versionNum == 0) {
            Base.logger.severe("Null version reported!");
            return null;
        }
        Version v = new Version(versionNum / 100, versionNum % 100);
        Base.logger.warning("Motherboard firmware v" + v + buildname);
        String MB_NAME = "RepRap Motherboard v1.X";
        FirmwareUploader.checkLatestVersion("RepRap Motherboard v1.X", v);
        for (ToolModel t : this.getMachine().getTools()) {
            if (t == null) continue;
            this.initSlave(t.getIndex());
        }
        if (v.getMajor() < 2) {
            this.serial.setTimeout(Integer.MAX_VALUE);
        }
        return v;
    }

    private void initSlave(int toolIndex) {
        byte[] payload;
        PacketBuilder slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolIndex);
        slavepb.add8(ToolCommandCode.VERSION.getCode());
        int slaveVersionNum = 0;
        PacketResponse slavepr = this.runQuery(slavepb.getPacket(), -2);
        if (!slavepr.isEmpty()) {
            slaveVersionNum = slavepr.get16();
        }
        slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolIndex);
        slavepb.add8(ToolCommandCode.GET_BUILD_NAME.getCode());
        slavepr = this.runQuery(slavepb.getPacket(), -2);
        String buildname = "";
        slavepr = this.runQuery(slavepb.getPacket(), 1);
        if (!slavepr.isEmpty() && (payload = slavepr.getPayload()).length > 0) {
            byte[] subarray = new byte[payload.length - 1];
            System.arraycopy(payload, 1, subarray, 0, subarray.length);
            buildname = " (" + new String(subarray) + ")";
        }
        Base.logger.log(Level.FINE, "Reported slave board version: " + slaveVersionNum + " " + buildname);
        if (slaveVersionNum == 0) {
            Base.logger.severe("Toolhead " + Integer.toString(toolIndex) + ": Not found.\nMake sure the toolhead is connected, the power supply is plugged in and turned on, and the power switch on the motherboard is on.");
        } else {
            Version sv;
            this.toolVersion = sv = new Version(slaveVersionNum / 100, slaveVersionNum % 100);
            Base.logger.warning("Toolhead " + Integer.toString(toolIndex) + ": Extruder controller firmware v" + sv + buildname);
            String EC_NAME = "Extruder Controller v2.2";
            FirmwareUploader.checkLatestVersion("Extruder Controller v2.2", sv);
        }
    }

    public void sendInit() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.INIT.getCode());
        this.runQuery(pb.getPacket());
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        Base.logger.log(Level.FINE, "Queued point " + p);
        Point5d deltaSteps = this.getAbsDeltaSteps(this.getCurrentPosition(), p);
        double masterSteps = this.getLongestLength(deltaSteps);
        if (masterSteps > 0.0) {
            Point5d steps = this.machine.mmToSteps(p);
            Point5d delta = this.getDelta(p);
            double feedrate = this.getSafeFeedrate(delta);
            long micros = this.convertFeedrateToMicros(this.getCurrentPosition(), p, feedrate);
            this.queueAbsolutePoint(steps, micros);
            super.queuePoint(p);
        }
    }

    protected void queueAbsolutePoint(Point5d steps, long micros) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_POINT_ABS.getCode());
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.log(Level.FINE, "Queued absolute point " + steps + " at " + Long.toString(micros) + " usec.");
        }
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        pb.add32((int)micros);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_POSITION.getCode());
        Point5d steps = this.machine.mmToSteps(p);
        pb.add32((long)steps.x());
        pb.add32((long)steps.y());
        pb.add32((long)steps.z());
        Base.logger.log(Level.FINE, "Set current position to " + p + " (" + steps + ")");
        this.runCommand(pb.getPacket());
        this.currentPosition.set(p);
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
        Base.logger.log(Level.FINE, "Homing axes " + axes.toString());
        int flags = 0;
        this.invalidatePosition();
        Point5d maxFeedrates = this.machine.getMaximumFeedrates();
        if (feedrate <= 0.0) {
            feedrate = 0.0;
            for (AxisId axis : this.machine.getAvailableAxes()) {
                feedrate = Math.max(maxFeedrates.axis(axis), feedrate);
            }
        }
        Point5d target = new Point5d();
        for (AxisId axis : axes) {
            flags = (byte)(flags + (1 << axis.getIndex()));
            feedrate = Math.min(feedrate, maxFeedrates.axis(axis));
            target.setAxis(axis, 1.0);
        }
        long micros = this.convertFeedrateToMicros(new Point5d(), target, feedrate);
        int code = positive ? MotherboardCommandCode.FIND_AXES_MAXIMUM.getCode() : MotherboardCommandCode.FIND_AXES_MINIMUM.getCode();
        PacketBuilder pb = new PacketBuilder(code);
        pb.add8(flags);
        pb.add32((int)micros);
        pb.add16(20);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void delay(long millis) throws RetryException {
        if (Base.logger.isLoggable(Level.FINER)) {
            Base.logger.log(Level.FINER, "Delaying " + millis + " millis.");
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.DELAY.getCode());
        pb.add32(millis);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void openClamp(int clampIndex) {
        super.openClamp(clampIndex);
    }

    @Override
    public void closeClamp(int clampIndex) {
        super.closeClamp(clampIndex);
    }

    @Override
    public void enableDrives() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(159);
        this.runCommand(pb.getPacket());
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.ENABLE_AXES.getCode());
        pb.add8(31);
        this.runCommand(pb.getPacket());
        super.disableDrives();
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        super.changeGearRatio(ratioIndex);
    }

    @Override
    public void requestToolChange(int toolIndex, int timeout) throws RetryException {
        PacketBuilder pb;
        this.selectTool(toolIndex);
        Base.logger.log(Level.FINE, "Waiting for tool #" + toolIndex);
        if (this.machine.currentTool().getTargetTemperature() > 0.0) {
            pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_TOOL.getCode());
            pb.add8((byte)toolIndex);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
        if (this.machine.getTool(toolIndex).hasHeatedPlatform() && this.machine.currentTool().getPlatformTargetTemperature() > 0.0) {
            pb = new PacketBuilder(MotherboardCommandCode.WAIT_FOR_PLATFORM.getCode());
            pb.add8((byte)toolIndex);
            pb.add16(100);
            pb.add16(timeout);
            this.runCommand(pb.getPacket());
        }
    }

    @Override
    public void selectTool(int toolIndex) throws RetryException {
        Base.logger.log(Level.FINE, "Selecting tool #" + toolIndex);
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.CHANGE_TOOL.getCode());
        pb.add8((byte)toolIndex);
        this.runCommand(pb.getPacket());
        super.selectTool(toolIndex);
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        long microseconds = rpm == 0.0 ? 0L : Math.round(6.0E7 / rpm);
        Base.logger.log(Level.FINE, "Setting motor 1 speed to " + rpm + " RPM (" + microseconds + " microseconds)");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_1_RPM.getCode());
        pb.add8(4);
        pb.add32(microseconds);
        this.runCommand(pb.getPacket());
        super.setMotorRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        if (this.machine.currentTool().getMotorUsesRelay() && pwm > 0) {
            Base.logger.log(Level.FINE, "Tool motor uses relay, overriding PWM setting");
            pwm = 255;
        }
        Base.logger.log(Level.FINE, "Setting motor 1 speed to " + pwm + " PWM");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_1_PWM.getCode());
        pb.add8(1);
        pb.add8((byte)(pwm > 255 ? 255 : pwm));
        this.runCommand(pb.getPacket());
        super.setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableMotor() throws RetryException {
        int flags = 1;
        if (this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.log(Level.FINE, "Toggling motor 1 w/ flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        int flags = 0;
        if (this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.log(Level.FINE, "Disabling motor 1");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.disableMotor();
    }

    @Override
    public int getMotorSpeedPWM() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_MOTOR_1_PWM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        int pwm = pr.get8();
        Base.logger.log(Level.FINE, "Current motor 1 PWM: " + pwm);
        this.machine.currentTool().setMotorSpeedReadingPWM(pwm);
        return pwm;
    }

    @Override
    public double getMotorRPM() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_MOTOR_1_RPM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        long micros = pr.get32();
        double rpm = 0.0;
        if (micros > 0L) {
            rpm = 6.0E7 / (double)micros;
        }
        Base.logger.log(Level.FINE, "Current motor 1 RPM: " + rpm + " (" + micros + ")");
        this.machine.currentTool().setMotorSpeedReadingRPM(rpm);
        return rpm;
    }

    @Override
    public void readToolStatus() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_TOOL_STATUS.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isEmpty()) {
            return;
        }
        int status = pr.get8();
        this.machine.currentTool().setToolStatus(status);
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.log(Level.FINE, "Extruder Status: " + status + ": " + ((status & 0x80) != 0 ? "EXTRUDER_ERROR " : "") + ((status & 0x40) != 0 ? "PLATFORM_ERROR " : "") + ((status & 0x20) != 0 ? "WDRF " : "") + ((status & 0x10) != 0 ? "BORF " : "") + ((status & 8) != 0 ? "EXTRF " : "") + ((status & 4) != 0 ? "PORF " : "") + ((status & 1) != 0 ? "READY" : "NOT READY") + " ");
        }
        this.readToolPIDState();
    }

    private int fixSigned(int value) {
        if (value >= 32768) {
            value -= 65536;
        }
        return value;
    }

    public void readToolPIDState() {
        if (Base.logger.isLoggable(Level.FINE)) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)this.machine.currentTool().getIndex());
            pb.add8(ToolCommandCode.GET_PID_STATE.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            if (pr.isEmpty()) {
                return;
            }
            int extruderErrorTerm = this.fixSigned(pr.get16());
            int extruderDeltaTerm = this.fixSigned(pr.get16());
            int extruderLastOutput = this.fixSigned(pr.get16());
            int platformErrorTerm = this.fixSigned(pr.get16());
            int platformDeltaTerm = this.fixSigned(pr.get16());
            int platformLastOutput = this.fixSigned(pr.get16());
            Base.logger.log(Level.FINE, "Extuder PID State:  error: " + extruderErrorTerm + "  delta: " + extruderDeltaTerm + "  output: " + extruderLastOutput);
            Base.logger.log(Level.FINE, "Platform PID State:  error: " + platformErrorTerm + "  delta: " + platformDeltaTerm + "  output: " + platformLastOutput);
        }
    }

    @Override
    public void setServoPos(int index, double degree) throws RetryException {
        int command = 0;
        if (index == 0) {
            command = ToolCommandCode.SET_SERVO_1_POS.getCode();
        } else if (index == 1) {
            command = ToolCommandCode.SET_SERVO_2_POS.getCode();
        } else {
            Base.logger.log(Level.SEVERE, "Servo index " + index + " not supported, ignoring");
            return;
        }
        if (degree != 255.0) {
            if (degree < 0.0) {
                degree = 0.0;
            } else if (degree > 180.0) {
                degree = 180.0;
            }
        }
        Base.logger.log(Level.FINE, "Setting servo " + index + " position to " + degree + " degrees");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(command);
        pb.add8(1);
        pb.add8((byte)degree);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        long microseconds = (int)Math.round(6.0E7 / rpm);
        microseconds = Math.min(microseconds, 29L);
        Base.logger.log(Level.FINE, "Setting motor 2 speed to " + rpm + " RPM (" + microseconds + " microseconds)");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_2_RPM.getCode());
        pb.add8(4);
        pb.add32(microseconds);
        this.runCommand(pb.getPacket());
        super.setSpindleRPM(rpm);
    }

    @Override
    public void setSpindleSpeedPWM(int pwm) throws RetryException {
        Base.logger.log(Level.FINE, "Setting motor 2 speed to " + pwm + " PWM");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_2_PWM.getCode());
        pb.add8(1);
        pb.add8((byte)pwm);
        this.runCommand(pb.getPacket());
        super.setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        int flags = 1;
        if (this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.log(Level.FINE, "Toggling motor 2 w/ flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_2.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        int flags = 0;
        if (this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE) {
            flags = (byte)(flags + 2);
        }
        Base.logger.log(Level.FINE, "Disabling motor 2");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_2.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        super.disableSpindle();
    }

    public double getSpindleSpeedRPM() throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_MOTOR_2_RPM.getCode());
        PacketResponse pr = this.runCommand(pb.getPacket());
        long micros = pr.get32();
        double rpm = 6.0E7 / (double)micros;
        Base.logger.log(Level.FINE, "Current motor 2 RPM: " + rpm + " (" + micros + ")");
        this.machine.currentTool().setSpindleSpeedReadingRPM(rpm);
        return rpm;
    }

    @Override
    public int getSpindleSpeedPWM() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_MOTOR_2_PWM.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        int pwm = pr.get8();
        Base.logger.log(Level.FINE, "Current motor 1 PWM: " + pwm);
        this.machine.currentTool().setSpindleSpeedReadingPWM(pwm);
        return pwm;
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        int temp = (int)Math.round(temperature);
        temp = Math.min(temp, 65535);
        Base.logger.log(Level.FINE, "Setting temperature to " + temp + "C");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_TEMP.getCode());
        pb.add8(2);
        pb.add16(temp);
        this.runCommand(pb.getPacket());
        super.setTemperature(temperature);
    }

    @Override
    public void readTemperature() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_TEMP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isEmpty()) {
            return;
        }
        int temp = pr.get16();
        this.machine.currentTool().setCurrentTemperature(temp);
        Base.logger.log(Level.FINE, "Current temperature: " + this.machine.currentTool().getCurrentTemperature() + "C");
        super.readTemperature();
    }

    @Override
    public void setPlatformTemperature(double temperature) throws RetryException {
        int temp = (int)Math.round(temperature);
        temp = Math.min(temp, 65535);
        Base.logger.log(Level.FINE, "Setting platform temperature to " + temp + "C");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_PLATFORM_TEMP.getCode());
        pb.add8(2);
        pb.add16(temp);
        this.runCommand(pb.getPacket());
        super.setPlatformTemperature(temperature);
    }

    @Override
    public void readPlatformTemperature() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.GET_PLATFORM_TEMP.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isEmpty()) {
            return;
        }
        int temp = pr.get16();
        this.machine.currentTool().setPlatformCurrentTemperature(temp);
        Base.logger.log(Level.FINE, "Current platform temperature: " + this.machine.currentTool().getPlatformCurrentTemperature() + "C");
        super.readPlatformTemperature();
    }

    @Override
    public void enableFloodCoolant() {
        super.enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        super.disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        super.enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        super.disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        Base.logger.log(Level.FINE, "Enabling fan");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        int idx = this.machine.currentTool().getIndex();
        pb.add8((byte)idx);
        Base.logger.log(Level.FINE, "Tool index " + Integer.toString(idx));
        pb.add8(ToolCommandCode.TOGGLE_FAN.getCode());
        pb.add8(1);
        pb.add8(1);
        this.runCommand(pb.getPacket());
        super.enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        Base.logger.log(Level.FINE, "Disabling fan");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_FAN.getCode());
        pb.add8(1);
        pb.add8(0);
        this.runCommand(pb.getPacket());
        super.disableFan();
    }

    @Override
    public void openValve() throws RetryException {
        Base.logger.log(Level.FINE, "Opening valve");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_VALVE.getCode());
        pb.add8(1);
        pb.add8(1);
        this.runCommand(pb.getPacket());
        super.openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        Base.logger.log(Level.FINE, "Closing valve");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_VALVE.getCode());
        pb.add8(1);
        pb.add8(0);
        this.runCommand(pb.getPacket());
        super.closeValve();
    }

    @Override
    public void openCollet() {
        super.openCollet();
    }

    @Override
    public void closeCollet() {
        super.closeCollet();
    }

    @Override
    public void pause() {
        Base.logger.log(Level.FINE, "Sending asynch pause command");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE.getCode());
        this.runQuery(pb.getPacket());
    }

    @Override
    public void unpause() {
        Base.logger.log(Level.FINE, "Sending asynch unpause command");
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PAUSE.getCode());
        this.runQuery(pb.getPacket());
    }

    private Point5d getAbsDeltaDistance(Point5d current, Point5d target) {
        Point5d delta = new Point5d();
        delta.sub(target, current);
        delta.absolute();
        return delta;
    }

    protected Point5d getAbsDeltaSteps(Point5d current, Point5d target) {
        return this.machine.mmToSteps(this.getAbsDeltaDistance(current, target));
    }

    protected long convertFeedrateToMicros(Point5d current, Point5d target, double feedrate) {
        Point5d deltaDistance = this.getAbsDeltaDistance(current, target);
        Point5d deltaSteps = this.machine.mmToSteps(deltaDistance);
        double masterSteps = this.getLongestLength(deltaSteps);
        double distance = deltaDistance.magnitude();
        double micros = distance / feedrate * 6.0E7;
        double step_delay = micros / masterSteps;
        return Math.round(step_delay);
    }

    protected double getLongestLength(Point5d p) {
        double longest = 0.0;
        for (int i = 0; i < 5; ++i) {
            longest = Math.max(longest, p.get(i));
        }
        return longest;
    }

    @Override
    public String getDriverName() {
        return "Sanguino3G";
    }

    @Override
    public void stop(boolean abort) {
        PacketBuilder pb;
        Base.logger.fine("Stop.");
        if (!abort && this.version.atLeast(this.extendedStopVersion)) {
            pb = new PacketBuilder(MotherboardCommandCode.EXTENDED_STOP.getCode());
            pb.add8(3);
        } else {
            pb = new PacketBuilder(MotherboardCommandCode.ABORT.getCode());
        }
        Thread.interrupted();
        this.runQuery(pb.getPacket());
        this.invalidatePosition();
    }

    @Override
    protected Point5d reconcilePosition() {
        if (this.fileCaptureOstream != null) {
            return new Point5d();
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.GET_POSITION.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        Point5d steps = new Point5d(pr.get32(), pr.get32(), pr.get32(), 0.0, 0.0);
        return this.machine.stepsToMM(steps);
    }

    @Override
    public void reset() {
        Base.logger.info("Reset.");
        if (this.isInitialized() && this.version.compareTo(new Version(1, 4)) >= 0) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.RESET.getCode());
            Thread.interrupted();
            this.runQuery(pb.getPacket());
            this.invalidatePosition();
        }
        this.setInitialized(false);
        this.initialize();
    }

    private void checkEEPROM() {
        if (!this.eepromChecked) {
            this.eepromChecked = true;
            if (this.version.getMajor() < 2) {
                byte[] versionBytes = this.readFromEEPROM(0, 2);
                if (versionBytes == null || versionBytes.length < 2) {
                    return;
                }
                if (versionBytes[0] != 90 || versionBytes[1] != 120) {
                    Base.logger.severe("Cleaning EEPROM to v1.X state");
                    byte[] eepromWipe = new byte[16];
                    Arrays.fill(eepromWipe, (byte)0);
                    eepromWipe[0] = 90;
                    eepromWipe[1] = 120;
                    this.writeToEEPROM(0, eepromWipe);
                    Arrays.fill(eepromWipe, (byte)0);
                    for (int i = 16; i < 256; i += 16) {
                        this.writeToEEPROM(i, eepromWipe);
                    }
                }
            }
        }
    }

    private void writeToEEPROM(int offset, byte[] data) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.WRITE_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(data.length);
        for (byte b : data) {
            pb.add8(b);
        }
        PacketResponse pr = this.runQuery(pb.getPacket());
        assert (pr.get8() == data.length);
    }

    private byte[] readFromToolEEPROM(int offset, int len) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.READ_FROM_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(len);
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            int rvlen = Math.min(pr.getPayload().length - 1, len);
            byte[] rv = new byte[rvlen];
            System.arraycopy(pr.getPayload(), 1, rv, 0, rvlen);
            return rv;
        }
        Base.logger.severe("On tool read: " + pr.getResponseCode().getMessage());
        return null;
    }

    private void writeToToolEEPROM(int offset, byte[] data) {
        this.writeToToolEEPROM(offset, data, this.machine.currentTool().getIndex());
    }

    private void writeToToolEEPROM(int offset, byte[] data, int toolIndex) {
        int MAX_PAYLOAD = 11;
        while (data.length > 11) {
            byte[] head = new byte[11];
            byte[] tail = new byte[data.length - 11];
            System.arraycopy(data, 0, head, 0, 11);
            System.arraycopy(data, 11, tail, 0, data.length - 11);
            this.writeToToolEEPROM(offset, head, toolIndex);
            offset += 11;
            data = tail;
        }
        PacketBuilder slavepb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
        slavepb.add8((byte)toolIndex);
        slavepb.add8(ToolCommandCode.WRITE_TO_EEPROM.getCode());
        slavepb.add16(offset);
        slavepb.add8(data.length);
        for (byte b : data) {
            slavepb.add8(b);
        }
        PacketResponse slavepr = this.runQuery(slavepb.getPacket());
        slavepr.printDebug();
        assert (slavepr.get8() == data.length);
    }

    private byte[] readFromEEPROM(int offset, int len) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.READ_EEPROM.getCode());
        pb.add16(offset);
        pb.add8(len);
        PacketResponse pr = this.runQuery(pb.getPacket());
        if (pr.isOK()) {
            int rvlen = Math.min(pr.getPayload().length - 1, len);
            byte[] rv = new byte[rvlen];
            System.arraycopy(pr.getPayload(), 1, rv, 0, rvlen);
            return rv;
        }
        return null;
    }

    @Override
    public EnumSet<AxisId> getInvertedParameters() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(2, 1);
        EnumSet<AxisId> r = EnumSet.noneOf(AxisId.class);
        if ((b[0] & 1) != 0) {
            r.add(AxisId.X);
        }
        if ((b[0] & 2) != 0) {
            r.add(AxisId.Y);
        }
        if ((b[0] & 4) != 0) {
            r.add(AxisId.Z);
        }
        if ((b[0] & 8) != 0) {
            r.add(AxisId.A);
        }
        if ((b[0] & 0x10) != 0) {
            r.add(AxisId.B);
        }
        return r;
    }

    @Override
    public void setInvertedParameters(EnumSet<AxisId> axes) {
        byte[] b = new byte[1];
        if (axes.contains((Object)AxisId.X)) {
            b[0] = (byte)(b[0] | 1);
        }
        if (axes.contains((Object)AxisId.Y)) {
            b[0] = (byte)(b[0] | 2);
        }
        if (axes.contains((Object)AxisId.Z)) {
            b[0] = (byte)(b[0] | 4);
        }
        if (axes.contains((Object)AxisId.A)) {
            b[0] = (byte)(b[0] | 8);
        }
        if (axes.contains((Object)AxisId.B)) {
            b[0] = (byte)(b[0] | 0x10);
        }
        this.writeToEEPROM(2, b);
    }

    @Override
    public String getMachineName() {
        this.checkEEPROM();
        byte[] data = this.readFromEEPROM(32, 16);
        if (data == null) {
            return new String();
        }
        try {
            int len;
            for (len = 0; len < 16 && data[len] != 0; ++len) {
            }
            return new String(data, 0, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setMachineName(String machineName) {
        if ((machineName = new String(machineName)).length() > 16) {
            machineName = machineName.substring(0, 16);
        }
        byte[] b = new byte[16];
        int idx = 0;
        for (byte sb : machineName.getBytes()) {
            b[idx++] = sb;
            if (idx == 16) break;
        }
        if (idx < 16) {
            b[idx] = 0;
        }
        this.writeToEEPROM(32, b);
    }

    @Override
    public boolean hasFeatureOnboardParameters() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.version.compareTo(new Version(1, 2)) >= 0;
    }

    @Override
    public void createThermistorTable(int which, double r0, double t0, double beta) {
        int ADC_RANGE = 1024;
        int NUMTEMPS = 20;
        byte[] table = new byte[80];
        class ThermistorConverter {
            final double ZERO_C_IN_KELVIN = 273.15;
            public double vadc;
            public double rs;
            public double vs;
            public double k;
            public double beta;

            public ThermistorConverter(double r0, double t0C, double beta, double r2) {
                this.beta = beta;
                this.vadc = 5.0;
                this.vs = 5.0;
                double t0K = 273.15 + t0C;
                this.k = r0 * Math.exp(-beta / t0K);
                this.rs = r2;
            }

            public double temp(double adc) {
                double v = adc * this.vadc / 1024.0;
                double r = this.rs * v / (this.vs - v);
                return this.beta / Math.log(r / this.k) - 273.15;
            }
        }
        ThermistorConverter tc = new ThermistorConverter(r0, t0, beta, 4700.0);
        double adc = 1.0;
        for (int i = 0; i < 20; ++i) {
            double temp = tc.temp(adc);
            int tempi = (int)temp;
            int adci = (int)adc;
            Base.logger.fine("{ " + Integer.toString(adci) + "," + Integer.toString(tempi) + " }");
            table[4 * i + 0] = (byte)(adci & 0xFF);
            table[4 * i + 1] = (byte)(adci >> 8);
            table[4 * i + 2] = (byte)(tempi & 0xFF);
            table[4 * i + 3] = (byte)(tempi >> 8);
            adc += 53.0;
        }
        byte[] eepromIndicator = new byte[]{90, 120};
        this.writeToToolEEPROM(0, eepromIndicator);
        this.writeToToolEEPROM(ECThermistorOffsets.beta(which), this.intToLE((int)beta));
        this.writeToToolEEPROM(ECThermistorOffsets.r0(which), this.intToLE((int)r0));
        this.writeToToolEEPROM(ECThermistorOffsets.t0(which), this.intToLE((int)t0));
        this.writeToToolEEPROM(ECThermistorOffsets.data(which), table);
    }

    private byte[] intToLE(int s, int sz) {
        byte[] buf = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            buf[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        return buf;
    }

    private byte[] floatToLE(float f) {
        byte[] buf = new byte[2];
        double d = f;
        double intPart = Math.floor(d);
        double fracPart = Math.floor((d - intPart) * 256.0);
        buf[0] = (byte)intPart;
        buf[1] = (byte)fracPart;
        return buf;
    }

    private byte[] intToLE(int s) {
        return this.intToLE(s, 4);
    }

    SDCardCapture.ResponseCode convertSDCode(int code) {
        switch (code) {
            case 0: {
                return SDCardCapture.ResponseCode.SUCCESS;
            }
            case 1: {
                return SDCardCapture.ResponseCode.FAIL_NO_CARD;
            }
            case 2: {
                return SDCardCapture.ResponseCode.FAIL_INIT;
            }
            case 3: {
                return SDCardCapture.ResponseCode.FAIL_PARTITION;
            }
            case 4: {
                return SDCardCapture.ResponseCode.FAIL_FS;
            }
            case 5: {
                return SDCardCapture.ResponseCode.FAIL_ROOT_DIR;
            }
            case 6: {
                return SDCardCapture.ResponseCode.FAIL_LOCKED;
            }
            case 7: {
                return SDCardCapture.ResponseCode.FAIL_NO_FILE;
            }
        }
        return SDCardCapture.ResponseCode.FAIL_GENERIC;
    }

    @Override
    public void beginFileCapture(String path) throws FileNotFoundException {
        this.fileCaptureOstream = new FileOutputStream(new File(path));
    }

    @Override
    public void endFileCapture() throws IOException {
        this.fileCaptureOstream.close();
        this.fileCaptureOstream = null;
    }

    @Override
    public SDCardCapture.ResponseCode beginCapture(String filename) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.CAPTURE_TO_FILE.getCode());
        for (byte b : filename.getBytes()) {
            pb.add8(b);
        }
        pb.add8(0);
        PacketResponse pr = this.runQuery(pb.getPacket());
        return this.convertSDCode(pr.get8());
    }

    @Override
    public int endCapture() {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.END_CAPTURE.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        return pr.get32();
    }

    @Override
    public SDCardCapture.ResponseCode playback(String filename) {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.PLAYBACK_CAPTURE.getCode());
        for (byte b : filename.getBytes()) {
            pb.add8(b);
        }
        pb.add8(0);
        PacketResponse pr = this.runQuery(pb.getPacket());
        return this.convertSDCode(pr.get8());
    }

    @Override
    public boolean hasFeatureSDCardCapture() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.version.compareTo(new Version(1, 3)) >= 0;
    }

    @Override
    public List<String> getFileList() {
        Vector<String> fileList = new Vector<String>();
        boolean reset = true;
        while (true) {
            char c;
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.NEXT_FILENAME.getCode());
            pb.add8(reset ? 1 : 0);
            reset = false;
            PacketResponse pr = this.runQuery(pb.getPacket());
            SDCardCapture.ResponseCode rc = this.convertSDCode(pr.get8());
            if (rc != SDCardCapture.ResponseCode.SUCCESS) {
                return fileList;
            }
            StringBuffer s = new StringBuffer();
            while ((c = (char)pr.get8()) != '\u0000') {
                s.append(c);
            }
            if (s.length() == 0) break;
            fileList.add(s.toString());
        }
        return fileList;
    }

    @Override
    public int getBeta(int which) {
        byte[] r = this.readFromToolEEPROM(ECThermistorOffsets.beta(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public int getR0(int which) {
        byte[] r = this.readFromToolEEPROM(ECThermistorOffsets.r0(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    @Override
    public int getT0(int which) {
        byte[] r = this.readFromToolEEPROM(ECThermistorOffsets.t0(which), 4);
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (r[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    private int read16FromToolEEPROM(int offset, int defaultValue) {
        byte[] r = this.readFromToolEEPROM(offset, 2);
        int val = r[0] & 0xFF;
        if ((val += (r[1] & 0xFF) << 8) == 65535) {
            return defaultValue;
        }
        return val;
    }

    private int byteToInt(byte b) {
        return b & 0xFF;
    }

    private float readFloat16FromToolEEPROM(int offset, float defaultValue) {
        byte[] r = this.readFromToolEEPROM(offset, 2);
        if (r[0] == -1 && r[1] == -1) {
            return defaultValue;
        }
        return (float)this.byteToInt(r[0]) + (float)this.byteToInt(r[1]) / 256.0f;
    }

    @Override
    public OnboardParameters.BackoffParameters getBackoffParameters() {
        OnboardParameters.BackoffParameters bp = new OnboardParameters.BackoffParameters();
        bp.forwardMs = this.read16FromToolEEPROM(8, 300);
        bp.stopMs = this.read16FromToolEEPROM(4, 5);
        bp.reverseMs = this.read16FromToolEEPROM(6, 500);
        bp.triggerMs = this.read16FromToolEEPROM(10, 300);
        return bp;
    }

    @Override
    public void setBackoffParameters(OnboardParameters.BackoffParameters bp) {
        this.writeToToolEEPROM(8, this.intToLE(bp.forwardMs, 2));
        this.writeToToolEEPROM(4, this.intToLE(bp.stopMs, 2));
        this.writeToToolEEPROM(6, this.intToLE(bp.reverseMs, 2));
        this.writeToToolEEPROM(10, this.intToLE(bp.triggerMs, 2));
    }

    @Override
    public OnboardParameters.PIDParameters getPIDParameters(int which) {
        OnboardParameters.PIDParameters pp = new OnboardParameters.PIDParameters();
        int offset = which == 0 ? 12 : 18;
        pp.p = this.readFloat16FromToolEEPROM(offset + 0, 7.0f);
        pp.i = this.readFloat16FromToolEEPROM(offset + 2, 0.325f);
        pp.d = this.readFloat16FromToolEEPROM(offset + 4, 36.0f);
        return pp;
    }

    @Override
    public void setPIDParameters(int which, OnboardParameters.PIDParameters pp) {
        int offset = which == 0 ? 12 : 18;
        this.writeToToolEEPROM(offset + 0, this.floatToLE(pp.p));
        this.writeToToolEEPROM(offset + 2, this.floatToLE(pp.i));
        this.writeToToolEEPROM(offset + 4, this.floatToLE(pp.d));
    }

    @Override
    public void resetToFactory() {
        byte[] eepromWipe = new byte[16];
        Arrays.fill(eepromWipe, (byte)-1);
        for (int i = 0; i < 512; i += 16) {
            this.writeToEEPROM(i, eepromWipe);
        }
    }

    @Override
    public void resetToolToFactory() {
        byte[] eepromWipe = new byte[16];
        Arrays.fill(eepromWipe, (byte)-1);
        for (int i = 0; i < 512; i += 16) {
            this.writeToToolEEPROM(i, eepromWipe);
        }
    }

    @Override
    public OnboardParameters.EndstopType getInvertedEndstops() {
        this.checkEEPROM();
        byte[] b = this.readFromEEPROM(3, 1);
        return OnboardParameters.EndstopType.endstopTypeForValue(b[0]);
    }

    @Override
    public void setInvertedEndstops(OnboardParameters.EndstopType endstops) {
        byte[] b = new byte[]{endstops.getValue()};
        this.writeToEEPROM(3, b);
    }

    @Override
    public OnboardParameters.ExtraFeatures getExtraFeatures() {
        int efdat = this.read16FromToolEEPROM(24, 16516);
        OnboardParameters.ExtraFeatures ef = new OnboardParameters.ExtraFeatures();
        ef.swapMotorController = (efdat & 1) != 0;
        ef.heaterChannel = efdat >> 2 & 3;
        ef.hbpChannel = efdat >> 4 & 3;
        ef.abpChannel = efdat >> 6 & 3;
        return ef;
    }

    @Override
    public void setExtraFeatures(OnboardParameters.ExtraFeatures features) {
        int efdat = 16384;
        if (features.swapMotorController) {
            efdat |= 1;
        }
        efdat |= features.heaterChannel << 2;
        efdat |= features.hbpChannel << 4;
        this.writeToToolEEPROM(24, this.intToLE(efdat |= features.abpChannel << 6, 2));
    }

    @Override
    public double getPlatformTemperatureSetting() {
        if (this.toolVersion.atLeast(new Version(2, 3))) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)this.machine.currentTool().getIndex());
            pb.add8(ToolCommandCode.GET_PLATFORM_SP.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            int sp = pr.get16();
            this.machine.currentTool().setPlatformTargetTemperature(sp);
        }
        return super.getPlatformTemperatureSetting();
    }

    @Override
    public double getTemperatureSetting() {
        if (this.toolVersion.atLeast(new Version(2, 3))) {
            PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_QUERY.getCode());
            pb.add8((byte)this.machine.currentTool().getIndex());
            pb.add8(ToolCommandCode.GET_SP.getCode());
            PacketResponse pr = this.runQuery(pb.getPacket());
            int sp = pr.get16();
            this.machine.currentTool().setTargetTemperature(sp);
        }
        return super.getTemperatureSetting();
    }

    public Version getToolVersion() {
        return this.toolVersion;
    }

    @Override
    public boolean setConnectedToolIndex(int index) {
        byte[] data = new byte[]{(byte)index};
        this.writeToToolEEPROM(26, data, 255);
        return false;
    }

    @Override
    public boolean toolsCanBeReindexed() {
        return true;
    }

    @Override
    public boolean supportsSimultaneousTools() {
        return true;
    }

    static final class PIDOffsets {
        static final int PID_EXTRUDER = 12;
        static final int PID_HBP = 18;
        static final int P_TERM_OFFSET = 0;
        static final int I_TERM_OFFSET = 2;
        static final int D_TERM_OFFSET = 4;

        PIDOffsets() {
        }
    }

    static final class ECBackoffOffsets {
        static final int STOP_MS = 4;
        static final int REVERSE_MS = 6;
        static final int FORWARD_MS = 8;
        static final int TRIGGER_MS = 10;

        ECBackoffOffsets() {
        }
    }

    static final class ECThermistorOffsets {
        private static final int[] TABLE_OFFSETS = new int[]{240, 368};
        private static final int R0 = 0;
        private static final int T0 = 4;
        private static final int BETA = 8;
        private static final int DATA = 16;

        ECThermistorOffsets() {
        }

        public static int r0(int which) {
            return 0 + TABLE_OFFSETS[which];
        }

        public static int t0(int which) {
            return 4 + TABLE_OFFSETS[which];
        }

        public static int beta(int which) {
            return 8 + TABLE_OFFSETS[which];
        }

        public static int data(int which) {
            return 16 + TABLE_OFFSETS[which];
        }
    }
}

