/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.util.EnumMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import org.w3c.dom.Element;
import replicatorg.app.Base;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.gen3.Makerbot4GDriver;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Makerbot4GAlternateDriver
extends Makerbot4GDriver {
    private boolean stepperExtruderFanEnabled = false;
    EnumMap<AxisId, ToolModel> stepExtruderMap = new EnumMap(AxisId.class);

    @Override
    public String getDriverName() {
        return "Makerbot4GAlternate";
    }

    @Override
    public void reset() {
        this.stepperExtruderFanEnabled = false;
        super.reset();
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        Point5d filteredpoint = new Point5d(p);
        Point5d filteredcurrent = new Point5d(this.getCurrentPosition());
        int relative = 0;
        for (AxisId axis : this.getHijackedAxes()) {
            filteredpoint.setAxis(axis, 0.0);
            filteredcurrent.setAxis(axis, 0.0);
            relative |= 1 << axis.getIndex();
        }
        Point5d deltaSteps = this.getAbsDeltaSteps(filteredcurrent, filteredpoint);
        if (deltaSteps.length() > 0.0) {
            Point5d delta = new Point5d();
            delta.sub(filteredpoint, filteredcurrent);
            delta.absolute();
            Point5d axesmovement = this.calcHijackedAxesMovement(delta);
            delta.add(axesmovement);
            filteredpoint.add(axesmovement);
            Point5d steps = this.machine.mmToSteps(filteredpoint);
            double minutes = delta.get3D().distance(new Point3d()) / this.getSafeFeedrate(delta);
            this.queueNewPoint(steps, (long)(6.0E7 * minutes), relative);
            this.setInternalPosition(filteredpoint);
        }
    }

    @Override
    public void delay(long millis) throws RetryException {
        if (Base.logger.isLoggable(Level.FINER)) {
            Base.logger.log(Level.FINER, "Delaying " + millis + " millis.");
        }
        Point5d steps = new Point5d();
        this.modifyHijackedAxes(steps, (double)millis / 60000.0);
        if (steps.length() > 0.0) {
            this.queueNewPoint(steps, millis * 1000L, 31);
        } else {
            super.delay(millis);
        }
    }

    private Iterable<AxisId> getHijackedAxes() {
        Vector<AxisId> axes = new Vector<AxisId>();
        for (Map.Entry<AxisId, ToolModel> entry : this.stepExtruderMap.entrySet()) {
            ToolModel curTool = this.machine.currentTool();
            AxisId axis = entry.getKey();
            if (!curTool.equals(entry.getValue())) continue;
            axes.add(axis);
        }
        return axes;
    }

    private Point5d calcHijackedAxesMovement(Point5d delta) {
        Point5d movement = new Point5d();
        double minutes = delta.length() / this.getCurrentFeedrate();
        for (AxisId axis : this.getHijackedAxes()) {
            ToolModel curTool = this.machine.currentTool();
            if (!curTool.isMotorEnabled()) continue;
            double extruderStepsPerMinute = curTool.getMotorSpeedRPM() * curTool.getMotorSteps();
            boolean clockwise = this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE;
            movement.setAxis(axis, extruderStepsPerMinute * minutes / this.machine.getStepsPerMM().axis(axis) * (clockwise ? -1.0 : 1.0));
        }
        return movement;
    }

    private int modifyHijackedAxes(Point5d steps, double minutes) {
        int relative = 0;
        for (AxisId axis : this.getHijackedAxes()) {
            relative |= 1 << axis.getIndex();
            double extruderSteps = 0.0;
            ToolModel curTool = this.machine.currentTool();
            if (curTool.isMotorEnabled()) {
                double maxrpm = this.machine.getMaximumFeedrates().axis(axis) * this.machine.getStepsPerMM().axis(axis) / curTool.getMotorSteps();
                double rpm = curTool.getMotorSpeedRPM() > maxrpm ? maxrpm : curTool.getMotorSpeedRPM();
                boolean clockwise = this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE;
                extruderSteps = rpm * curTool.getMotorSteps() * minutes * (clockwise ? -1.0 : 1.0);
            }
            steps.setAxis(axis, extruderSteps);
        }
        return relative;
    }

    @Override
    public void stop(boolean abort) {
        this.machine.currentTool().disableMotor();
        this.stepperExtruderFanEnabled = false;
        super.stop(abort);
    }

    protected void queueNewPoint(Point5d steps, long us, int relative) throws RetryException {
        for (AxisId axis : this.getHijackedAxes()) {
            if (steps.axis(axis) == 0.0) continue;
            this.enableStepperExtruderFan(true);
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_POINT_NEW.getCode());
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.log(Level.FINE, "Queued new-style point " + steps + " over " + Long.toString(us) + " usec., relative " + Integer.toString(relative));
        }
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        pb.add32((int)steps.a());
        pb.add32((int)steps.b());
        pb.add32((int)us);
        pb.add8(relative);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void enableMotor() throws RetryException {
        this.machine.currentTool().enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.machine.currentTool().disableMotor();
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setMotorSpeedPWM(pwm);
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.machine.currentTool().setMotorSpeedRPM(rpm);
    }

    @Override
    public void enableDrives() throws RetryException {
        this.enableStepperExtruderFan(true);
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.enableStepperExtruderFan(false);
        super.disableDrives();
    }

    public void enableStepperExtruderFan(boolean enabled) throws RetryException {
        if (this.stepperExtruderFanEnabled == enabled) {
            return;
        }
        byte flags = (byte)(enabled ? 1 : 0);
        flags = (byte)(flags | 2);
        Base.logger.log(Level.FINE, "Stepper Extruder fan w/flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_1_PWM.getCode());
        pb.add8(1);
        pb.add8(-1);
        this.runCommand(pb.getPacket());
        this.stepperExtruderFanEnabled = enabled;
    }

    @Override
    public void setMachine(MachineModel m) {
        super.setMachine(m);
        for (ToolModel tm : m.getTools()) {
            Element e = (Element)tm.getXml();
            if (!e.hasAttribute("stepper_axis")) continue;
            String stepAxisStr = e.getAttribute("stepper_axis");
            try {
                AxisId axis = AxisId.valueOf(stepAxisStr.toUpperCase());
                if (m.hasAxis(axis)) {
                    this.stepExtruderMap.put(axis, tm);
                    m.getAvailableAxes().remove((Object)axis);
                    continue;
                }
                Base.logger.severe("Tool claims unavailable axis " + axis.name());
            }
            catch (IllegalArgumentException iae) {
                Base.logger.severe("Unintelligible axis designator " + stepAxisStr);
            }
        }
    }

    @Override
    public double getMotorRPM() {
        double rpm = this.machine.currentTool().getMotorSpeedRPM();
        this.machine.currentTool().setMotorSpeedReadingRPM(rpm);
        return rpm;
    }
}

