/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import org.w3c.dom.Node;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.app.tools.XML;
import replicatorg.drivers.DriverBaseImplementation;
import replicatorg.drivers.RetryException;

public class NullDriver
extends DriverBaseImplementation {
    private double speedup = 10.0;

    public void loadXML(Node xml) {
        super.loadXML(xml);
        if (XML.hasChildNode(xml, "speedup")) {
            this.speedup = Double.parseDouble(XML.getChildNodeValue(xml, "speedup"));
        }
    }

    public void execute() throws InterruptedException {
        int millis;
        try {
            super.execute();
        }
        catch (GCodeException e) {
        }
        catch (RetryException e) {
            // empty catch block
        }
        String command = this.getParser().getCommand();
        if (command.length() > 0 && this.speedup > 0.0 && (millis = (int)Math.round(this.getMoveLength() / this.getCurrentFeedrate() * 60000.0 / this.speedup)) > 0) {
            Thread.sleep(millis);
        }
    }
}

