/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.GCodeParser;
import replicatorg.app.exceptions.BuildFailureException;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.drivers.Driver;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverBaseImplementation
implements Driver {
    private GCodeParser parser;
    protected MachineModel machine;
    private String firmwareName = "Unknown";
    protected Version version = new Version(0, 0);
    protected Version preferredVersion = new Version(0, 0);
    protected Version minimumVersion = new Version(0, 0);
    private Point3d[] offsets;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private double moveLength = 0.0;
    private String error = "";
    private double currentFeedrate;
    protected int positioningMode = 0;
    public static int ABSOLUTE = 0;
    public static int INCREMENTAL = 1;
    protected final AtomicReference<Point5d> currentPosition = new AtomicReference<Object>(null);

    public DriverBaseImplementation() {
        this.parser = new GCodeParser();
        this.offsets = new Point3d[7];
        for (int i = 0; i < 7; ++i) {
            this.offsets[i] = new Point3d();
        }
        this.parser.init(this);
        this.machine = new MachineModel();
    }

    @Override
    public void loadXML(Node xml) {
    }

    @Override
    public void updateManualControl() throws InterruptedException {
    }

    @Override
    public void dispose() {
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.fine("Disposing of driver " + this.getDriverName());
        }
        this.parser = null;
    }

    @Override
    public void initialize() {
        this.setInitialized(true);
    }

    @Override
    public void uninitialize() {
        this.setInitialized(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialized(boolean status) {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            this.isInitialized.set(status);
            if (!status) {
                this.invalidatePosition();
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    protected void setError(String e) {
        this.error = e;
    }

    @Override
    public void checkErrors() throws BuildFailureException {
        if (this.error.length() > 0) {
            throw new BuildFailureException(this.error);
        }
    }

    @Override
    public void parse(String cmd) {
        this.moveLength = 0.0;
        this.parser.parse(cmd);
    }

    @Override
    public GCodeParser getParser() {
        return this.parser;
    }

    @Override
    public void execute() throws GCodeException, InterruptedException, RetryException {
        assert (this.parser != null);
        this.parser.execute();
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public boolean isBufferEmpty() {
        return true;
    }

    @Override
    public void waitUntilBufferEmpty() {
        while (!this.isBufferEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getFirmwareInfo() {
        return this.firmwareName + " v" + this.getVersion();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    @Override
    public Version getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public Point3d getOffset(int i) {
        return this.offsets[i];
    }

    @Override
    public void setOffsetX(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].x = j;
    }

    @Override
    public void setOffsetY(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].y = j;
    }

    @Override
    public void setOffsetZ(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].z = j;
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.currentPosition.set(p);
    }

    @Override
    public void invalidatePosition() {
        this.currentPosition.set(null);
    }

    protected Point5d reconcilePosition() {
        throw new RuntimeException("Position reconcilliation requested, but not implemented for this driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point5d getCurrentPosition() {
        AtomicReference<Point5d> atomicReference = this.currentPosition;
        synchronized (atomicReference) {
            if (this.currentPosition.get() == null) {
                this.currentPosition.compareAndSet(null, this.reconcilePosition());
            }
            return new Point5d(this.currentPosition.get());
        }
    }

    @Override
    public Point5d getPosition() {
        return this.getCurrentPosition();
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        Point5d delta = this.getDelta(p);
        this.moveLength += delta.get3D().distance(new Point3d());
        double feedrate = this.getSafeFeedrate(delta);
        this.queuePoint(p, feedrate);
        this.setInternalPosition(p);
    }

    protected void setInternalPosition(Point5d position) {
        this.currentPosition.set(position);
    }

    protected void queuePoint(Point5d p, Double feedrate) {
    }

    public double getMoveLength() {
        return this.moveLength;
    }

    @Override
    public void setFeedrate(double feed) {
        this.currentFeedrate = feed;
    }

    @Override
    public double getCurrentFeedrate() {
        return this.currentFeedrate;
    }

    public double getSafeFeedrate(Point5d delta) {
        double feedrate = this.getCurrentFeedrate();
        Point5d maxFeedrates = this.machine.getMaximumFeedrates();
        if (feedrate == 0.0) {
            for (int i = 0; i < 5; ++i) {
                feedrate = Math.max(feedrate, maxFeedrates.get(i));
            }
            Base.logger.warning("Zero feedrate detected, reset to: " + feedrate);
        }
        double length = delta.length();
        for (int i = 0; i < 5; ++i) {
            if (delta.get(i) == 0.0 || !(feedrate * delta.get(i) / length > maxFeedrates.get(i))) continue;
            feedrate = maxFeedrates.get(i) * length / delta.get(i);
        }
        return feedrate;
    }

    public Point5d getDelta(Point5d p) {
        Point5d delta = new Point5d();
        Point5d current = this.getCurrentPosition();
        delta.sub(p, current);
        delta.absolute();
        return delta;
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
    }

    @Override
    public MachineModel getMachine() {
        return this.machine;
    }

    @Override
    public void setMachine(MachineModel m) {
        this.machine = m;
    }

    @Override
    public void requestToolChange(int toolIndex, int timeout) throws RetryException {
        this.machine.selectTool(toolIndex);
    }

    @Override
    public void selectTool(int toolIndex) throws RetryException {
        this.machine.selectTool(toolIndex);
    }

    @Override
    public void delay(long millis) throws RetryException {
    }

    @Override
    public void openClamp(int index) {
        this.machine.getClamp(index).open();
    }

    @Override
    public void closeClamp(int index) {
        this.machine.getClamp(index).close();
    }

    @Override
    public void enableDrives() throws RetryException {
        this.machine.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.machine.disableDrives();
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        this.machine.changeGearRatio(ratioIndex);
    }

    @Override
    public void setMotorDirection(int dir) {
        this.machine.currentTool().setMotorDirection(dir);
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.machine.currentTool().setMotorSpeedRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableMotor() throws RetryException {
        this.machine.currentTool().enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.machine.currentTool().disableMotor();
    }

    @Override
    public double getMotorRPM() {
        return this.machine.currentTool().getMotorSpeedReadingRPM();
    }

    @Override
    public int getMotorSpeedPWM() {
        return this.machine.currentTool().getMotorSpeedReadingPWM();
    }

    @Override
    public void readToolStatus() {
    }

    @Override
    public int getToolStatus() {
        this.readToolStatus();
        return this.machine.currentTool().getToolStatus();
    }

    @Override
    public void setSpindleDirection(int dir) {
        this.machine.currentTool().setSpindleDirection(dir);
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        this.machine.currentTool().setSpindleSpeedRPM(rpm);
    }

    @Override
    public void setSpindleSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setSpindleSpeedPWM(pwm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        this.machine.currentTool().enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        this.machine.currentTool().disableSpindle();
    }

    @Override
    public double getSpindleRPM() {
        return this.machine.currentTool().getSpindleSpeedReadingRPM();
    }

    @Override
    public int getSpindleSpeedPWM() {
        return this.machine.currentTool().getSpindleSpeedReadingPWM();
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.machine.currentTool().setTargetTemperature(temperature);
    }

    @Override
    public void readTemperature() {
    }

    @Override
    public double getTemperature() {
        this.readTemperature();
        return this.machine.currentTool().getCurrentTemperature();
    }

    @Override
    public void setPlatformTemperature(double temperature) throws RetryException {
        this.machine.currentTool().setPlatformTargetTemperature(temperature);
    }

    @Override
    public void readPlatformTemperature() {
    }

    @Override
    public double getPlatformTemperature() {
        this.readPlatformTemperature();
        return this.machine.currentTool().getPlatformCurrentTemperature();
    }

    @Override
    public void enableFloodCoolant() {
        this.machine.currentTool().enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        this.machine.currentTool().disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        this.machine.currentTool().enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        this.machine.currentTool().disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        this.machine.currentTool().enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        this.machine.currentTool().disableFan();
    }

    @Override
    public void openValve() throws RetryException {
        this.machine.currentTool().openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        this.machine.currentTool().closeValve();
    }

    @Override
    public void openCollet() {
        this.machine.currentTool().openCollet();
    }

    @Override
    public void closeCollet() {
        this.machine.currentTool().closeCollet();
    }

    @Override
    public void pause() {
    }

    @Override
    public void unpause() {
    }

    @Override
    public void stop(boolean abort) {
        Base.logger.info("Machine stop called.");
    }

    @Override
    public void reset() {
        Base.logger.info("Machine reset called.");
    }

    @Override
    public String getDriverName() {
        return null;
    }

    @Override
    public boolean heartbeat() {
        return true;
    }

    @Override
    public double getChamberTemperature() {
        return 0.0;
    }

    @Override
    public void readChamberTemperature() {
    }

    @Override
    public void setChamberTemperature(double temperature) {
    }

    @Override
    public double getPlatformTemperatureSetting() {
        return this.machine.currentTool().getPlatformTargetTemperature();
    }

    @Override
    public double getTemperatureSetting() {
        return this.machine.currentTool().getTargetTemperature();
    }
}

