/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.drivers.Driver;
import replicatorg.drivers.RetryException;
import replicatorg.machine.model.ToolModel;

public class ExtruderPanel
extends JPanel
implements FocusListener,
ActionListener,
ItemListener {
    private ToolModel toolModel;
    private MachineController machine;
    protected JTextField currentTempField;
    protected JTextField platformCurrentTempField;
    protected double targetTemperature;
    protected double targetPlatformTemperature;
    private static final Color targetColor = Color.BLUE;
    private static final Color measuredColor = Color.RED;
    private static final Color targetPlatformColor = Color.YELLOW;
    private static final Color measuredPlatformColor = Color.WHITE;
    long startMillis = System.currentTimeMillis();
    private TimeTableXYDataset measuredDataset = new TimeTableXYDataset();
    private TimeTableXYDataset targetDataset = new TimeTableXYDataset();
    private TimeTableXYDataset measuredPlatformDataset = new TimeTableXYDataset();
    private TimeTableXYDataset targetPlatformDataset = new TimeTableXYDataset();
    protected Pattern extrudeTimePattern;
    protected String[] extrudeTimeStrings = new String[]{"1s", "2s", "5s", "10s", "30s", "60s", "300s"};
    protected boolean continuousJogMode = false;
    protected long extrudeTime;
    private final String EXTRUDE_TIME_PREF_NAME = "extruderpanel.extrudetime";
    protected Driver driver;
    private final Dimension labelMinimumSize = new Dimension(175, 25);

    public ToolModel getTool() {
        return this.toolModel;
    }

    private JLabel makeKeyLabel(String text, Color c) {
        BufferedImage image = new BufferedImage(10, 10, 1);
        Graphics g = image.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, 10, 10);
        ImageIcon icon = new ImageIcon(image);
        return new JLabel(text, icon, 2);
    }

    public ChartPanel makeChart(ToolModel t) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.measuredDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint(null);
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setLowerMargin(0.0);
        axis.setFixedAutoRange(180000.0);
        TickUnits unitSource = new TickUnits();
        unitSource.add((TickUnit)new NumberTickUnit(60000.0));
        unitSource.add((TickUnit)new NumberTickUnit(1000.0));
        axis.setStandardTickUnits((TickUnitSource)unitSource);
        axis.setTickLabelsVisible(false);
        axis = plot.getRangeAxis();
        axis.setRange(0.0, 300.0);
        XYStepRenderer renderer = new XYStepRenderer();
        plot.setDataset(1, (XYDataset)this.targetDataset);
        plot.setRenderer(1, (XYItemRenderer)renderer);
        plot.getRenderer(1).setSeriesPaint(0, (Paint)targetColor);
        plot.getRenderer(0).setSeriesPaint(0, (Paint)measuredColor);
        if (t.hasHeatedPlatform()) {
            plot.setDataset(2, (XYDataset)this.measuredPlatformDataset);
            plot.setRenderer(2, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(2).setSeriesPaint(0, (Paint)measuredPlatformColor);
            plot.setDataset(3, (XYDataset)this.targetPlatformDataset);
            plot.setRenderer(3, (XYItemRenderer)new XYStepRenderer());
            plot.getRenderer(3).setSeriesPaint(0, (Paint)targetPlatformColor);
        }
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(400, 160));
        chartPanel.setOpaque(false);
        return chartPanel;
    }

    private JLabel makeLabel(String text) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setMinimumSize(this.labelMinimumSize);
        label.setMaximumSize(this.labelMinimumSize);
        label.setPreferredSize(this.labelMinimumSize);
        label.setHorizontalAlignment(2);
        return label;
    }

    private void setExtrudeTime(String mode) {
        if ("Continuous Jog".equals(mode)) {
            this.continuousJogMode = true;
            this.extrudeTime = 0L;
        } else {
            if (this.continuousJogMode) {
                this.driver.stop(false);
            }
            this.continuousJogMode = false;
            Matcher jogMatcher = this.extrudeTimePattern.matcher(mode);
            if (jogMatcher.find()) {
                this.extrudeTime = Long.parseLong(jogMatcher.group(1));
            }
        }
        if (mode != null && mode.length() > 0) {
            Base.preferences.put("extruderpanel.extrudetime", mode);
        }
    }

    public ExtruderPanel(MachineController machine, ToolModel t) {
        String enableString;
        JTextField targetTempField;
        JLabel targetTempLabel;
        this.machine = machine;
        this.toolModel = t;
        int textBoxWidth = 75;
        Dimension panelSize = new Dimension(420, 30);
        this.driver = machine.getDriver();
        this.extrudeTimePattern = Pattern.compile("([.0-9]+)");
        this.setLayout((LayoutManager)new MigLayout());
        if (t.hasMotor()) {
            ButtonGroup motorControl;
            AbstractButton motorForwardButton;
            AbstractButton motorStoppedButton;
            AbstractButton motorReverseButton;
            JTextField field;
            JLabel label;
            if (t.getMotorStepperAxis() == null) {
                label = this.makeLabel("Motor Speed (PWM)");
                field = new JTextField();
                field.setMaximumSize(new Dimension(textBoxWidth, 25));
                field.setMinimumSize(new Dimension(textBoxWidth, 25));
                field.setPreferredSize(new Dimension(textBoxWidth, 25));
                field.setName("motor-speed-pwm");
                field.addFocusListener(this);
                field.setActionCommand("handleTextfield");
                field.setText(Integer.toString(this.driver.getMotorSpeedPWM()));
                field.addActionListener(this);
                this.add(label);
                this.add((Component)field, "wrap");
            }
            if (t.motorHasEncoder() || t.motorIsStepper()) {
                label = this.makeLabel("Motor Speed (RPM)");
                field = new JTextField();
                field.setMaximumSize(new Dimension(textBoxWidth, 25));
                field.setMinimumSize(new Dimension(textBoxWidth, 25));
                field.setPreferredSize(new Dimension(textBoxWidth, 25));
                field.setName("motor-speed");
                field.addFocusListener(this);
                field.setActionCommand("handleTextfield");
                field.setText(Double.toString(this.driver.getMotorRPM()));
                field.addActionListener(this);
                this.add(label);
                this.add((Component)field, "wrap");
                if (this.toolModel.getMotorStepperAxis() != null) {
                    label = this.makeLabel("Extrude duration");
                    JComboBox<String> timeList = new JComboBox<String>(this.extrudeTimeStrings);
                    timeList.setSelectedItem(Base.preferences.get("extruderpanel.extrudetime", "5s"));
                    timeList.setActionCommand("Extrude-duration");
                    timeList.addActionListener(this);
                    this.setExtrudeTime((String)timeList.getSelectedItem());
                    this.add(label);
                    this.add(timeList, "wrap");
                }
            }
            JLabel motorEnabledLabel = this.makeLabel("Motor Control");
            if (t.motorHasEncoder() || t.motorIsStepper() && this.toolModel.getMotorStepperAxis() != null) {
                motorReverseButton = new JButton("reverse");
                motorReverseButton.setActionCommand("reverse");
                motorReverseButton.addActionListener(this);
                motorStoppedButton = new JButton("stop");
                motorStoppedButton.setActionCommand("stop");
                motorStoppedButton.addActionListener(this);
                motorForwardButton = new JButton("forward");
                motorForwardButton.setActionCommand("forward");
                motorForwardButton.addActionListener(this);
                motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                this.add((Component)motorEnabledLabel, "split,spanx");
                this.add(motorReverseButton);
                this.add(motorStoppedButton);
                this.add((Component)motorForwardButton, "wrap");
            } else {
                motorReverseButton = new JRadioButton("reverse");
                motorReverseButton.setName("motor-reverse");
                motorReverseButton.setActionCommand("motor-reverse");
                motorReverseButton.addItemListener(this);
                motorStoppedButton = new JRadioButton("stop");
                motorStoppedButton.setName("motor-stop");
                motorStoppedButton.setActionCommand("motor-stop");
                motorStoppedButton.addItemListener(this);
                motorForwardButton = new JRadioButton("forward");
                motorForwardButton.setName("motor-forward");
                motorForwardButton.setActionCommand("motor-forward");
                motorForwardButton.addItemListener(this);
                motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                this.add((Component)motorEnabledLabel, "split,spanx");
                this.add(motorReverseButton);
                this.add(motorStoppedButton);
                this.add((Component)motorForwardButton, "wrap");
            }
        }
        if (t.hasHeater()) {
            targetTempLabel = this.makeKeyLabel("Target Temperature (C)", targetColor);
            targetTempField = new JTextField();
            targetTempField.setMaximumSize(new Dimension(textBoxWidth, 25));
            targetTempField.setMinimumSize(new Dimension(textBoxWidth, 25));
            targetTempField.setPreferredSize(new Dimension(textBoxWidth, 25));
            targetTempField.setName("target-temp");
            targetTempField.addFocusListener(this);
            this.targetTemperature = this.driver.getTemperatureSetting();
            targetTempField.setText(Double.toString(this.targetTemperature));
            targetTempField.setActionCommand("handleTextfield");
            targetTempField.addActionListener(this);
            JLabel currentTempLabel = this.makeKeyLabel("Current Temperature (C)", measuredColor);
            this.currentTempField = new JTextField();
            this.currentTempField.setMaximumSize(new Dimension(textBoxWidth, 25));
            this.currentTempField.setMinimumSize(new Dimension(textBoxWidth, 25));
            this.currentTempField.setPreferredSize(new Dimension(textBoxWidth, 25));
            this.currentTempField.setEnabled(false);
            this.add(targetTempLabel);
            this.add((Component)targetTempField, "wrap");
            this.add(currentTempLabel);
            this.add((Component)this.currentTempField, "wrap");
        }
        if (t.hasHeatedPlatform()) {
            double temperature;
            targetTempLabel = this.makeKeyLabel("Platform Target Temp (C)", targetPlatformColor);
            targetTempField = new JTextField();
            targetTempField.setMaximumSize(new Dimension(textBoxWidth, 25));
            targetTempField.setMinimumSize(new Dimension(textBoxWidth, 25));
            targetTempField.setPreferredSize(new Dimension(textBoxWidth, 25));
            targetTempField.setName("platform-target-temp");
            targetTempField.addFocusListener(this);
            this.targetPlatformTemperature = temperature = this.driver.getPlatformTemperatureSetting();
            targetTempField.setText(Double.toString(temperature));
            targetTempField.setActionCommand("handleTextfield");
            targetTempField.addActionListener(this);
            JLabel currentTempLabel = this.makeKeyLabel("Platform Current Temp (C)", measuredPlatformColor);
            this.platformCurrentTempField = new JTextField();
            this.platformCurrentTempField.setMaximumSize(new Dimension(textBoxWidth, 25));
            this.platformCurrentTempField.setMinimumSize(new Dimension(textBoxWidth, 25));
            this.platformCurrentTempField.setPreferredSize(new Dimension(textBoxWidth, 25));
            this.platformCurrentTempField.setEnabled(false);
            this.add(targetTempLabel);
            this.add((Component)targetTempField, "wrap");
            this.add(currentTempLabel);
            this.add((Component)this.platformCurrentTempField, "wrap");
        }
        if (t.hasHeater() || t.hasHeatedPlatform()) {
            this.add((Component)new JLabel("Temperature Chart"), "growx,spanx,wrap");
            this.add((Component)this.makeChart(t), "growx,spanx,wrap");
        }
        if (t.hasFloodCoolant()) {
            JLabel floodCoolantLabel = this.makeLabel("Flood Coolant");
            JCheckBox floodCoolantCheck = new JCheckBox("enable");
            floodCoolantCheck.setName("flood-coolant");
            floodCoolantCheck.addItemListener(this);
            this.add(floodCoolantLabel);
            this.add((Component)floodCoolantCheck, "wrap");
        }
        if (t.hasMistCoolant()) {
            JLabel mistCoolantLabel = this.makeLabel("Mist Coolant");
            JCheckBox mistCoolantCheck = new JCheckBox("enable");
            mistCoolantCheck.setName("mist-coolant");
            mistCoolantCheck.addItemListener(this);
            this.add(mistCoolantLabel);
            this.add((Component)mistCoolantCheck, "wrap");
        }
        if (t.hasFan()) {
            String fanString = "Cooling Fan";
            enableString = "enable";
            Element xml = this.findMappingNode(t.getXml(), "fan");
            if (xml != null) {
                fanString = xml.getAttribute("name");
                enableString = xml.getAttribute("actuated");
            }
            JLabel fanLabel = this.makeLabel(fanString);
            JCheckBox fanCheck = new JCheckBox(enableString);
            fanCheck.setName("fan-check");
            fanCheck.addItemListener(this);
            this.add(fanLabel);
            this.add((Component)fanCheck, "wrap");
        }
        if (t.hasAutomatedPlatform()) {
            String abpString = "Build platform belt";
            enableString = "enable";
            JLabel abpLabel = this.makeLabel(abpString);
            JCheckBox abpCheck = new JCheckBox(enableString);
            abpCheck.setName("abp-check");
            abpCheck.addItemListener(this);
            this.add(abpLabel);
            this.add((Component)abpCheck, "wrap");
        }
        if (t.hasValve()) {
            String valveString = "Valve";
            enableString = "open";
            Element xml = this.findMappingNode(t.getXml(), "valve");
            if (xml != null) {
                valveString = xml.getAttribute("name");
                enableString = xml.getAttribute("actuated");
            }
            JLabel valveLabel = this.makeLabel(valveString);
            JCheckBox valveCheck = new JCheckBox(enableString);
            valveCheck.setName("valve-check");
            valveCheck.addItemListener(this);
            this.add(valveLabel);
            this.add((Component)valveCheck, "wrap");
        }
        if (t.hasCollet()) {
            JLabel colletLabel = this.makeLabel("Collet");
            JCheckBox colletCheck = new JCheckBox("open");
            colletCheck.setName("collet-check");
            colletCheck.addItemListener(this);
            JPanel colletPanel = new JPanel();
            colletPanel.setLayout(new BoxLayout(colletPanel, 2));
            colletPanel.setMaximumSize(panelSize);
            colletPanel.setMinimumSize(panelSize);
            colletPanel.setPreferredSize(panelSize);
            this.add(colletLabel);
            this.add((Component)colletCheck, "wrap");
        }
    }

    private Element findMappingNode(Node xml, String portName) {
        NodeList children = xml.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element e;
            Node child = children.item(j);
            if (!child.getNodeName().equals("remap") || !(e = (Element)child).getAttribute("port").equals(portName)) continue;
            return e;
        }
        return null;
    }

    public void updateStatus() {
        double temperature;
        Second second = new Second(new Date(System.currentTimeMillis() - this.startMillis));
        int toolStatus = this.machine.getDriver().getToolStatus();
        if (this.machine.getModel().currentTool() == this.toolModel && this.toolModel.hasHeater()) {
            temperature = this.machine.getDriver().getTemperature();
            this.updateTemperature(second, temperature);
        }
        if (this.machine.getModel().currentTool() == this.toolModel && this.toolModel.hasHeatedPlatform()) {
            temperature = this.machine.getDriver().getPlatformTemperature();
            this.updatePlatformTemperature(second, temperature);
        }
    }

    public synchronized void updateTemperature(Second second, double temperature) {
        this.currentTempField.setText(Double.toString(temperature));
        this.measuredDataset.add((TimePeriod)second, temperature, "a");
        this.targetDataset.add((TimePeriod)second, this.targetTemperature, "a");
    }

    public synchronized void updatePlatformTemperature(Second second, double temperature) {
        this.platformCurrentTempField.setText(Double.toString(temperature));
        this.measuredPlatformDataset.add((TimePeriod)second, temperature, "a");
        this.targetPlatformDataset.add((TimePeriod)second, this.targetPlatformTemperature, "a");
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        JTextField source = (JTextField)e.getSource();
        try {
            this.handleChangedTextField(source);
        }
        catch (RetryException e1) {
            Base.logger.severe("Could not execute command; machine busy.");
        }
    }

    private double confirmTemperature(double target, String limitPrefName, double defaultLimit) {
        double limit = Base.preferences.getDouble("temperature.acceptedLimit", defaultLimit);
        if (target > limit) {
            int n = JOptionPane.showConfirmDialog(this, "<html>Setting the temperature to <b>" + Double.toString(target) + "\u00b0C</b> may<br>" + "involve health and/or safety risks or cause damage to your machine!<br>" + "The maximum recommended temperature is <b>" + Double.toString(limit) + "</b>.<br>" + "Do you accept the risk and still want to set this temperature?", "Danger", 0, 2);
            if (n == 0) {
                return target;
            }
            if (n == 1) {
                return Double.MIN_VALUE;
            }
            return Double.MIN_VALUE;
        }
        return target;
    }

    public void handleChangedTextField(JTextField source) throws RetryException {
        String name = source.getName();
        Driver driver = this.machine.getDriver();
        if (source.getText().length() > 0) {
            if (name.equals("target-temp") || name.equals("platform-target-temp")) {
                double target = Double.parseDouble(source.getText());
                if (name.equals("target-temp")) {
                    if ((target = this.confirmTemperature(target, "temperature.acceptedLimit", 260.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    driver.setTemperature(target);
                    this.targetTemperature = target;
                } else {
                    if ((target = this.confirmTemperature(target, "temperature.acceptedLimit.bed", 130.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    driver.setPlatformTemperature(target);
                    this.targetPlatformTemperature = target;
                }
                source.setText(Double.toString(target));
            } else if (name.equals("motor-speed")) {
                driver.setMotorRPM(Double.parseDouble(source.getText()));
            } else if (name.equals("motor-speed-pwm")) {
                driver.setMotorSpeedPWM((int)Double.parseDouble(source.getText()));
            } else {
                Base.logger.warning("Unhandled text field: " + name);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Component source = (Component)((Object)e.getItemSelectable());
        String name = source.getName();
        Driver driver = this.machine.getDriver();
        try {
            if (e.getStateChange() == 1) {
                if (name.equals("motor-forward")) {
                    driver.setMotorDirection(ToolModel.MOTOR_CLOCKWISE);
                    driver.enableMotor();
                } else if (name.equals("motor-reverse")) {
                    driver.setMotorDirection(ToolModel.MOTOR_COUNTER_CLOCKWISE);
                    driver.enableMotor();
                } else if (name.equals("motor-stop")) {
                    driver.disableMotor();
                } else if (name.equals("spindle-enabled")) {
                    driver.enableSpindle();
                } else if (name.equals("flood-coolant")) {
                    driver.enableFloodCoolant();
                } else if (name.equals("mist-coolant")) {
                    driver.enableMistCoolant();
                } else if (name.equals("fan-check")) {
                    driver.enableFan();
                } else if (name.equals("abp-check")) {
                    driver.enableFan();
                } else if (name.equals("valve-check")) {
                    driver.openValve();
                } else if (name.equals("collet-check")) {
                    driver.openCollet();
                } else {
                    Base.logger.warning("checkbox selected: " + source.getName());
                }
            } else if (name.equals("motor-enabled")) {
                driver.disableMotor();
            } else if (name.equals("spindle-enabled")) {
                driver.disableSpindle();
            } else if (name.equals("flood-coolant")) {
                driver.disableFloodCoolant();
            } else if (name.equals("mist-coolant")) {
                driver.disableMistCoolant();
            } else if (name.equals("fan-check")) {
                driver.disableFan();
            } else if (name.equals("abp-check")) {
                driver.disableFan();
            } else if (name.equals("valve-check")) {
                driver.closeValve();
            } else if (name.equals("collet-check")) {
                driver.closeCollet();
            }
        }
        catch (RetryException r) {
            Base.logger.severe("Could not execute command; machine busy.");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            if (s.equals("handleTextfield")) {
                JTextField source = (JTextField)e.getSource();
                try {
                    this.handleChangedTextField(source);
                }
                catch (RetryException e1) {
                    Base.logger.severe("Could not execute command; machine busy.");
                }
                source.selectAll();
            } else if (s.equals("Extrude-duration")) {
                JComboBox cb = (JComboBox)e.getSource();
                String timeText = (String)cb.getSelectedItem();
                this.setExtrudeTime(timeText);
            }
            if (s.equals("forward")) {
                this.driver.setMotorDirection(ToolModel.MOTOR_CLOCKWISE);
                if (this.toolModel.getMotorStepperAxis() != null) {
                    this.driver.enableMotor();
                    this.driver.delay(this.extrudeTime * 1000L);
                    this.driver.disableMotor();
                }
            } else if (s.equals("reverse")) {
                this.driver.setMotorDirection(ToolModel.MOTOR_COUNTER_CLOCKWISE);
                if (this.toolModel.getMotorStepperAxis() != null) {
                    this.driver.enableMotor();
                    this.driver.delay(this.extrudeTime * 1000L);
                    this.driver.disableMotor();
                }
            } else if (s.equals("stop")) {
                this.driver.disableMotor();
                if (this.toolModel.getMotorStepperAxis() != null) {
                    this.driver.stop(false);
                }
            }
        }
        catch (RetryException e1) {
            Base.logger.severe("Could not execute command; machine busy.");
        }
    }
}

