/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import replicatorg.app.Base;
import replicatorg.app.ui.BufferedStyledDocument;
import replicatorg.app.ui.MainWindow;

public class MessagePanel
extends JScrollPane {
    MainWindow editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet timestampStyle;
    MutableAttributeSet infoStyle;
    MutableAttributeSet warnStyle;
    MutableAttributeSet errStyle;
    boolean cerror;
    int maxLineCount;
    static File tempFolder;

    public MessagePanel(MainWindow editor) {
        this.editor = editor;
        this.maxLineCount = Base.preferences.getInt("console.length", 100);
        this.consoleDoc = new BufferedStyledDocument(1000, this.maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        Color bgColor = Base.getColorPref("console.color", "#000000");
        Color infoColor = Base.getColorPref("console.info.color", "#88dd88");
        Color warnColor = Base.getColorPref("console.warning.color", "#dddd88");
        Color timestampColor = Base.getColorPref("console.timestamp.color", "#8888dd");
        Color errColor = Base.getColorPref("console.error.color", "#ff3000");
        Font font = Base.getFontPref("console.font", "Monospaced,plain,11");
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 0);
        StyleConstants.setBackground(standard, bgColor);
        StyleConstants.setFontSize(standard, font.getSize());
        StyleConstants.setFontFamily(standard, font.getFamily());
        StyleConstants.setBold(standard, font.isBold());
        StyleConstants.setItalic(standard, font.isItalic());
        this.consoleDoc.setParagraphAttributes(0, 0, standard, true);
        this.infoStyle = new SimpleAttributeSet(standard);
        StyleConstants.setForeground(this.infoStyle, infoColor);
        this.timestampStyle = new SimpleAttributeSet(standard);
        StyleConstants.setForeground(this.timestampStyle, timestampColor);
        this.errStyle = new SimpleAttributeSet(standard);
        StyleConstants.setForeground(this.errStyle, errColor);
        this.warnStyle = new SimpleAttributeSet(standard);
        StyleConstants.setForeground(this.warnStyle, warnColor);
        this.consoleTextPane.setBackground(bgColor);
        this.setViewportView(this.consoleTextPane);
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int width = metrics.charWidth('n') * 80;
        int minWidth = metrics.charWidth('n') * 40;
        int lines = Base.preferences.getInt("console.lines", 8);
        this.setPreferredSize(new Dimension(width, height * lines));
        this.setMinimumSize(new Dimension(minWidth, height * 5));
        Base.logger.addHandler(new Handler(){
            SimpleDateFormat formatter = new SimpleDateFormat("'['HH:mm:ss'] '");

            public void publish(LogRecord record) {
                String timestamp = this.formatter.format(new Date(record.getMillis()));
                MessagePanel.this.message(timestamp, MessagePanel.this.timestampStyle, false);
                MutableAttributeSet attrs = MessagePanel.this.infoStyle;
                if (record.getLevel() == Level.WARNING) {
                    attrs = MessagePanel.this.warnStyle;
                }
                if (record.getLevel() == Level.SEVERE) {
                    attrs = MessagePanel.this.errStyle;
                }
                if (null != record.getMessage()) {
                    MessagePanel.this.message(record.getMessage(), attrs, true);
                } else if (null != record.getThrown()) {
                    Throwable t = record.getThrown();
                    if (null != t.getLocalizedMessage()) {
                        MessagePanel.this.message(t.getLocalizedMessage(), attrs, true);
                    } else {
                        MessagePanel.this.message(t.toString(), attrs, true);
                    }
                } else {
                    MessagePanel.this.message("<empty log message>", attrs, true);
                }
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        });
        if (Base.isMacOS()) {
            this.setBorder(null);
        }
        new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (MessagePanel.this.consoleDoc.hasAppendage) {
                    MessagePanel.this.consoleDoc.insertAll();
                    MessagePanel.this.consoleTextPane.setCaretPosition(MessagePanel.this.consoleDoc.getLength());
                }
            }
        }).start();
    }

    public void handleQuit() {
    }

    public void message(String what, AttributeSet attrs, boolean advance) {
        this.appendText(what, attrs);
        if (advance) {
            this.appendText("\n", attrs);
        }
    }

    private synchronized void appendText(String txt, AttributeSet attrs) {
        this.consoleDoc.appendString(txt, attrs);
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

