/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.machine.model.AxisId;

public class MachineOnboardParameters
extends JFrame {
    private static final long serialVersionUID = 7876192459063774731L;
    private final OnboardParameters target;
    private final Driver driver;
    private JTextField machineNameField = new JTextField();
    private JCheckBox xAxisInvertBox = new JCheckBox();
    private JCheckBox yAxisInvertBox = new JCheckBox();
    private JCheckBox zAxisInvertBox = new JCheckBox();
    private JCheckBox aAxisInvertBox = new JCheckBox();
    private JCheckBox bAxisInvertBox = new JCheckBox();
    private JButton resetToFactoryButton = new JButton("Reset motherboard to factory settings");
    private static final String[] endstopInversionChoices = new String[]{"No endstops installed", "Inverted (Default; H21LOB-based enstops)", "Non-inverted (H21LOI-based endstops)"};
    private JComboBox endstopInversionSelection = new JComboBox<String>(endstopInversionChoices);
    private static final int MAX_NAME_LENGTH = 16;

    private void resetDialog() {
        int confirm = JOptionPane.showConfirmDialog(this, "<html>Before these changes can take effect, you'll need to reset your <br/>motherboard.  If you choose not to reset the board now, some old settings <br/>will remain in effect until you manually reset.<br/><br/>Reset the motherboard now?</html>", "Reset board?", 0, 2);
        if (confirm == 0) {
            this.driver.reset();
        }
    }

    private void commit() {
        this.target.setMachineName(this.machineNameField.getText());
        EnumSet<AxisId> axesInverted = EnumSet.noneOf(AxisId.class);
        if (this.xAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.X);
        }
        if (this.yAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Y);
        }
        if (this.zAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Z);
        }
        if (this.aAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.A);
        }
        if (this.bAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.B);
        }
        this.target.setInvertedParameters(axesInverted);
        int idx = this.endstopInversionSelection.getSelectedIndex();
        OnboardParameters.EndstopType endstops = OnboardParameters.EndstopType.values()[idx];
        this.target.setInvertedEndstops(endstops);
        this.resetDialog();
    }

    private void resetToFactory() {
        this.target.resetToFactory();
        this.resetDialog();
        this.loadParameters();
    }

    private void loadParameters() {
        this.machineNameField.setText(this.target.getMachineName());
        EnumSet<AxisId> invertedAxes = this.target.getInvertedParameters();
        this.xAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.X));
        this.yAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Y));
        this.zAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Z));
        this.aAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.A));
        this.bAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.B));
        OnboardParameters.EndstopType endstops = this.target.getInvertedEndstops();
        this.endstopInversionSelection.setSelectedIndex(endstops.ordinal());
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JButton commitButton = new JButton("Commit Changes");
        panel.add(commitButton);
        commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MachineOnboardParameters.this.commit();
                MachineOnboardParameters.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MachineOnboardParameters.this.dispose();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    public MachineOnboardParameters(OnboardParameters target, Driver driver) {
        super("Update onboard machine options");
        this.target = target;
        this.driver = driver;
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.machineNameField.setColumns(16);
        panel.add(new JLabel("Machine Name (max. " + Integer.toString(16) + " chars)"));
        panel.add((Component)this.machineNameField, "wrap");
        panel.add(new JLabel("Invert X axis"));
        panel.add((Component)this.xAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert Y axis"));
        panel.add((Component)this.yAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert Z axis"));
        panel.add((Component)this.zAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert A axis"));
        panel.add((Component)this.aAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert B axis"));
        panel.add((Component)this.bAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert endstops"));
        panel.add((Component)this.endstopInversionSelection, "wrap");
        this.resetToFactoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MachineOnboardParameters.this.resetToFactory();
                MachineOnboardParameters.this.loadParameters();
            }
        });
        panel.add((Component)this.resetToFactoryButton, "wrap");
        panel.add(this.makeButtonPanel());
        this.add(panel);
        this.pack();
        this.loadParameters();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
    }
}

