/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import replicatorg.app.Base;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRUList
implements Iterable<String> {
    static final String MRU_LIST_KEY = "mru_list";
    private LinkedList<String> filePaths;
    private static MRUList singleton = null;

    public static MRUList getMRUList() {
        if (singleton == null) {
            singleton = new MRUList();
        }
        return singleton;
    }

    private MRUList() {
        String mruString = Base.preferences.get(MRU_LIST_KEY, null);
        this.filePaths = new LinkedList();
        if (mruString != null && mruString.length() != 0) {
            for (String entry : mruString.split(",")) {
                if (!new File(entry).exists()) continue;
                this.filePaths.addLast(entry);
            }
        }
    }

    private void writeToPreferences() {
        StringBuffer sb = new StringBuffer();
        int remaining_chars = 8192;
        for (String s : this.filePaths) {
            int len = sb.length();
            if (remaining_chars - (len + 1) < 0) break;
            if (len != 0) {
                sb.append(",");
                --remaining_chars;
            }
            sb.append(s);
            remaining_chars -= len;
        }
        Base.preferences.put(MRU_LIST_KEY, sb.toString());
    }

    public void update(String filePath) {
        this.filePaths.remove(filePath);
        this.filePaths.addFirst(filePath);
        this.writeToPreferences();
    }

    @Override
    public Iterator<String> iterator() {
        return this.filePaths.iterator();
    }
}

