/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.text.regex;

import com.oroinc.text.regex.CharStringPointer;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.OpCode;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternCompiler;
import com.oroinc.text.regex.Perl5Pattern;

public final class Perl5Compiler
implements PatternCompiler {
    private static final int __WORSTCASE = 0;
    private static final int __NONNULL = 1;
    private static final int __SIMPLE = 2;
    private static final int __SPSTART = 4;
    private static final int __TRYAGAIN = 8;
    private static final char __CASE_INSENSITIVE = '\u0001';
    private static final char __GLOBAL = '\u0002';
    private static final char __KEEP = '\u0004';
    private static final char __MULTILINE = '\b';
    private static final char __SINGLELINE = '\u0010';
    private static final char __EXTENDED = ' ';
    private static final char __READ_ONLY = '\u8000';
    private static final String __META_CHARS = "^$.[()|?+*\\";
    private static final String __HEX_DIGIT = "0123456789abcdef0123456789ABCDEFx";
    private CharStringPointer __input;
    private boolean __sawBackreference;
    private char[] __modifierFlags = new char[1];
    private int __numParentheses;
    private int __programSize;
    private int __cost;
    private char[] __program;
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;

    public static final String quotemeta(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (!OpCode._isWordCharacter(cArray[n])) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String quotemeta(String string) {
        return Perl5Compiler.quotemeta(string.toCharArray());
    }

    static boolean _isSimpleRepetitionOp(char c) {
        return c == '*' || c == '+' || c == '?';
    }

    static boolean _isComplexRepetitionOp(char[] cArray, int n) {
        if (n < cArray.length && n >= 0) {
            return cArray[n] == '*' || cArray[n] == '+' || cArray[n] == '?' || cArray[n] == '{' && Perl5Compiler._parseRepetition(cArray, n);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static boolean _parseRepetition(char[] var0, int var1_1) {
        if (var0[var1_1] != '{') {
            return false;
        }
        if (++var1_1 < var0.length && Character.isDigit(var0[var1_1])) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl6:
            // 2 sources

            ** while (var1_1 < var0.length && Character.isDigit((char)var0[var1_1]))
        }
lbl7:
        // 1 sources

        if (var1_1 < var0.length && var0[var1_1] == ',') {
            ++var1_1;
        }
        while (var1_1 < var0.length && Character.isDigit(var0[var1_1])) {
            ++var1_1;
        }
        return var1_1 < var0.length && var0[var1_1] == '}';
    }

    static int _parseHex(char[] cArray, int n, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2-- > 0 && (n3 = __HEX_DIGIT.indexOf(cArray[n])) != -1) {
            n4 <<= 4;
            n4 |= n3 & 0xF;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n4;
    }

    static int _parseOctal(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2 > 0 && cArray[n] >= '0' && cArray[n] <= '7') {
            n3 <<= 3;
            n3 |= cArray[n] - 48;
            --n2;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n3;
    }

    static void _setModifierFlag(char[] cArray, char c) {
        switch (c) {
            case 'i': {
                cArray[0] = (char)(cArray[0] | '\u0001');
                return;
            }
            case 'g': {
                cArray[0] = (char)(cArray[0] | 2);
                return;
            }
            case 'o': {
                cArray[0] = (char)(cArray[0] | 4);
                return;
            }
            case 'm': {
                cArray[0] = (char)(cArray[0] | 8);
                return;
            }
            case 's': {
                cArray[0] = (char)(cArray[0] | 0x10);
                return;
            }
            case 'x': {
                cArray[0] = (char)(cArray[0] | 0x20);
                return;
            }
        }
    }

    void _emitCode(char c) {
        if (this.__program != null) {
            this.__program[this.__programSize] = c;
        }
        ++this.__programSize;
    }

    int _emitNode(char c) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 2;
        } else {
            this.__program[this.__programSize++] = c;
            this.__program[this.__programSize++] = '\u0000';
        }
        return n;
    }

    int _emitArgNode(char c, char c2) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 3;
        } else {
            this.__program[this.__programSize++] = c;
            this.__program[this.__programSize++] = '\u0000';
            this.__program[this.__programSize++] = c2;
        }
        return n;
    }

    void _programInsertOperator(char c, int n) {
        int n2;
        int n3 = n2 = OpCode._opType[c] == '\n' ? 2 : 0;
        if (this.__program == null) {
            this.__programSize += 2 + n2;
            return;
        }
        int n4 = this.__programSize;
        this.__programSize += 2 + n2;
        int n5 = this.__programSize;
        while (n4 > n) {
            this.__program[--n5] = this.__program[--n4];
        }
        this.__program[n++] = c;
        this.__program[n++] = '\u0000';
        while (n2-- > 0) {
            this.__program[n++] = '\u0000';
        }
    }

    void _programAddTail(int n, int n2) {
        int n3;
        if (this.__program == null || n == -1) {
            return;
        }
        int n4 = n;
        while ((n3 = OpCode._getNext(this.__program, n4)) != -1) {
            n4 = n3;
        }
        int n5 = this.__program[n4] == '\r' ? n4 - n2 : n2 - n4;
        this.__program[n4 + 1] = (char)n5;
    }

    void _programAddOperatorTail(int n, int n2) {
        if (this.__program == null || n == -1 || OpCode._opType[this.__program[n]] != '\f') {
            return;
        }
        this._programAddTail(OpCode._getNextOperator(n), n2);
    }

    char _getNextChar() {
        char c = this.__input._postIncrement();
        while (true) {
            char c2;
            if ((c2 = this.__input._getValue()) == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
                while (c2 != '\uffff' && c2 != ')') {
                    c2 = this.__input._increment();
                }
                this.__input._increment();
                continue;
            }
            if ((this.__modifierFlags[0] & 0x20) == 0) break;
            if (Character.isWhitespace(c2)) {
                this.__input._increment();
                continue;
            }
            if (c2 != '#') break;
            while (c2 != '\uffff' && c2 != '\n') {
                c2 = this.__input._increment();
            }
            this.__input._increment();
        }
        return c;
    }

    int _parseAlternation(int[] nArray) throws MalformedPatternException {
        int n = 0;
        nArray[0] = 0;
        int n2 = this._emitNode('\f');
        int n3 = -1;
        if (this.__input._getOffset() == 0) {
            this.__input._setOffset(-1);
            this._getNextChar();
        } else {
            this.__input._decrement();
            this._getNextChar();
        }
        char c = this.__input._getValue();
        while (c != '\uffff' && c != '|' && c != ')') {
            n &= 0xFFFFFFF7;
            int n4 = this._parseBranch(nArray);
            if (n4 == -1) {
                if ((n & 8) != 0) {
                    c = this.__input._getValue();
                    continue;
                }
                return -1;
            }
            nArray[0] = nArray[0] | n & 1;
            if (n3 == -1) {
                nArray[0] = nArray[0] | n & 4;
            } else {
                ++this.__cost;
                this._programAddTail(n3, n4);
            }
            n3 = n4;
            c = this.__input._getValue();
        }
        if (n3 == -1) {
            this._emitNode('\u000f');
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    int _parseAtom(int[] var1_1) throws MalformedPatternException {
        block84: {
            var5_2 = new int[1];
            var1_1[0] = 0;
            var2_3 = false;
            var4_4 = -1;
            block50: while (true) {
                var3_5 = this.__input._getValue();
                switch (var3_5) {
                    case '^': {
                        this._getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this._emitNode('\u0002');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this._emitNode('\u0003');
                            break block50;
                        }
                        var4_4 = this._emitNode('\u0001');
                        break block50;
                    }
                    case '$': {
                        this._getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this._emitNode('\u0005');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this._emitNode('\u0006');
                            break block50;
                        }
                        var4_4 = this._emitNode('\u0004');
                        break block50;
                    }
                    case '.': {
                        this._getNextChar();
                        var4_4 = (this.__modifierFlags[0] & 16) != 0 ? this._emitNode('\b') : this._emitNode('\u0007');
                        ++this.__cost;
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case '[': {
                        this.__input._increment();
                        var4_4 = this._parseCharacterClass();
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case '(': {
                        this._getNextChar();
                        var4_4 = this._parseExpression(true, var5_2);
                        if (var4_4 == -1) {
                            if ((var5_2[0] & 8) != 0) continue block50;
                            return -1;
                        }
                        var1_1[0] = var1_1[0] | var5_2[0] & 5;
                        break block50;
                    }
                    case ')': 
                    case '|': {
                        if ((var5_2[0] & 8) != 0) {
                            var1_1[0] = var1_1[0] | 8;
                            return -1;
                        }
                        throw new MalformedPatternException("Error in expression at " + this.__input._toString(this.__input._getOffset()));
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        throw new MalformedPatternException("?+* follows nothing in expression");
                    }
                    case '\\': {
                        var3_5 = this.__input._increment();
                        switch (var3_5) {
                            case 'A': {
                                var4_4 = this._emitNode('\u0003');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 'G': {
                                var4_4 = this._emitNode('\u001e');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 'Z': {
                                var4_4 = this._emitNode('\u0006');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 'w': {
                                var4_4 = this._emitNode('\u0012');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 'W': {
                                var4_4 = this._emitNode('\u0013');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 'b': {
                                var4_4 = this._emitNode('\u0014');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 'B': {
                                var4_4 = this._emitNode('\u0015');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 's': {
                                var4_4 = this._emitNode('\u0016');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 'S': {
                                var4_4 = this._emitNode('\u0017');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 'd': {
                                var4_4 = this._emitNode('\u0018');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 'D': {
                                var4_4 = this._emitNode('\u0019');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case '0': 
                            case 'a': 
                            case 'c': 
                            case 'e': 
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 't': 
                            case 'x': {
                                var2_3 = true;
                                break block50;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var7_6 = new StringBuffer(10);
                                var6_8 = '\u0000';
                                var3_5 = this.__input._getValueRelative(var6_8);
                                while (Character.isDigit(var3_5)) {
                                    var7_6.append(var3_5);
                                    var3_5 = this.__input._getValueRelative(++var6_8);
                                }
                                try {
                                    var6_8 = Integer.parseInt(var7_6.toString());
                                }
                                catch (NumberFormatException var8_9) {
                                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var8_9.getMessage());
                                }
                                if (var6_8 > '\t' && var6_8 >= this.__numParentheses) {
                                    var2_3 = true;
                                    break block50;
                                }
                                if (var6_8 >= this.__numParentheses) {
                                    throw new MalformedPatternException("Invalid backreference: \\" + var6_8);
                                }
                                this.__sawBackreference = true;
                                var4_4 = this._emitArgNode('\u001a', var6_8);
                                var1_1[0] = var1_1[0] | 1;
                                var3_5 = this.__input._getValue();
                                while (Character.isDigit(var3_5)) {
                                    var3_5 = this.__input._increment();
                                }
                                this.__input._decrement();
                                this._getNextChar();
                                break block50;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (!this.__input._isAtEnd()) break;
                                throw new MalformedPatternException("Trailing \\ in expression.");
                            }
                        }
                        var2_3 = true;
                        break block50;
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (!this.__input._isAtEnd() && this.__input._getValue() != '\n') {
                                this.__input._increment();
                            }
                            if (this.__input._isAtEnd()) ** break;
                            continue block50;
                        }
                    }
                    default: {
                        this.__input._increment();
                        var2_3 = true;
                    }
                }
                break;
            }
            if (!var2_3) break block84;
            var4_4 = this._emitNode('\u000e');
            if (this.__program != null) {
                this.__program[this.__programSize] = 65535;
            }
            ++this.__programSize;
            var7_7 = 0;
            var8_10 = this.__input._getOffset() - 1;
            var9_11 = this.__input._getLength();
            block54: while (var7_7 < 127 && var8_10 < var9_11) {
                var10_12 = var8_10;
                var3_5 = this.__input._getValue(var8_10);
                switch (var3_5) {
                    case '\\': {
                        var3_5 = this.__input._getValue(++var8_10);
                        switch (var3_5) {
                            case 'A': 
                            case 'B': 
                            case 'D': 
                            case 'G': 
                            case 'S': 
                            case 'W': 
                            case 'Z': 
                            case 'b': 
                            case 'd': 
                            case 's': 
                            case 'w': {
                                --var8_10;
                                break block54;
                            }
                            case 'n': {
                                var6_8 = '\n';
                                ++var8_10;
                                break;
                            }
                            case 'r': {
                                var6_8 = '\r';
                                ++var8_10;
                                break;
                            }
                            case 't': {
                                var6_8 = '\t';
                                ++var8_10;
                                break;
                            }
                            case 'f': {
                                var6_8 = '\f';
                                ++var8_10;
                                break;
                            }
                            case 'e': {
                                var6_8 = '\u001b';
                                ++var8_10;
                                break;
                            }
                            case 'a': {
                                var6_8 = '\u0007';
                                ++var8_10;
                                break;
                            }
                            case 'x': {
                                var11_13 = new int[1];
                                var6_8 = (char)Perl5Compiler._parseHex(this.__input._array, ++var8_10, 2, var11_13);
                                var8_10 += var11_13[0];
                                break;
                            }
                            case 'c': {
                                v0 = ++var8_10;
                                ++var8_10;
                                var6_8 = this.__input._getValue(v0);
                                if (Character.isLowerCase(var6_8)) {
                                    var6_8 = Character.toUpperCase(var6_8);
                                }
                                var6_8 = (char)(var6_8 ^ 64);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var12_14 = false;
                                var3_5 = this.__input._getValue(var8_10);
                                if (var3_5 == '0') {
                                    var12_14 = true;
                                }
                                if (Character.isDigit(var3_5 = this.__input._getValue(var8_10 + 1))) {
                                    var14_16 = new StringBuffer(10);
                                    var13_15 = var8_10;
                                    var3_5 = this.__input._getValue(var13_15);
                                    while (Character.isDigit(var3_5)) {
                                        var14_16.append(var3_5);
                                        var3_5 = this.__input._getValue(++var13_15);
                                    }
                                    try {
                                        var13_15 = Integer.parseInt(var14_16.toString());
                                    }
                                    catch (NumberFormatException var15_17) {
                                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var15_17.getMessage());
                                    }
                                    if (!var12_14) {
                                        v1 = var12_14 = var13_15 >= this.__numParentheses;
                                    }
                                }
                                if (var12_14) {
                                    var11_13 = new int[1];
                                    var6_8 = (char)Perl5Compiler._parseOctal(this.__input._array, var8_10, 3, var11_13);
                                    var8_10 += var11_13[0];
                                    break;
                                }
                                --var8_10;
                                break block54;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (var8_10 >= var9_11) {
                                    throw new MalformedPatternException("Trailing \\ in expression.");
                                }
                            }
                            default: {
                                var6_8 = this.__input._getValue(var8_10++);
                                break;
                            }
                        }
                        ** GOTO lbl281
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (var8_10 < var9_11 && this.__input._getValue(var8_10) != '\n') {
                                ++var8_10;
                            }
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if ((this.__modifierFlags[0] & 32) == 0) ** GOTO lbl279
                        ++var8_10;
                        --var7_7;
                        ** GOTO lbl295
                    }
lbl279:
                    // 2 sources

                    default: {
                        var6_8 = this.__input._getValue(var8_10++);
lbl281:
                        // 2 sources

                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var6_8)) {
                            var6_8 = Character.toLowerCase(var6_8);
                        }
                        if (var8_10 < var9_11 && Perl5Compiler._isComplexRepetitionOp(this.__input._array, var8_10)) {
                            if (var7_7 > 0) {
                                var8_10 = var10_12;
                                break block54;
                            }
                            ++var7_7;
                            if (this.__program != null) {
                                this.__program[this.__programSize] = var6_8;
                            }
                            ++this.__programSize;
                            break block54;
                        }
                        if (this.__program != null) {
                            this.__program[this.__programSize] = var6_8;
                        }
                        ++this.__programSize;
lbl295:
                        // 2 sources

                        ++var7_7;
                        continue block54;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case '^': 
                    case '|': {
                        break block54;
                    }
                }
            }
            this.__input._setOffset(var8_10 - 1);
            this._getNextChar();
            if (var7_7 < 0) {
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            }
            if (var7_7 > 0) {
                var1_1[0] = var1_1[0] | 1;
            }
            if (var7_7 == 1) {
                var1_1[0] = var1_1[0] | 2;
            }
            if (this.__program != null) {
                this.__program[OpCode._getOperand((int)var4_4)] = (char)var7_7;
            }
            if (this.__program != null) {
                this.__program[this.__programSize] = 65535;
            }
            ++this.__programSize;
        }
        return var4_4;
    }

    void _setCharacterClassBits(char[] cArray, int n, char c, char c2) {
        if (this.__program == null || c2 >= '\u0100') {
            return;
        }
        c2 = (char)(c2 & 0xFFFF);
        if (c == '\u0000') {
            int n2 = n + (c2 >> 4);
            cArray[n2] = (char)(cArray[n2] | 1 << (c2 & 0xF));
            return;
        }
        int n3 = n + (c2 >> 4);
        cArray[n3] = (char)(cArray[n3] & ~(1 << (c2 & 0xF)));
    }

    /*
     * Unable to fully structure code
     */
    int _parseCharacterClass() throws MalformedPatternException {
        block40: {
            var1_1 = false;
            var5_2 = '\uffff';
            var8_3 = new int[1];
            var6_4 = this._emitNode('\t');
            if (this.__input._getValue() == '^') {
                ++this.__cost;
                this.__input._increment();
                var4_5 = '\u0000';
            } else {
                var4_5 = '\uffff';
            }
            var7_6 = this.__programSize;
            var3_7 = '\u0000';
            while (var3_7 < '\u0010') {
                if (this.__program != null) {
                    this.__program[this.__programSize] = var4_5;
                }
                ++this.__programSize;
                var3_7 = (char)(var3_7 + 1);
            }
            var3_7 = this.__input._getValue();
            if (var3_7 != ']' && var3_7 != 45) break block40;
            var2_8 = true;
            ** GOTO lbl145
        }
        var2_8 = false;
        if (true) ** GOTO lbl145
        while (true) {
            var2_8 = false;
            this.__input._increment();
            if (var3_7 != 92) ** GOTO lbl-1000
            var3_7 = this.__input._postIncrement();
            switch (var3_7) {
                case 'w': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (OpCode._isWordCharacter(var3_7)) {
                            this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'W': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (!OpCode._isWordCharacter(var3_7)) {
                            this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 's': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (Character.isWhitespace(var3_7)) {
                            this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'S': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (!Character.isWhitespace(var3_7)) {
                            this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'd': {
                    var3_7 = '0';
                    while (var3_7 <= '9') {
                        this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'D': {
                    var3_7 = '\u0000';
                    while (var3_7 < '0') {
                        this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var3_7 = ':';
                    while (var3_7 < '\u0100') {
                        this._setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'n': {
                    var3_7 = '\n';
                    ** GOTO lbl127
                }
                case 'r': {
                    var3_7 = '\r';
                    ** GOTO lbl127
                }
                case 't': {
                    var3_7 = '\t';
                    ** GOTO lbl127
                }
                case 'f': {
                    var3_7 = '\f';
                    ** GOTO lbl127
                }
                case 'b': {
                    var3_7 = '\b';
                    ** GOTO lbl127
                }
                case 'e': {
                    var3_7 = '\u001b';
                    ** GOTO lbl127
                }
                case 'a': {
                    var3_7 = '\u0007';
                    ** GOTO lbl127
                }
                case 'x': {
                    var3_7 = (char)Perl5Compiler._parseHex(this.__input._array, this.__input._getOffset(), 2, var8_3);
                    this.__input._increment(var8_3[0]);
                    ** GOTO lbl127
                }
                case 'c': {
                    var3_7 = this.__input._postIncrement();
                    if (Character.isLowerCase(var3_7)) {
                        var3_7 = Character.toUpperCase(var3_7);
                    }
                    var3_7 = (char)(var3_7 ^ 64);
                    ** GOTO lbl127
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    var3_7 = (char)Perl5Compiler._parseOctal(this.__input._array, this.__input._getOffset() - 1, 3, var8_3);
                    this.__input._increment(var8_3[0] - 1);
                }
lbl127:
                // 11 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (!var1_1) ** GOTO lbl133
                    if (var5_2 > var3_7) {
                        throw new MalformedPatternException("Invalid [] range in expression.");
                    }
                    var1_1 = false;
                    ** GOTO lbl143
lbl133:
                    // 1 sources

                    var5_2 = var3_7;
                    if (this.__input._getValue() != '-' || this.__input._getOffset() + 1 >= this.__input._getLength() || this.__input._getValueRelative(1) == ']') ** GOTO lbl143
                    this.__input._increment();
                    var1_1 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this._setCharacterClassBits(this.__program, var7_6, var4_5, var5_2);
                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var5_2)) {
                            this._setCharacterClassBits(this.__program, var7_6, var4_5, Character.toLowerCase(var5_2));
                        }
                        var5_2 = (char)(var5_2 + '\u0001');
lbl143:
                        // 3 sources

                        ** while (var5_2 <= var3_7)
                    }
lbl144:
                    // 1 sources

                    var5_2 = var3_7;
                }
            }
lbl145:
            // 10 sources

            if (!this.__input._isAtEnd()) {
                v0 = this.__input._getValue();
                var3_7 = v0;
                if (v0 != ']') continue;
            }
            if (!var2_8) break;
        }
        if (this.__input._getValue() != ']') {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this._getNextChar();
        return var6_4;
    }

    int _parseBranch(int[] nArray) throws MalformedPatternException {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = new int[1];
        int n = 0;
        int n2 = 65535;
        int n3 = this._parseAtom(nArray2);
        if (n3 == -1) {
            if ((nArray2[0] & 8) != 0) {
                nArray[0] = nArray[0] | 8;
            }
            return -1;
        }
        char c = this.__input._getValue();
        if (c == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
            while (c != '\uffff' && c != ')') {
                c = this.__input._increment();
            }
            if (c != '\uffff') {
                this._getNextChar();
                c = this.__input._getValue();
            }
        }
        if (c == '{' && Perl5Compiler._parseRepetition(this.__input._array, this.__input._getOffset())) {
            int n4;
            int n5 = this.__input._getOffset() + 1;
            int n6 = n4 = this.__input._getLength();
            char c2 = this.__input._getValue(n5);
            while (Character.isDigit(c2) || c2 == ',') {
                if (c2 == ',') {
                    if (n6 != n4) break;
                    n6 = n5;
                }
                c2 = this.__input._getValue(++n5);
            }
            if (c2 == '}') {
                StringBuffer stringBuffer = new StringBuffer(10);
                if (n6 == n4) {
                    n6 = n5;
                }
                this.__input._increment();
                int n7 = this.__input._getOffset();
                c2 = this.__input._getValue(n7);
                while (Character.isDigit(c2)) {
                    stringBuffer.append(c2);
                    c2 = this.__input._getValue(++n7);
                }
                try {
                    n = Integer.parseInt(stringBuffer.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                c2 = this.__input._getValue(n6);
                n6 = c2 == ',' ? ++n6 : this.__input._getOffset();
                n7 = n6;
                stringBuffer = new StringBuffer(10);
                c2 = this.__input._getValue(n7);
                while (Character.isDigit(c2)) {
                    stringBuffer.append(c2);
                    c2 = this.__input._getValue(++n7);
                }
                try {
                    if (n7 != n6) {
                        n2 = Integer.parseInt(stringBuffer.toString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                if (n2 == 0 && this.__input._getValue(n6) != '0') {
                    n2 = 65535;
                }
                this.__input._setOffset(n5);
                this._getNextChar();
                bl = true;
                bl2 = true;
            }
        }
        if (!bl) {
            bl2 = false;
            if (c != '*' && c != '+' && c != '?') {
                nArray[0] = nArray2[0];
                return n3;
            }
            this._getNextChar();
            int n8 = nArray[0] = c != '+' ? 4 : 1;
            if (c == '*' && (nArray2[0] & 2) != 0) {
                this._programInsertOperator('\u0010', n3);
                this.__cost += 4;
            } else if (c == '*') {
                n = 0;
                bl2 = true;
            } else if (c == '+' && (nArray2[0] & 2) != 0) {
                this._programInsertOperator('\u0011', n3);
                this.__cost += 3;
            } else if (c == '+') {
                n = 1;
                bl2 = true;
            } else if (c == '?') {
                n = 0;
                n2 = 1;
                bl2 = true;
            }
        }
        if (bl2) {
            if ((nArray2[0] & 2) != 0) {
                this.__cost += (2 + this.__cost) / 2;
                this._programInsertOperator('\n', n3);
            } else {
                this.__cost += 4 + this.__cost;
                this._programAddTail(n3, this._emitNode('\"'));
                this._programInsertOperator('\u000b', n3);
                this._programAddTail(n3, this._emitNode('\u000f'));
            }
            if (n > 0) {
                nArray[0] = 1;
            }
            if (n2 != 0 && n2 < n) {
                throw new MalformedPatternException("Invalid interval {" + n + "," + n2 + "}");
            }
            if (this.__program != null) {
                this.__program[n3 + 2] = (char)n;
                this.__program[n3 + 3] = (char)n2;
            }
        }
        if (this.__input._getValue() == '?') {
            this._getNextChar();
            this._programInsertOperator('\u001d', n3);
            this._programAddTail(n3, n3 + 2);
        }
        if (Perl5Compiler._isComplexRepetitionOp(this.__input._array, this.__input._getOffset())) {
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        }
        return n3;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    int _parseExpression(boolean var1_1, int[] var2_2) throws MalformedPatternException {
        var5_3 = -1;
        var6_4 = 0;
        var9_5 = new int[1];
        var2_2[0] = 1;
        if (!var1_1) ** GOTO lbl42
        var4_6 = '\u0001';
        if (this.__input._getValue() != '?') ** GOTO lbl39
        this.__input._increment();
        var4_6 = var3_7 = this.__input._postIncrement();
        switch (var3_7) {
            case '#': {
                var3_7 = this.__input._getValue();
                while (true) {
                    if (var3_7 == '\uffff' || var3_7 == ')') {
                        if (var3_7 == ')') break;
                        throw new MalformedPatternException("Sequence (?#... not terminated");
                    }
                    var3_7 = this.__input._increment();
                }
                this._getNextChar();
                var2_2[0] = 8;
                return -1;
            }
            default: {
                this.__input._decrement();
                var3_7 = this.__input._getValue();
                while (true) {
                    if (var3_7 == '\uffff' || "iogmsx".indexOf(var3_7) == -1) {
                        if (var3_7 == ')') break;
                        throw new MalformedPatternException("Sequence (?" + var3_7 + "...) not recognized");
                    }
                    Perl5Compiler._setModifierFlag(this.__modifierFlags, var3_7);
                    var3_7 = this.__input._increment();
                }
                this._getNextChar();
                var2_2[0] = 8;
                return -1;
            }
lbl39:
            // 1 sources

            var6_4 = this.__numParentheses++;
            var5_3 = this._emitArgNode('\u001b', (char)var6_4);
            break;
lbl42:
            // 1 sources

            var4_6 = '\u0000';
            break;
            case '!': 
            case ':': 
            case '=': 
        }
        var7_8 = this._parseAlternation(var9_5);
        if (var7_8 == -1) {
            return -1;
        }
        if (var5_3 != -1) {
            this._programAddTail(var5_3, var7_8);
        } else {
            var5_3 = var7_8;
        }
        if ((var9_5[0] & 1) == 0) {
            var2_2[0] = var2_2[0] & -2;
        }
        var2_2[0] = var2_2[0] | var9_5[0] & 4;
        while (this.__input._getValue() == '|') {
            this._getNextChar();
            var7_8 = this._parseAlternation(var9_5);
            if (var7_8 == -1) {
                return -1;
            }
            this._programAddTail(var5_3, var7_8);
            if ((var9_5[0] & 1) == 0) {
                var2_2[0] = var2_2[0] & -2;
            }
            var2_2[0] = var2_2[0] | var9_5[0] & 4;
        }
        switch (var4_6) {
            case ':': {
                var8_9 = this._emitNode('\u000f');
                break;
            }
            case '\u0001': {
                var8_9 = this._emitArgNode('\u001c', (char)var6_4);
                break;
            }
            case '!': 
            case '=': {
                var8_9 = this._emitNode('!');
                var2_2[0] = var2_2[0] & -2;
                break;
            }
            default: {
                var8_9 = this._emitNode('\u0000');
            }
        }
        this._programAddTail(var5_3, var8_9);
        var7_8 = var5_3;
        while (var7_8 != -1) {
            this._programAddOperatorTail(var7_8, var8_9);
            var7_8 = OpCode._getNext(this.__program, var7_8);
        }
        if (var4_6 == '=') {
            this._programInsertOperator('\u001f', var5_3);
            this._programAddTail(var5_3, this._emitNode('\u000f'));
        } else if (var4_6 == '!') {
            this._programInsertOperator(' ', var5_3);
            this._programAddTail(var5_3, this._emitNode('\u000f'));
        }
        if (var4_6 != '\u0000' && (this.__input._isAtEnd() || this._getNextChar() != ')')) {
            throw new MalformedPatternException("Unmatched parentheses.");
        }
        if (var4_6 == '\u0000' && !this.__input._isAtEnd()) {
            if (this.__input._getValue() == ')') {
                throw new MalformedPatternException("Unmatched parentheses.");
            }
            throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
        }
        return var5_3;
    }

    /*
     * Unable to fully structure code
     */
    public Pattern compile(char[] var1_1, int var2_2) throws MalformedPatternException {
        block42: {
            var3_3 = new int[1];
            var10_4 = false;
            var11_5 = false;
            var15_6 = 0;
            this.__input = new CharStringPointer(var1_1);
            var4_7 = var2_2 & 1;
            this.__modifierFlags[0] = (char)var2_2;
            this.__sawBackreference = false;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__program = null;
            if (this.__program != null) {
                this.__program[this.__programSize] = '\u0000';
            }
            ++this.__programSize;
            if (this._parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            if (this.__programSize >= 65534) {
                throw new MalformedPatternException("Expression is too large.");
            }
            this.__program = new char[this.__programSize];
            var6_8 = new Perl5Pattern();
            var6_8._program = this.__program;
            var6_8._expression = new String(var1_1);
            this.__input._setOffset(0);
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            if (this.__program != null) {
                this.__program[this.__programSize] = '\u0000';
            }
            ++this.__programSize;
            if (this._parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            var4_7 = this.__modifierFlags[0] & '\u0001';
            var6_8._isExpensive = this.__cost >= 10;
            var6_8._startClassOffset = -1;
            var6_8._anchor = 0;
            var6_8._back = -1;
            var6_8._options = var2_2;
            var6_8._startString = null;
            var6_8._mustString = null;
            var7_9 = null;
            var8_10 = null;
            var5_11 = 1;
            if (this.__program[OpCode._getNext(this.__program, var5_11)] != '\u0000') break block42;
            var9_12 = var5_11 = OpCode._getNextOperator(var5_11);
            var20_13 = this.__program[var9_12];
            if (true) ** GOTO lbl55
            while (true) {
                if (var20_13 == '\u0011') {
                    var11_5 = true;
                } else {
                    var9_12 += OpCode._operandLength[var20_13];
                }
                var9_12 = OpCode._getNextOperator(var9_12);
                var20_13 = this.__program[var9_12];
lbl55:
                // 2 sources

                if (var20_13 == '\u001b') {
                    var10_4 = true;
                    if (true) continue;
                }
                if (!(var20_13 == '\f' && this.__program[OpCode._getNext(this.__program, var9_12)] != '\f' || var20_13 == '\u0011' || var20_13 == '\u001d' || OpCode._opType[var20_13] == '\n' && OpCode._getArg1(this.__program, var9_12) > '\u0000')) break;
            }
            var19_14 = true;
            while (var19_14) {
                var19_14 = false;
                var20_13 = this.__program[var9_12];
                if (var20_13 == '\u000e') {
                    var8_10 = new String(this.__program, OpCode._getOperand(var9_12 + 1), (int)this.__program[OpCode._getOperand(var9_12)]);
                    continue;
                }
                if (OpCode._isInArray(var20_13, OpCode._opLengthOne, 2)) {
                    var6_8._startClassOffset = var9_12;
                    continue;
                }
                if (var20_13 == '\u0014' || var20_13 == '\u0015') {
                    var6_8._startClassOffset = var9_12;
                    continue;
                }
                if (OpCode._opType[var20_13] == '\u0001') {
                    var6_8._anchor = 1;
                    var9_12 = OpCode._getNextOperator(var9_12);
                    var19_14 = true;
                    continue;
                }
                if (var20_13 != '\u0010' || OpCode._opType[this.__program[OpCode._getNextOperator(var9_12)]] != '\u0007' || (var6_8._anchor & 1) == 0) continue;
                var6_8._anchor = 5;
                var9_12 = OpCode._getNextOperator(var9_12);
                var19_14 = true;
            }
            if (!(!var11_5 || var10_4 && this.__sawBackreference)) {
                var6_8._anchor |= 2;
            }
            var12_15 = new StringBuffer();
            var13_16 = new StringBuffer();
            var14_17 = 0;
            var15_6 = 0;
            var16_18 = 0;
            var17_19 = 0;
            var18_20 = 0;
            while (var5_11 > 0 && (var20_13 = this.__program[var5_11]) != '\u0000') {
                if (var20_13 == '\f') {
                    if (this.__program[OpCode._getNext(this.__program, var5_11)] == '\f') {
                        var16_18 = -30000;
                        while (this.__program[var5_11] == '\f') {
                            var5_11 = OpCode._getNext(this.__program, var5_11);
                        }
                        continue;
                    }
                    var5_11 = OpCode._getNextOperator(var5_11);
                    continue;
                }
                if (var20_13 == ' ') {
                    var16_18 = -30000;
                    var5_11 = OpCode._getNext(this.__program, var5_11);
                    continue;
                }
                if (var20_13 == '\u000e') {
                    var9_12 = var5_11;
                    while (this.__program[var21_21 = OpCode._getNext(this.__program, var5_11)] == '\u001c') {
                        var5_11 = var21_21;
                    }
                    var15_6 += this.__program[OpCode._getOperand(var9_12)];
                    var21_21 = this.__program[OpCode._getOperand(var9_12)];
                    if (var16_18 - var17_19 == var14_17) {
                        var12_15.append(new String(this.__program, OpCode._getOperand(var9_12) + 1, var21_21));
                        var14_17 += var21_21;
                        var16_18 += var21_21;
                        var9_12 = OpCode._getNext(this.__program, var5_11);
                    } else if (var21_21 >= var14_17 + (var16_18 >= 0 ? 1 : 0)) {
                        var14_17 = var21_21;
                        var12_15 = new StringBuffer(new String(this.__program, OpCode._getOperand(var9_12) + 1, var21_21));
                        var17_19 = var16_18;
                        var16_18 += var14_17;
                        var9_12 = OpCode._getNext(this.__program, var5_11);
                    } else {
                        var16_18 += var21_21;
                    }
                } else if (OpCode._isInArray(var20_13, OpCode._opLengthVaries, 0)) {
                    var16_18 = -30000;
                    var14_17 = 0;
                    if (var12_15.length() > var13_16.length()) {
                        var13_16 = var12_15;
                        var18_20 = var17_19;
                    }
                    var12_15 = new StringBuffer();
                    if (var20_13 == '\u0011' && OpCode._isInArray(this.__program[OpCode._getNextOperator(var5_11)], OpCode._opLengthOne, 0)) {
                        ++var15_6;
                    } else if (OpCode._opType[var20_13] == '\n' && OpCode._isInArray(this.__program[OpCode._getNextOperator(var5_11) + 2], OpCode._opLengthOne, 0)) {
                        var15_6 += OpCode._getArg1(this.__program, var5_11);
                    }
                } else if (OpCode._isInArray(var20_13, OpCode._opLengthOne, 0)) {
                    ++var16_18;
                    ++var15_6;
                    var14_17 = 0;
                    if (var12_15.length() > var13_16.length()) {
                        var13_16 = var12_15;
                        var18_20 = var17_19;
                    }
                    var12_15 = new StringBuffer();
                }
                var5_11 = OpCode._getNext(this.__program, var5_11);
            }
            if (var12_15.length() + (OpCode._opType[this.__program[var9_12]] == '\u0004' ? 1 : 0) > var13_16.length()) {
                var13_16 = var12_15;
                var18_20 = var17_19;
            } else {
                var12_15 = new StringBuffer();
            }
            if (var13_16.length() > 0 && var8_10 == null) {
                var7_9 = var13_16.toString();
                if (var18_20 < 0) {
                    var18_20 = -1;
                }
                var6_8._back = var18_20;
            } else {
                var13_16 = null;
            }
        }
        var6_8._isCaseInsensitive = (var4_7 & 1) != 0;
        var6_8._numParentheses = this.__numParentheses - 1;
        var6_8._minLength = var15_6;
        if (var7_9 != null) {
            var6_8._mustString = var7_9.toCharArray();
            var6_8._mustUtility = 100;
        }
        if (var8_10 != null) {
            var6_8._startString = var8_10.toCharArray();
        }
        return var6_8;
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n);
    }
}

