/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.util.ScriptSystem;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.UIManager;

public class Fonts {
    private static HashMap fonts;
    private static FontRenderContext defaultFontRenderContext;

    private Fonts() {
    }

    private static void init() {
        if (fonts == null) {
            fonts = new HashMap();
            Font dialogFont = UIManager.getFont("Label.font");
            Font emphasizedDialogFont = dialogFont.deriveFont(1);
            Font smallDialogFont = dialogFont.getSize() >= 13 ? dialogFont.deriveFont((float)(dialogFont.getSize() - 2)) : dialogFont;
            Font emphasizedSmallDialogFont = smallDialogFont.deriveFont(1);
            fonts.put("Dialog", dialogFont);
            fonts.put("EmphasizedDialog", emphasizedDialogFont);
            fonts.put("SmallDialog", smallDialogFont);
            fonts.put("EmphasizedSmallDialog", emphasizedSmallDialogFont);
            fonts.put("Application", dialogFont);
            fonts.put("Label", dialogFont.deriveFont(10.0f));
            fonts.put("MiniDialog", dialogFont.deriveFont(9.0f));
            fonts.put("Monospace", new Font("Courier", 0, dialogFont.getSize()));
            if (QuaquaManager.getProperty("java.version").startsWith("1.3")) {
                fonts.put("DialogTag", "<font face='" + dialogFont.getName() + "'>");
                fonts.put("/DialogTag", "</font>");
                fonts.put("SmallDialogTag", "<font face='" + dialogFont.getName() + "' size=-1>");
                fonts.put("/SmallDialogTag", "</font>");
                fonts.put("MiniDialogTag", "<font face='" + dialogFont.getName() + "' size=-2>");
                fonts.put("/MiniDialogTag", "</font>");
                fonts.put("EmphasizedDialogTag", "<font face='" + dialogFont.getName() + "'><b>");
                fonts.put("/EmphasizedDialogTag", "</b></font>");
            } else {
                fonts.put("DialogTag", "");
                fonts.put("/DialogTag", "");
                fonts.put("SmallDialogTag", "<font size=-1>");
                fonts.put("/SmallDialogTag", "</font>");
                fonts.put("MiniDialogTag", "<font size=-2>");
                fonts.put("/MiniDialogTag", "</font>");
                fonts.put("EmphasizedDialogTag", "<b>");
                fonts.put("/EmphasizedDialogTag", "</b>");
            }
        }
    }

    public static Font getDialogFont() {
        Fonts.init();
        return (Font)fonts.get("Dialog");
    }

    public static Font getEmphasizedDialogFont() {
        Fonts.init();
        return (Font)fonts.get("EmphasizedDialog");
    }

    public static Font getSmallDialogFont() {
        Fonts.init();
        return (Font)fonts.get("SmallDialog");
    }

    public static Font getEmphasizedSmallDialogFont() {
        Fonts.init();
        return (Font)fonts.get("EmphasizedSmallDialog");
    }

    public static Font getApplicationFont() {
        Fonts.init();
        return (Font)fonts.get("Application");
    }

    public static Font getMonospaceFont() {
        Fonts.init();
        return (Font)fonts.get("Monospace");
    }

    public static Font getLabelFont() {
        Fonts.init();
        return (Font)fonts.get("Label");
    }

    public static Font getMiniDialogFont() {
        Fonts.init();
        return (Font)fonts.get("MiniDialog");
    }

    public static String dialogFontTag(String text) {
        Fonts.init();
        return fonts.get("DialogTag") + text + fonts.get("/DialogTag");
    }

    public static String smallDialogFontTag(String text) {
        Fonts.init();
        return fonts.get("SmallDialogTag") + text + fonts.get("/SmallDialogTag");
    }

    public static String miniDialogFontTag(String text) {
        Fonts.init();
        return fonts.get("MiniDialogTag") + text + fonts.get("/MiniDialogTag");
    }

    public static String emphasizedDialogFontTag(String text) {
        Fonts.init();
        return fonts.get("EmphasizedDialogTag") + text + fonts.get("/EmphasizedDialogTag");
    }

    public static int getVisualAscent(Font f, Component c, char ch) {
        Graphics2D g = (Graphics2D)c.getGraphics();
        FontRenderContext frc = g == null ? defaultFontRenderContext : g.getFontRenderContext();
        GlyphVector gv = f.createGlyphVector(frc, new char[]{ch});
        return -gv.getVisualBounds().getBounds().y;
    }

    public static Rectangle getPerceivedBounds(String str, Font f, Component c) {
        FontRenderContext frc;
        if (str == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Graphics2D g = (Graphics2D)c.getGraphics();
        if (g != null) {
            frc = g.getFontRenderContext();
            g.dispose();
        } else {
            frc = new FontRenderContext(new AffineTransform(), true, true);
        }
        int scriptSystem = str == null || str.length() == 0 ? 0 : ScriptSystem.getScriptSystemOf(str.charAt(0));
        int ascent = Fonts.getPerceivedAscent(f, frc, scriptSystem);
        int descent = Fonts.getPerceivedDescent(f, frc, scriptSystem);
        Rectangle2D stringBounds = f.getStringBounds(str, frc);
        return new Rectangle(1, -ascent, (int)stringBounds.getWidth() - 2, ascent + descent);
    }

    public static int getPerceivedAscent(Font f, FontRenderContext frc, int system) {
        if (ScriptSystem.getBaseline(system) == 2) {
            return 0;
        }
        char ch = ScriptSystem.getMeasurementChar(system);
        GlyphVector gv = f.createGlyphVector(frc, new char[]{ch});
        return gv.getVisualBounds().getBounds().height;
    }

    public static int getPerceivedDescent(Font f, FontRenderContext frc, int system) {
        if (ScriptSystem.getBaseline(system) == 0) {
            return 0;
        }
        char ch = ScriptSystem.getMeasurementChar(system);
        GlyphVector gv = f.createGlyphVector(frc, new char[]{ch});
        Rectangle bounds = gv.getVisualBounds().getBounds();
        return bounds.y + bounds.height;
    }

    static {
        defaultFontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
    }
}

